/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.mbean;

import java.io.Serializable;
import java.util.Locale;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.shared.statistic.BoundedRangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.CountStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.RangeStatisticImpl;
import oracle.oc4j.admin.management.shared.statistic.StatsLocalizationHelper;
import oracle.oc4j.admin.management.shared.statistic.TimeStatisticImpl;
import oracle.oc4j.sql.mbean.DMSUtils;

public class EmptyJDBCConnectionPoolStats
implements JDBCConnectionPoolStats,
Serializable {
    private transient StatsLocalizationHelper m_statsLocalizationHelper = null;
    private String[] m_statisticNames = new String[]{"CreateConnectionCount", "CloseConnectionCount", "PoolSize", "FreePoolSize", "WaitingThreadCount", "WaitTime", "UseTime"};
    private CountStatistic m_createCount = null;
    private CountStatistic m_closeCount = null;
    private BoundedRangeStatistic m_poolSize = null;
    private BoundedRangeStatistic m_freePoolSize = null;
    private RangeStatistic m_waitingThreadCount = null;
    private TimeStatistic m_waitTime = null;
    private TimeStatistic m_useTime = null;

    public EmptyJDBCConnectionPoolStats() {
        this.m_statsLocalizationHelper = DMSUtils.isDMSActive() ? new StatsLocalizationHelper(J2EEManagedObjectBase.getLocaleForCall()) : new StatsLocalizationHelper(Locale.getDefault());
        this.m_createCount = new CountStatisticImpl("CreateConnectionCount", "connections", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_createCountDescription"), 0L, 0L, 0L);
        this.m_closeCount = new CountStatisticImpl("CloseConnectionCount", "connections", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_closeCountDescription"), 0L, 0L, 0L);
        this.m_poolSize = new BoundedRangeStatisticImpl("PoolSize", "connections", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_poolSizeDescription"), 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        this.m_freePoolSize = new BoundedRangeStatisticImpl("FreePoolSize", "connections", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_freePoolSizeDescription"), 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        this.m_waitingThreadCount = new RangeStatisticImpl("WaitingThreadCount", "threads", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_waitingThreadCount"), 0L, 0L, 0L, 0L, 0L);
        this.m_waitTime = new TimeStatisticImpl("WaitTime", "MILLISECOND", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_waitTime"), 0L, 0L, 0L, 0L, 0L, 0L);
        this.m_useTime = new TimeStatisticImpl("UseTime", "MILLISECOND", this.m_statsLocalizationHelper.getLocalizedMessage("connectionpooljdbcresource_useTime"), 0L, 0L, 0L, 0L, 0L, 0L);
    }

    public CountStatistic getCreateCount() {
        return this.m_createCount;
    }

    public CountStatistic getCloseCount() {
        return this.m_closeCount;
    }

    public BoundedRangeStatistic getPoolSize() {
        return this.m_poolSize;
    }

    public BoundedRangeStatistic getFreePoolSize() {
        return this.m_freePoolSize;
    }

    public RangeStatistic getWaitingThreadCount() {
        return this.m_waitingThreadCount;
    }

    public String getJdbcDataSource() {
        return "";
    }

    public TimeStatistic getWaitTime() {
        return this.m_waitTime;
    }

    public TimeStatistic getUseTime() {
        return this.m_useTime;
    }

    public Statistic getStatistic(String statName) {
        if (statName.equals("CreateConnectionCount")) {
            return this.m_createCount;
        }
        if (statName.equals("CloseConnectionCount")) {
            return this.m_closeCount;
        }
        if (statName.equals("PoolSize")) {
            return this.m_poolSize;
        }
        if (statName.equals("FreePoolSize")) {
            return this.m_freePoolSize;
        }
        if (statName.equals("WaitingThreadCount")) {
            return this.m_waitingThreadCount;
        }
        if (statName.equals("WaitTime")) {
            return this.m_waitTime;
        }
        if (statName.equals("UseTime")) {
            return this.m_useTime;
        }
        return null;
    }

    public String[] getStatisticNames() {
        return this.m_statisticNames;
    }

    public Statistic[] getStatistics() {
        Statistic[] stats = new Statistic[]{this.m_createCount, this.m_closeCount, this.m_poolSize, this.m_freePoolSize, this.m_waitingThreadCount, this.m_waitTime, this.m_useTime};
        return stats;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Statistic[] stats = this.getStatistics();
        for (int i = 0; i < stats.length; ++i) {
            buf.append(stats[i].toString());
            buf.append("\n");
        }
        return buf.toString();
    }
}

