/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.xml.XMLUtils;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.DataSourceConfigException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XARecoveryConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "xa-recovery-config";
    public static final String PASSWORD_CREDENTIAL_NODE_NAME = "password-credential";
    public static final String USERNAME_NODE_NAME = "username";
    public static final String PASSWORD_NODE_NAME = "password";
    private Node m_passwordCredentialNode = null;
    private String m_username = null;
    private String m_password = null;

    public XARecoveryConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.m_passwordCredentialNode = XMLUtils.getSubnode(this.getRootNode(), PASSWORD_CREDENTIAL_NODE_NAME);
        this.setUsername();
        this.setPassword();
    }

    public XARecoveryConfig(XARecoveryConfig config) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setUsername(config.getUsername());
        this.setPassword(config.getPassword());
    }

    public XARecoveryConfig(String username, String password) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setUsername(username);
        this.setPassword(password);
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    private void setUsername() {
        if (this.m_passwordCredentialNode != null) {
            this.setUsername(XMLUtils.getSubnodeValue(this.m_passwordCredentialNode, USERNAME_NODE_NAME));
        }
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    private void setPassword() {
        if (this.m_passwordCredentialNode != null) {
            this.setPassword(XMLUtils.getSubnodeValue(this.m_passwordCredentialNode, PASSWORD_NODE_NAME));
        }
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        Element passwordCredentialElement = document.createElement(PASSWORD_CREDENTIAL_NODE_NAME);
        Element userNameElement = document.createElement(USERNAME_NODE_NAME);
        if (this.m_username != null) {
            userNameElement.appendChild(document.createTextNode(this.m_username));
        }
        Element passwordElement = document.createElement(PASSWORD_NODE_NAME);
        if (this.m_password != null) {
            passwordElement.appendChild(document.createTextNode(this.m_password));
        }
        passwordCredentialElement.appendChild(userNameElement);
        passwordCredentialElement.appendChild(passwordElement);
        element.appendChild(passwordCredentialElement);
        return element;
    }
}

