/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.server.XMLDataSourcesConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourcesConfig;

public class ConvertLegacyConfig {
    public ConvertLegacyConfig(String legacyFileName, String convertedFileName) throws ConfigException {
        this.doConversion(legacyFileName, convertedFileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doConversion(String legacyFileName, String convertedFileName) throws ConfigException {
        this.validateFileNames(legacyFileName, convertedFileName);
        File legacyFile = new File(legacyFileName);
        XMLDataSourcesConfig legacyConfig = null;
        try {
            legacyConfig = new XMLDataSourcesConfig(legacyFile.toURL());
        }
        catch (Exception e) {
            throw new ConfigException("Could not convert legacy file: " + legacyFileName, e);
        }
        DataSourcesConfig dataSourcesConfig = legacyConfig.getDataSourcesConfig();
        FileOutputStream fos = null;
        convertedFileName = convertedFileName.trim();
        File convertedFile = new File(convertedFileName);
        try {
            try {
                fos = new FileOutputStream(convertedFile);
                String convertedXML = dataSourcesConfig.createXMLString();
                fos.write(convertedXML.getBytes());
            }
            catch (IOException e) {
                throw new ConfigException("Could not write to converted file: " + convertedFileName, e);
            }
            catch (DataSourceConfigException dataSourceConfigException) {
                throw new ConfigException("Could not write to converted file: " + convertedFileName, dataSourceConfigException);
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (fos == null) return;
        fos.close();
        return;
    }

    public ConvertLegacyConfig(String[] args) throws ConfigException {
        String legacyFileName = null;
        String convertedFileName = null;
        if (args.length > 0) {
            legacyFileName = args[0];
        }
        if (args.length > 1) {
            convertedFileName = args[1];
        }
        this.doConversion(legacyFileName, convertedFileName);
    }

    private void validateFileNames(String legacyFileName, String convertedFileName) throws ConfigException {
        if (legacyFileName == null || legacyFileName.length() == 0) {
            throw new ConfigException("The name of the file to convert cannot be empty.");
        }
        if (convertedFileName == null || convertedFileName.trim().length() == 0) {
            throw new ConfigException("The name of the converted file cannot be empty.");
        }
        File legacyFile = new File(legacyFileName);
        if (!legacyFile.exists()) {
            throw new ConfigException("Could not find the file to convert: " + legacyFileName);
        }
    }

    public static void main(String[] args) {
        try {
            new ConvertLegacyConfig(args);
        }
        catch (ConfigException e) {
            System.out.println("Could not convert configuration file.");
            e.printStackTrace();
        }
    }
}

