/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.config;

import com.evermind.xml.XMLUtils;
import oracle.oc4j.sql.config.ConfigObject;
import oracle.oc4j.sql.config.ConnectionFactoryConfig;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourceConfigUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectionPoolConfig
extends ConfigObject {
    public static final String ROOT_NODE_NAME = "connection-pool";
    public static final String ABANDONED_CONNECTION_TIMEOUT_ATTRIBUTE = "abandoned-connection-timeout";
    public static final String CONNECTION_RETRY_INTERVAL_ATTRIBUTE = "connection-retry-interval";
    public static final String INACTIVITY_TIMEOUT_ATTRIBUTE = "inactivity-timeout";
    public static final String INITIAL_LIMIT_ATTRIBUTE = "initial-limit";
    public static final String LOWER_THRESHOLD_LIMIT = "lower-threshold-limit";
    public static final String PROXY_SESSIONS_ATTRIBUTE = "proxy-sessions";
    public static final String MAX_CONNNECT_ATTEMPTS_ATTRIBUTE = "max-connect-attempts";
    public static final String MAX_CONNECTIONS_ATTRIBUTE = "max-connections";
    public static final String MIN_CONNECTIONS_ATTRIBUTE = "min-connections";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String NUM_CACHED_STATEMENTS_ATTRIBUTE = "num-cached-statements";
    public static final String PROPERTY_CHECK_INTERVAL_ATTRIBUTE = "property-check-interval";
    public static final String TIME_TO_LIVE_TIMEOUT_ATTRIBUTE = "time-to-live-timeout";
    public static final String USED_CONNECTION_WAIT_TIMEOUT_ATTRIBUTE = "used-connection-wait-timeout";
    public static final String DEDICATED_THREAD_CONNECTIONS_ATTRIBUTE = "dedicated-thread-connections";
    public static final String VALIDATE_CONNECTION_ATTRIBUTE = "validate-connection";
    public static final String VALIDATE_CONNECTION_STATEMENT_ATTRIBUTE = "validate-connection-statement";
    public static final String GLOBAL_INSTANCE_NAME_ATTRIBUTE = "global-instance-name";
    public static final int DEFAULT_ABANDONED_CONNECTION_TIMEOUT = 0;
    public static final int DEFAULT_CONNECTION_RETRY_INTERVAL = 1;
    public static final int DEFAULT_INACTIVITY_TIMEOUT = 60;
    public static final int DEFAULT_INITIAL_LIMIT = 0;
    public static final int DEFAULT_LOWER_THRESHOLD_LIMIT = 20;
    public static final int DEFAULT_MAX_CONNECT_ATTEMPTS = 3;
    public static final int DEFAULT_MAX_CONNECTIONS = -1;
    public static final int DEFAULT_MIN_CONNECTIONS = 0;
    public static final int DEFAULT_NUM_CACHED_STATEMENTS = 0;
    public static final int DEFAULT_PROPERTY_CHECK_INTERVAL = 900;
    public static final int DEFAULT_TIME_TO_LIVE_TIMEOUT = 0;
    public static final int DEFAULT_USED_CONNECTION_WAIT_TIMEOUT = 0;
    public static final boolean DEFAULT_DEDICATED_THREAD_CONNECTIONS = false;
    public static final boolean DEFAULT_VALIDATE_CONNECTION = false;
    public static final String DEFAULT_VALIDATE_CONNECTION_STATEMENT = "";
    public static final boolean DEFAULT_PROXY_SESSIONS = false;
    public static final String DEFAULT_GLOBAL_INSTANCE_NAME = "";
    private ConnectionFactoryConfig m_connectionFactoryConfig = null;
    private int m_abandonedConnectionTimeout = 0;
    private int m_connectionRetryInterval = 1;
    private int m_inactivityTimeout = 60;
    private int m_initialLimit = 0;
    private int m_lowerThresholdLimit = 20;
    private boolean m_proxySessions = false;
    private boolean m_dedicatedThreadConnections = false;
    private int m_maxConnectAttempts = 3;
    private int m_maxConnections = -1;
    private int m_minConnections = 0;
    private String m_name = "";
    private int m_numCachedStatements = 0;
    private int m_timeToLiveTimeout = 0;
    private int m_propertyCheckInterval = 900;
    private int m_usedConnectionWaitTimeout = 0;
    private boolean m_validateConnection = false;
    private String m_validateConnectionStatement = "";
    private String m_globalInstanceName = "";

    public ConnectionPoolConfig(Node rootNode) throws DataSourceConfigException {
        super(rootNode);
        this.setConnectionFactory();
        this.setAbandonedConnectionTimeout();
        this.setConnectionRetryInterval();
        this.setInactivityTimeout();
        this.setInitialLimit();
        this.setLowerThresholdLimit();
        this.setProxySessions();
        this.setDedicatedThreadConnections();
        this.setMaxConnectAttempts();
        this.setMaxConnections();
        this.setName();
        this.setMinConnections();
        this.setNumCachedStatements();
        this.setPropertyCheckInterval();
        this.setTimeToLiveTimeout();
        this.setUsedConnectionWaitTimeout();
        this.setValidateConnection();
        this.setValidateConnectionStatement();
        this.setGlobalInstanceName();
    }

    public ConnectionPoolConfig(ConnectionFactoryConfig connectionFactory, String name) throws DataSourceConfigException {
        this(connectionFactory, name, null);
    }

    public ConnectionPoolConfig(ConnectionFactoryConfig connectionFactory, String name, ConnectionPoolConfig connectionPoolConfig) throws DataSourceConfigException {
        super(ROOT_NODE_NAME);
        this.setConnectionFactoryConfig(connectionFactory);
        this.setName(name);
        if (connectionPoolConfig != null) {
            this.setAbandonedConnectionTimeout(connectionPoolConfig.getAbandonedConnectionTimeout());
            this.setConnectionRetryInterval(connectionPoolConfig.getConnectionRetryInterval());
            this.setInactivityTimeout(connectionPoolConfig.getInactivityTimeout());
            this.setInitialLimit(connectionPoolConfig.getInitialLimit());
            this.setLowerThresholdLimit(connectionPoolConfig.getLowerThresholdLimit());
            this.setProxySessions(connectionPoolConfig.isProxySessions());
            this.setDedicatedThreadConnections(connectionPoolConfig.isDedicatedThreadConnections());
            this.setMaxConnectAttempts(connectionPoolConfig.getMaxConnectAttempts());
            this.setMaxConnections(connectionPoolConfig.getMaxConnections());
            this.setMinConnections(connectionPoolConfig.getMinConnections());
            this.setNumCachedStatements(connectionPoolConfig.getNumCachedStatements());
            this.setPropertyCheckInterval(connectionPoolConfig.getPropertyCheckInterval());
            this.setTimeToLiveTimeout(connectionPoolConfig.getTimeToLiveTimeout());
            this.setUsedConnectionWaitTimeout(connectionPoolConfig.getUsedConnectionWaitTimeout());
            this.setValidateConnection(connectionPoolConfig.isValidateConnection());
            this.setValidateConnectionStatement(connectionPoolConfig.getValidateConnectionStatement());
            this.setGlobalInstanceName(connectionPoolConfig.getGlobalInstanceName());
        }
    }

    public ConnectionFactoryConfig getConnectionFactoryConfig() {
        return this.m_connectionFactoryConfig;
    }

    public void setConnectionFactoryConfig(ConnectionFactoryConfig connectionFactoryConfig) throws DataSourceConfigException {
        if (connectionFactoryConfig == null) {
            throw new DataSourceConfigException("The connection factory may not be null.");
        }
        this.m_connectionFactoryConfig = connectionFactoryConfig;
    }

    private void setConnectionFactory() throws DataSourceConfigException {
        this.setConnectionFactoryConfig(new ConnectionFactoryConfig(XMLUtils.getSubnode(this.getRootNode(), "connection-factory")));
    }

    public int getMinConnections() {
        return this.m_minConnections;
    }

    public void setMinConnections(int minConnections) {
        this.m_minConnections = minConnections;
    }

    private void setMinConnections() throws DataSourceConfigException {
        this.setMinConnections(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), MIN_CONNECTIONS_ATTRIBUTE, 0));
    }

    public boolean isProxySessions() {
        return this.m_proxySessions;
    }

    public void setProxySessions(boolean proxySessions) {
        this.m_proxySessions = proxySessions;
    }

    private void setProxySessions() throws DataSourceConfigException {
        this.setProxySessions(DataSourceConfigUtils.getBooleanAttribute(this.getRootNode(), PROXY_SESSIONS_ATTRIBUTE, false));
    }

    public boolean isDedicatedThreadConnections() {
        return this.m_dedicatedThreadConnections;
    }

    public void setDedicatedThreadConnections(boolean dedicatedThreadConnections) {
        this.m_dedicatedThreadConnections = dedicatedThreadConnections;
    }

    private void setDedicatedThreadConnections() throws DataSourceConfigException {
        this.setDedicatedThreadConnections(DataSourceConfigUtils.getBooleanAttribute(this.getRootNode(), DEDICATED_THREAD_CONNECTIONS_ATTRIBUTE, false));
    }

    public int getMaxConnections() {
        return this.m_maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.m_maxConnections = maxConnections;
    }

    private void setMaxConnections() throws DataSourceConfigException {
        this.setMaxConnections(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), MAX_CONNECTIONS_ATTRIBUTE, -1));
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) throws DataSourceConfigException {
        this.m_name = DataSourceConfigUtils.trimEmptyNotAllowed(name, NAME_ATTRIBUTE);
    }

    private void setName() throws DataSourceConfigException {
        this.setName(DataSourceConfigUtils.getAttribute(this.getRootNode(), NAME_ATTRIBUTE));
    }

    public int getUsedConnectionWaitTimeout() {
        return this.m_usedConnectionWaitTimeout;
    }

    public void setUsedConnectionWaitTimeout(int usedConnectionWaitTimeout) {
        this.m_usedConnectionWaitTimeout = usedConnectionWaitTimeout;
    }

    private void setUsedConnectionWaitTimeout() throws DataSourceConfigException {
        this.setUsedConnectionWaitTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), USED_CONNECTION_WAIT_TIMEOUT_ATTRIBUTE, 0));
    }

    public int getInactivityTimeout() {
        return this.m_inactivityTimeout;
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.m_inactivityTimeout = inactivityTimeout;
    }

    private void setInactivityTimeout() throws DataSourceConfigException {
        this.setInactivityTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), INACTIVITY_TIMEOUT_ATTRIBUTE, 60));
    }

    public int getInitialLimit() {
        return this.m_initialLimit;
    }

    public void setInitialLimit(int limit) {
        this.m_initialLimit = limit;
    }

    private void setInitialLimit() throws DataSourceConfigException {
        this.setInitialLimit(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), INITIAL_LIMIT_ATTRIBUTE, 0));
    }

    public int getLowerThresholdLimit() {
        return this.m_lowerThresholdLimit;
    }

    public void setLowerThresholdLimit(int lowerThresholdLimit) {
        this.m_lowerThresholdLimit = lowerThresholdLimit;
    }

    protected void setLowerThresholdLimit() throws DataSourceConfigException {
        this.setLowerThresholdLimit(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), LOWER_THRESHOLD_LIMIT, 20));
    }

    public int getConnectionRetryInterval() {
        return this.m_connectionRetryInterval;
    }

    public void setConnectionRetryInterval(int connectionRetryInterval) {
        this.m_connectionRetryInterval = connectionRetryInterval;
    }

    private void setConnectionRetryInterval() throws DataSourceConfigException {
        this.setConnectionRetryInterval(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), CONNECTION_RETRY_INTERVAL_ATTRIBUTE, 1));
    }

    public int getMaxConnectAttempts() {
        return this.m_maxConnectAttempts;
    }

    public void setMaxConnectAttempts(int maxConnectAttempts) {
        this.m_maxConnectAttempts = maxConnectAttempts;
    }

    private void setMaxConnectAttempts() throws DataSourceConfigException {
        this.setMaxConnectAttempts(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), MAX_CONNNECT_ATTEMPTS_ATTRIBUTE, 3));
    }

    public boolean isValidateConnection() {
        return this.m_validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.m_validateConnection = validateConnection;
    }

    private void setValidateConnection() {
        this.setValidateConnection(DataSourceConfigUtils.getBooleanAttribute(this.getRootNode(), VALIDATE_CONNECTION_ATTRIBUTE, false));
    }

    public String getValidateConnectionStatement() {
        return this.m_validateConnectionStatement;
    }

    public void setValidateConnectionStatement(String validateConnectionStatement) {
        if (validateConnectionStatement == null) {
            validateConnectionStatement = "";
        }
        this.m_validateConnectionStatement = validateConnectionStatement.trim();
        if (this.m_validateConnectionStatement.length() == 0) {
            this.m_validateConnectionStatement = "";
        }
    }

    private void setValidateConnectionStatement() {
        this.setValidateConnectionStatement(DataSourceConfigUtils.getAttribute(this.getRootNode(), VALIDATE_CONNECTION_STATEMENT_ATTRIBUTE));
    }

    public String getGlobalInstanceName() {
        return this.m_globalInstanceName;
    }

    public void setGlobalInstanceName(String globalInstanceName) {
        if (globalInstanceName == null) {
            globalInstanceName = "";
        }
        this.m_globalInstanceName = globalInstanceName.trim();
        if (this.m_globalInstanceName.length() == 0) {
            this.m_globalInstanceName = "";
        }
    }

    private void setGlobalInstanceName() {
        this.setGlobalInstanceName(DataSourceConfigUtils.getAttribute(this.getRootNode(), GLOBAL_INSTANCE_NAME_ATTRIBUTE));
    }

    public int getNumCachedStatements() {
        return this.m_numCachedStatements;
    }

    public void setNumCachedStatements(int numCachedStatements) {
        this.m_numCachedStatements = numCachedStatements;
    }

    private void setNumCachedStatements() throws DataSourceConfigException {
        this.setNumCachedStatements(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), NUM_CACHED_STATEMENTS_ATTRIBUTE, 0));
    }

    public int getPropertyCheckInterval() {
        return this.m_propertyCheckInterval;
    }

    public void setPropertyCheckInterval(int propertyCheckInterval) {
        this.m_propertyCheckInterval = propertyCheckInterval;
    }

    private void setPropertyCheckInterval() throws DataSourceConfigException {
        this.setPropertyCheckInterval(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), PROPERTY_CHECK_INTERVAL_ATTRIBUTE, 900));
    }

    public int getTimeToLiveTimeout() {
        return this.m_timeToLiveTimeout;
    }

    public void setTimeToLiveTimeout(int timeToLiveTimeout) {
        this.m_timeToLiveTimeout = timeToLiveTimeout;
    }

    private void setTimeToLiveTimeout() throws DataSourceConfigException {
        this.setTimeToLiveTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), TIME_TO_LIVE_TIMEOUT_ATTRIBUTE, 0));
    }

    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout;
    }

    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) {
        this.m_abandonedConnectionTimeout = abandonedConnectionTimeout;
    }

    private void setAbandonedConnectionTimeout() throws DataSourceConfigException {
        this.setAbandonedConnectionTimeout(DataSourceConfigUtils.getIntAttribute(this.getRootNode(), ABANDONED_CONNECTION_TIMEOUT_ATTRIBUTE, 0));
    }

    protected Node createXML(Document document) throws Exception {
        Element element = document.createElement(ROOT_NODE_NAME);
        element.setAttribute(NAME_ATTRIBUTE, this.m_name);
        this.addAttribute(element, this.m_abandonedConnectionTimeout, ABANDONED_CONNECTION_TIMEOUT_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_connectionRetryInterval, CONNECTION_RETRY_INTERVAL_ATTRIBUTE, 1);
        this.addAttribute(element, this.m_inactivityTimeout, INACTIVITY_TIMEOUT_ATTRIBUTE, 60);
        this.addAttribute(element, this.m_initialLimit, INITIAL_LIMIT_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_lowerThresholdLimit, LOWER_THRESHOLD_LIMIT, 20);
        this.addAttribute(element, this.m_dedicatedThreadConnections, DEDICATED_THREAD_CONNECTIONS_ATTRIBUTE, false);
        this.addAttribute(element, this.m_proxySessions, PROXY_SESSIONS_ATTRIBUTE, false);
        this.addAttribute(element, this.m_maxConnectAttempts, MAX_CONNNECT_ATTEMPTS_ATTRIBUTE, 3);
        this.addAttribute(element, this.m_maxConnections, MAX_CONNECTIONS_ATTRIBUTE, -1);
        this.addAttribute(element, this.m_minConnections, MIN_CONNECTIONS_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_numCachedStatements, NUM_CACHED_STATEMENTS_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_propertyCheckInterval, PROPERTY_CHECK_INTERVAL_ATTRIBUTE, 900);
        this.addAttribute(element, this.m_timeToLiveTimeout, TIME_TO_LIVE_TIMEOUT_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_usedConnectionWaitTimeout, USED_CONNECTION_WAIT_TIMEOUT_ATTRIBUTE, 0);
        this.addAttribute(element, this.m_validateConnection, VALIDATE_CONNECTION_ATTRIBUTE, false);
        this.addAttribute(element, this.m_validateConnectionStatement, VALIDATE_CONNECTION_STATEMENT_ATTRIBUTE, "");
        this.addAttribute(element, this.m_globalInstanceName, GLOBAL_INSTANCE_NAME_ATTRIBUTE, "");
        element.appendChild(this.m_connectionFactoryConfig.createXML(document));
        return element;
    }

    private void addAttribute(Element element, int attributeValue, String attributeName, int defaultValue) {
        if (attributeValue != defaultValue) {
            element.setAttribute(attributeName, new Integer(attributeValue).toString());
        }
    }

    private void addAttribute(Element element, boolean attributeValue, String attributeName, boolean defaultValue) {
        if (attributeValue != defaultValue) {
            element.setAttribute(attributeName, new Boolean(attributeValue).toString());
        }
    }

    private void addAttribute(Element element, String attributeValue, String attributeName, String defaultValue) {
        if (!attributeValue.equals(defaultValue)) {
            element.setAttribute(attributeName, attributeValue);
        }
    }
}

