/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.oc4j.sql.proxy.ConnectionBCELProxy;

public class PooledConnectionImpl
implements PooledConnection {
    private Vector m_connectionEventListeners = new Vector();
    private Connection m_physicalConnection = null;
    private static Map m_proxySuperClassMap = new HashMap();

    public PooledConnectionImpl(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("The connection can not be null.");
        }
        this.m_physicalConnection = connection;
    }

    public Connection getConnection() throws SQLException {
        return this.m_physicalConnection;
    }

    public void close() throws SQLException {
        this.m_physicalConnection.close();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.m_connectionEventListeners.contains(listener)) {
            this.m_connectionEventListeners.add(listener);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.m_connectionEventListeners.remove(listener);
    }

    public void fireConnectionClosedEvent() {
        this.fireConnectionEvent(new ConnectionEvent(this), true);
    }

    public void fireConnectionErrorEvent(SQLException sqlException) {
        this.fireConnectionEvent(new ConnectionEvent(this, sqlException), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEvent(ConnectionEvent connectionEvent, boolean eventConnectionClosed) {
        ConnectionEventListener connectionEventListener = null;
        Object[] eventListeners = null;
        Vector vector = this.m_connectionEventListeners;
        synchronized (vector) {
            eventListeners = this.m_connectionEventListeners.toArray();
        }
        int numConnectionEventListeners = eventListeners.length;
        for (int curConnectionEventListener = 0; curConnectionEventListener < numConnectionEventListeners; ++curConnectionEventListener) {
            connectionEventListener = (ConnectionEventListener)eventListeners[curConnectionEventListener];
            if (eventConnectionClosed) {
                connectionEventListener.connectionClosed(connectionEvent);
                continue;
            }
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    public Connection getPhysicalConnection() {
        return this.m_physicalConnection;
    }

    static {
        m_proxySuperClassMap.put(Connection.class, ConnectionBCELProxy.class);
    }
}

