/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import oracle.dms.instrument.NounIntf;
import oracle.j2ee.datasource.DataSourceMessages;
import oracle.oc4j.sql.BaseDataSource;
import oracle.oc4j.sql.CommonDataSource;
import oracle.oc4j.sql.DataSourceConnectionPool;
import oracle.oc4j.sql.DataSourceException;
import oracle.oc4j.sql.DataSourceUtils;
import oracle.oc4j.sql.ManagedDataSourceDebugInfo;
import oracle.oc4j.sql.NonTransactionalConnectionFactory;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionPoolStats;
import oracle.oc4j.sql.mbean.DMSJDBCConnectionStats;
import oracle.oc4j.sql.mbean.DMSUtils;
import oracle.oc4j.sql.mbean.ManagedJDBCDataSource;
import oracle.oc4j.sql.spi.ConnectionHandle;
import oracle.oc4j.sql.spi.ConnectionRequestInfoImpl;
import oracle.oc4j.sql.spi.ManagedConnectionFactoryImpl;

public class ManagedDataSource
extends BaseDataSource
implements CommonDataSource,
NonTransactionalConnectionFactory,
Referenceable,
Serializable {
    private transient ManagedDataSourceDebugInfo m_debug = new ManagedDataSourceDebugInfo();
    private ConnectionManager m_connectionManger;
    private ManagedConnectionFactoryImpl m_managedConnectionFactory;
    private Reference m_reference;
    private int m_connectionRetryInterval = 0;
    private int m_maxConnectAttempts = 3;
    private transient ManagedJDBCDataSource m_mBean = null;
    private transient WeakHashMap m_dmsConnectionStatMap = new WeakHashMap();
    private transient WeakHashMap m_unStattedConnections = new WeakHashMap();
    private Object[] m_unStattedConnectionsLock = new Object[0];
    private boolean m_manageLocalTransactions = true;
    private String m_manageSqlObjects = "basic";

    public ManagedDataSource(ManagedConnectionFactoryImpl managedConnectionFactory, ConnectionManager connectionManager) {
        this.m_managedConnectionFactory = managedConnectionFactory;
        this.m_connectionManger = connectionManager;
        try {
            DataSourceConnectionPool connectionPool;
            ManagedDataSourceConfig mdsc = managedConnectionFactory.getManagedDataSourceConfig();
            if (mdsc != null) {
                this.setUser(mdsc.getUser());
                this.setPassword(mdsc.getPassword());
                this.setDataSourceName(mdsc.getName());
                this.setLoginTimeout(mdsc.getLoginTimeout());
                this.setManageLocalTransactions(mdsc.getManageLocalTransactions());
                this.setManageSqlObjects(mdsc.getManageSqlObjects());
            }
            if ((connectionPool = managedConnectionFactory.getDataSourceConnectionPool()) != null) {
                ConnectionPoolConfig connectionPoolConfig = connectionPool.getConfig();
                this.setMaxConnectAttempts(connectionPoolConfig.getMaxConnectAttempts());
                this.setConnectionRetryInterval(connectionPoolConfig.getConnectionRetryInterval());
            }
        }
        catch (DataSourceException dataSourceException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        ConnectionRequestInfoImpl connectionRequestInfo = new ConnectionRequestInfoImpl(username, password, this.m_managedConnectionFactory.supportsGlobalTx());
        return this.getConnection(connectionRequestInfo);
    }

    public Connection getNonTransactionalConnection() throws SQLException {
        return this.getNonTransactionalConnection(this.getUser(), this.getPassword());
    }

    public Connection getNonTransactionalConnection(String username, String password) throws SQLException {
        ConnectionRequestInfoImpl connectionRequestInfo = new ConnectionRequestInfoImpl(username, password, false);
        return this.getConnection(connectionRequestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Connection getConnection(ConnectionRequestInfoImpl connectionRequestInfo) throws SQLException {
        Connection connection = null;
        ResourceException resourceException = null;
        DMSJDBCConnectionPoolStats connectionPoolStats = null;
        long beginWaitTime = 0L;
        int attemptsMade = 0;
        if (DMSUtils.isDMSActive() && this.m_mBean != null && (connectionPoolStats = this.m_mBean.getDmsConnectionPoolStats()) != null) {
            connectionPoolStats.incrementWaitingThreadCount(1L);
        }
        try {
            beginWaitTime = System.currentTimeMillis();
            boolean isRetryStage = false;
            DataSourceConnectionPool connectionPool = this.m_managedConnectionFactory.getDataSourceConnectionPool();
            while (true) {
                Connection waitTime2;
                try {
                    connection = this.getConnection(connectionRequestInfo, connectionPool);
                    if (DMSUtils.isDMSActive() && connection != null) {
                        long waitTime2 = System.currentTimeMillis() - beginWaitTime;
                        ((ConnectionHandle)connection).oc4j_setWaitTime(waitTime2);
                        Object[] objectArray = this.m_unStattedConnectionsLock;
                        // MONITORENTER : this.m_unStattedConnectionsLock
                        this.m_unStattedConnections.put(connection, null);
                        // MONITOREXIT : objectArray
                        if (connectionPoolStats != null) {
                            connectionPoolStats.incrementWaitTime(waitTime2);
                        }
                    }
                    waitTime2 = connection;
                }
                catch (ResourceException e) {
                    block17: {
                        block16: {
                            resourceException = e;
                            if (++attemptsMade < this.m_maxConnectAttempts) break block16;
                            SQLException sqlException = this.extractRealSQLException(resourceException);
                            if (sqlException == null || !DataSourceUtils.isOracleFatalError(sqlException) || isRetryStage) break block17;
                            try {
                                connectionPool.refreshConnectionPool();
                            }
                            catch (DataSourceException dataSourceException) {
                                DataSourceMessages.warningHandleFatalErrorException(dataSourceException);
                            }
                            --attemptsMade;
                            isRetryStage = true;
                        }
                        try {
                            if (this.m_connectionRetryInterval <= 0) continue;
                            Thread.sleep(this.m_connectionRetryInterval * 1000);
                        }
                        catch (InterruptedException ie) {
                            throw new SQLException(ie.toString());
                        }
                        continue;
                    }
                    Object var15_16 = null;
                    if (DMSUtils.isDMSActive() && connectionPoolStats != null) {
                        connectionPoolStats.incrementWaitingThreadCount(-1L);
                    }
                }
                Object var15_15 = null;
                if (!DMSUtils.isDMSActive()) return waitTime2;
                if (connectionPoolStats == null) return waitTime2;
                connectionPoolStats.incrementWaitingThreadCount(-1L);
                return waitTime2;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (!DMSUtils.isDMSActive()) throw throwable;
            if (connectionPoolStats == null) throw throwable;
            connectionPoolStats.incrementWaitingThreadCount(-1L);
            throw throwable;
        }
        if (!(resourceException.getCause() instanceof SQLException)) throw new SQLException(resourceException.toString());
        throw (SQLException)resourceException.getCause();
    }

    private Connection getConnection(ConnectionRequestInfoImpl connectionRequestInfo, DataSourceConnectionPool connectionPool) throws ResourceException {
        Connection connection = (Connection)this.m_connectionManger.allocateConnection((ManagedConnectionFactory)this.m_managedConnectionFactory, (ConnectionRequestInfo)connectionRequestInfo);
        if (connection != null) {
            String validateConnectionStatement = connectionPool.getConfig().getValidateConnectionStatement();
            if (connection instanceof ConnectionHandle && connectionPool.getConfig().isValidateConnection() && (!connectionPool.isICC() || validateConnectionStatement != null && validateConnectionStatement.length() != 0)) {
                try {
                    ((ConnectionHandle)connection).oc4j_validate(validateConnectionStatement);
                }
                catch (SQLException e) {
                    ResourceException re = new ResourceException();
                    re.initCause((Throwable)e);
                    throw re;
                }
            }
        }
        if (DataSourceMessages.LOG_LEVEL_FINER_OR_HIGHER) {
            this.m_debug.connectionOpened(connection);
        }
        return connection;
    }

    private SQLException extractRealSQLException(Throwable thrownException) {
        SQLException sqlException = null;
        while (thrownException != null) {
            if (thrownException instanceof SQLException) {
                sqlException = (SQLException)thrownException;
            }
            thrownException = thrownException.getCause();
        }
        return sqlException;
    }

    public void setReference(Reference ref) {
        this.m_reference = ref;
    }

    public Reference getReference() throws NamingException {
        return this.m_reference;
    }

    public ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }

    public int getConnectionRetryInterval() {
        return this.m_connectionRetryInterval;
    }

    public void setConnectionRetryInterval(int connectionRetryInterval) {
        this.m_connectionRetryInterval = connectionRetryInterval <= 0 ? 0 : connectionRetryInterval;
    }

    public int getMaxConnectAttempts() {
        return this.m_maxConnectAttempts;
    }

    public void setMaxConnectAttempts(int maxConnectAttempts) {
        this.m_maxConnectAttempts = maxConnectAttempts <= 0 ? 1 : maxConnectAttempts;
    }

    public boolean isOracle() {
        return this.m_managedConnectionFactory.isOracle();
    }

    public ManagedJDBCDataSource getMBean() {
        return this.m_mBean;
    }

    public void setMBean(ManagedJDBCDataSource mBean) {
        this.m_mBean = mBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDMSConnectionStats(Connection connection) {
        if (DMSUtils.isDMSActive()) {
            WeakHashMap weakHashMap = this.m_dmsConnectionStatMap;
            synchronized (weakHashMap) {
                NounIntf noun;
                DMSJDBCConnectionStats stat = (DMSJDBCConnectionStats)this.m_dmsConnectionStatMap.remove(connection);
                if (stat != null && (noun = stat.getDmsNoun()) != null) {
                    noun.destroy();
                }
            }
        }
    }

    private void addDMSConnectionStats(ConnectionHandle connection) {
        DMSJDBCConnectionStats oneStat = new DMSJDBCConnectionStats(this.m_mBean.getCallBack().getJ2EEApplicationCallBackIf().getApplicationNoun(), "connection " + connection.hashCode());
        oneStat.startUseTime(connection.oc4j_getCreateTime());
        oneStat.setWaitTime(connection.oc4j_getWaitTime());
        this.m_dmsConnectionStatMap.put(connection, oneStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DMSJDBCConnectionStats[] getDmsConnectionStats() {
        DMSJDBCConnectionStats[] dmsConnectionStats = null;
        if (DMSUtils.isDMSActive() && this.m_mBean != null) {
            WeakHashMap weakHashMap = this.m_dmsConnectionStatMap;
            synchronized (weakHashMap) {
                WeakHashMap unstattedConnections = null;
                Object[] objectArray = this.m_unStattedConnectionsLock;
                synchronized (this.m_unStattedConnectionsLock) {
                    unstattedConnections = this.m_unStattedConnections;
                    this.m_unStattedConnections = new WeakHashMap();
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    Iterator iterator = unstattedConnections.keySet().iterator();
                    while (iterator.hasNext()) {
                        ConnectionHandle handle = (ConnectionHandle)iterator.next();
                        if (handle.oc4j_getIsClosed() || !DMSUtils.isDMSActive() || this.m_dmsConnectionStatMap.get(handle) != null) continue;
                        this.addDMSConnectionStats(handle);
                    }
                    int numStats = this.m_dmsConnectionStatMap.size();
                    dmsConnectionStats = new DMSJDBCConnectionStats[numStats];
                    Iterator iterator2 = this.m_dmsConnectionStatMap.values().iterator();
                    int statNum = 0;
                    while (iterator2.hasNext()) {
                        dmsConnectionStats[statNum] = (DMSJDBCConnectionStats)iterator2.next();
                        dmsConnectionStats[statNum].updateUseTime();
                        ++statNum;
                    }
                }
            }
        }
        dmsConnectionStats = new DMSJDBCConnectionStats[]{};
        return dmsConnectionStats;
    }

    public void cleanupConnection(Connection connection) {
        if (DMSUtils.isDMSActive()) {
            this.removeDMSConnectionStats(connection);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.m_dmsConnectionStatMap = new WeakHashMap();
        this.m_unStattedConnections = new WeakHashMap();
    }

    public ManagedDataSourceDebugInfo getDebug() {
        return this.m_debug;
    }

    public boolean getManageLocalTransactions() {
        return this.m_manageLocalTransactions;
    }

    public void setManageLocalTransactions(boolean manageLocalTransactions) {
        this.m_manageLocalTransactions = manageLocalTransactions;
    }

    public String getManageSqlObjects() {
        return this.m_manageSqlObjects;
    }

    public void setManageSqlObjects(String manageSqlObjects) {
        this.m_manageSqlObjects = manageSqlObjects;
        this.m_managedConnectionFactory.setManageSqlObjectsDirty();
    }
}

