/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql;

import com.evermind.server.connector.ContainerAuthenticationData;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import oracle.j2ee.connector.ConnectionPoolConnFactory;
import oracle.j2ee.connector.ConnectionPoolConnFactoryContext;
import oracle.oc4j.sql.spi.ConnectionRequestInfoImpl;

public class ConnectionPoolImpl
extends oracle.j2ee.connector.ConnectionPoolImpl {
    private ThreadLocal m_cachedConnection = new ThreadLocal();
    private boolean m_dedicatedThreadConnections = true;

    public void setDedicatedThreadConnections(boolean dedicatedThreadConnections) {
        this.m_dedicatedThreadConnections = dedicatedThreadConnections;
    }

    public ManagedConnection getManagedConnection(ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) throws ResourceException {
        if (!this.m_dedicatedThreadConnections || context.getConnectionRequestInfo() != null && !((ConnectionRequestInfoImpl)context.getConnectionRequestInfo()).isTransactional()) {
            return super.getManagedConnection(factory, context);
        }
        CachedConnectionEntry cachedEntry = (CachedConnectionEntry)this.m_cachedConnection.get();
        if (cachedEntry == null) {
            ManagedConnection mc = super.getManagedConnection(factory, context);
            CachedConnectionEntry connectionEntry = new CachedConnectionEntry(mc, factory, context);
            connectionEntry.setInuse(true);
            this.m_cachedConnection.set(connectionEntry);
            return mc;
        }
        if (!cachedEntry.isInuse() && cachedEntry.isMatch(context)) {
            return cachedEntry.getManagedConnection();
        }
        return super.getManagedConnection(factory, context);
    }

    public void connectionClosed(ConnectionPoolConnFactory factory, ManagedConnection mc, boolean discard) {
        CachedConnectionEntry cachedEntry;
        if (this.m_dedicatedThreadConnections && (cachedEntry = (CachedConnectionEntry)this.m_cachedConnection.get()) != null && cachedEntry.getManagedConnection() == mc) {
            if (discard) {
                this.m_cachedConnection.set(null);
            }
            cachedEntry.setInuse(false);
            return;
        }
        super.connectionClosed(factory, mc, discard);
    }

    class CachedConnectionEntry {
        private ManagedConnection m_managedConnection;
        private ConnectionPoolConnFactory m_factory;
        private ConnectionPoolConnFactoryContext m_context;
        private boolean m_inuse;

        public CachedConnectionEntry(ManagedConnection managedConnection, ConnectionPoolConnFactory factory, ConnectionPoolConnFactoryContext context) {
            this.m_managedConnection = managedConnection;
            this.m_factory = factory;
            this.m_context = context;
        }

        public boolean isMatch(ConnectionPoolConnFactoryContext context) {
            Subject mySubject = null;
            ContainerAuthenticationData myContainerAuthenticationData = this.m_context.getContainerAuthenticationData();
            if (myContainerAuthenticationData != null) {
                mySubject = myContainerAuthenticationData.getSubject();
            }
            Subject subject = null;
            ContainerAuthenticationData containerAuthenticationData = this.m_context.getContainerAuthenticationData();
            if (containerAuthenticationData != null) {
                subject = containerAuthenticationData.getSubject();
            }
            if (mySubject != null ? !mySubject.equals(subject) : subject != null) {
                return false;
            }
            ConnectionRequestInfo myInfo = this.m_context.getConnectionRequestInfo();
            ConnectionRequestInfo info = context.getConnectionRequestInfo();
            return !(myInfo != null ? !myInfo.equals(info) : info != null);
        }

        protected void finalize() throws Throwable {
            ConnectionPoolImpl.this.connectionClosed(this.m_factory, this.m_managedConnection, false);
            super.finalize();
        }

        public boolean isInuse() {
            return this.m_inuse;
        }

        public void setInuse(boolean inuse) {
            this.m_inuse = inuse;
        }

        public ManagedConnection getManagedConnection() {
            return this.m_managedConnection;
        }
    }
}

