/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.util.Base64Utils;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Mac;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SigningAlias;
import oracle.oc4j.security.SigningContext;
import oracle.oc4j.security.SigningKey;

public final class Signing {
    static final String MAC_ALGO = "HmacMD5";
    static final String SIG_ALGO = "DSA";
    static final int SIG_BITS = 1024;
    private static final Signing s_singleton = new Signing(null);
    private SigningContext m_context;

    Signing(SigningContext context) {
        this.m_context = null == context ? new SigningContext() : context;
    }

    private SignatureException error(Exception e) {
        if (e instanceof SignatureException) {
            return (SignatureException)e;
        }
        SignatureException se = new SignatureException(e.getMessage());
        se.initCause(e);
        return se;
    }

    public static Signing getInstance() {
        OC4JSecurity.assertIsSafe();
        return s_singleton;
    }

    void resetContext() {
        this.m_context = new SigningContext();
    }

    public void registerContext(SigningContext context) throws SignatureException {
        this.m_context.registerContext(context);
    }

    public SigningOperator getSigningOperator(SigningContext context, long nonce) throws SignatureException {
        SigningOperator op = this.getSigningOperator(this.getKey(context), nonce);
        if (null == op) {
            op = this.getSigningOperator(this.getAlias(context), nonce);
        }
        return op;
    }

    public SigningOperator getSigningOperator(SigningAlias alias, long nonce) throws SignatureException {
        return this.getSigningOperator(this.findKey(alias), nonce);
    }

    public SigningOperator getSigningOperator(SigningKey key, long nonce) throws SignatureException {
        if (null == key) {
            throw new SignatureException("unknown context");
        }
        try {
            if (key.isSymmetric()) {
                return new SymmetricSigningOperator(key, nonce);
            }
            return new ASymmetricSigningOperator(key, nonce);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    public VerifyOperator getVerifyOperator(SigningContext context, long nonce) throws SignatureException {
        VerifyOperator op = this.getVerifyOperator(this.getKey(context), nonce);
        if (null == op) {
            op = this.getVerifyOperator(this.getAlias(context), nonce);
        }
        return op;
    }

    public VerifyOperator getVerifyOperator(SigningAlias alias, long nonce) throws SignatureException {
        return this.getVerifyOperator(this.findKey(alias), nonce);
    }

    public VerifyOperator getVerifyOperator(SigningKey key, long nonce) throws SignatureException {
        if (null == key) {
            throw new SignatureException("unknown context");
        }
        try {
            if (key.isSymmetric()) {
                return new SymmetricVerifyOperator(key, nonce);
            }
            return new ASymmetricVerifyOperator(key, nonce);
        }
        catch (Exception e) {
            throw this.error(e);
        }
    }

    private SigningAlias getAlias(SigningContext context) {
        return null == context ? null : context.getAlias();
    }

    private SigningKey getKey(SigningContext context) throws SignatureException {
        return null == context ? null : context.getKey();
    }

    private SigningKey findKey(SigningAlias alias) throws SignatureException {
        return null == alias ? null : this.m_context.getKey(alias);
    }

    static final class ASymmetricVerifyOperator
    extends ASymmetricSigningOperator
    implements VerifyOperator {
        ASymmetricVerifyOperator(SigningKey secret, long nonce) throws Exception {
            this.m_signature = Signature.getInstance(Signing.SIG_ALGO);
            this.m_signature.initVerify(secret.getPublicKey());
            this.update(String.valueOf(nonce).getBytes());
        }

        public boolean verify(String signature) throws SignatureException {
            byte[] raw = null == signature ? null : Base64Utils.decode(signature.toCharArray());
            return this.m_signature.verify(raw);
        }
    }

    static class ASymmetricSigningOperator
    implements SigningOperator {
        protected Signature m_signature;
        private String m_signatureStr;

        ASymmetricSigningOperator() {
        }

        ASymmetricSigningOperator(SigningKey secret, long nonce) throws Exception {
            this.m_signature = Signature.getInstance(Signing.SIG_ALGO);
            this.m_signature.initSign((PrivateKey)secret.getSecretKey());
            this.update(String.valueOf(nonce).getBytes());
        }

        public void update(Object input) throws SignatureException {
            this.update(null == input ? (byte[])null : input.toString().getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(byte[] input) throws SignatureException {
            if (null == input || input.length <= 0) {
                return;
            }
            Signature signature = this.m_signature;
            synchronized (signature) {
                if (null != this.m_signatureStr) {
                    throw new SignatureException("update prohibited after signature generated");
                }
                this.m_signature.update(input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSignature() throws SignatureException {
            if (null == this.m_signatureStr) {
                Signature signature = this.m_signature;
                synchronized (signature) {
                    if (null == this.m_signatureStr) {
                        this.m_signatureStr = new String(Base64Utils.encode(this.m_signature.sign()));
                    }
                }
            }
            return this.m_signatureStr;
        }
    }

    static final class SymmetricVerifyOperator
    extends SymmetricSigningOperator
    implements VerifyOperator {
        SymmetricVerifyOperator(SigningKey secret, long nonce) throws Exception {
            super(secret, nonce);
        }

        public boolean verify(String signature) throws SignatureException {
            return this.getSignature().equals(signature);
        }
    }

    static class SymmetricSigningOperator
    implements SigningOperator {
        private Mac m_mac = Mac.getInstance("HmacMD5");
        private String m_hash;

        SymmetricSigningOperator(SigningKey secret, long nonce) throws Exception {
            this.m_mac.init(secret.getSecretKey());
            this.update(String.valueOf(nonce).getBytes());
        }

        public void update(Object input) throws SignatureException {
            this.update(null == input ? (byte[])null : input.toString().getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(byte[] input) throws SignatureException {
            if (null == input || input.length <= 0) {
                return;
            }
            Mac mac = this.m_mac;
            synchronized (mac) {
                if (null != this.m_hash) {
                    throw new SignatureException("update prohibited after signature generated");
                }
                this.m_mac.update(input);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getSignature() throws SignatureException {
            if (null == this.m_hash) {
                Mac mac = this.m_mac;
                synchronized (mac) {
                    if (null == this.m_hash) {
                        this.m_hash = new String(Base64Utils.encode(this.m_mac.doFinal()));
                    }
                }
            }
            return this.m_hash;
        }
    }

    public static interface VerifyOperator
    extends Operator {
        public boolean verify(String var1) throws SignatureException;
    }

    public static interface SigningOperator
    extends Operator {
        public String getSignature() throws SignatureException;
    }

    public static interface Operator {
        public void update(Object var1) throws SignatureException;

        public void update(byte[] var1) throws SignatureException;
    }
}

