/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import java.security.Permission;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.OC4JSecurityStrategy;

public class OC4JSecurityStrategyInternalPermissions
implements OC4JSecurityStrategy {
    private static final Permission INTERNAL_PERMISSION = OC4JSecurity.getRuntimePermission("OC4JOnly");
    private boolean m_defaultToUseAccessController;

    public OC4JSecurityStrategyInternalPermissions(boolean defaultToUseAccessController) {
        this.m_defaultToUseAccessController = defaultToUseAccessController;
    }

    public void checkInternalPermissions() {
        this.checkPermission(INTERNAL_PERMISSION);
    }

    public void checkPermission(Permission permission) {
        OC4JSecurity.checkPermission(permission, this.m_defaultToUseAccessController);
    }

    public void assertIsSafeContext() {
        this.checkInternalPermissions();
    }

    public boolean isSafeContext() {
        try {
            this.checkInternalPermissions();
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }
}

