/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.security;

import com.evermind.util.SecurityProperties;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.CryptoException;
import oracle.oc4j.security.KeyExchange;
import oracle.oc4j.security.KeyExchangeMessages;
import oracle.oc4j.security.KeyExchangeParameterSpec;

public class ExchangingEncryptor
implements Serializable {
    public static final long serialVersionUID = 6317597310313702019L;
    public static final String DEFAULT_ENCRYPTION_ALG = "DES";
    public static final String CHARSET_NAME = "UTF8";
    static Logger s_logger = TraceLogger.getLogger(ExchangingEncryptor.class);
    private String m_encryptionAlg;
    private KeyExchange m_keyExchange;
    private KeyExchangeParameterSpec m_parameterSpec;

    public ExchangingEncryptor() {
        this.m_encryptionAlg = DEFAULT_ENCRYPTION_ALG;
        this.init();
    }

    protected ExchangingEncryptor(String encryptionAlg, KeyExchangeParameterSpec parameterSpec) {
        this.m_encryptionAlg = null == encryptionAlg ? DEFAULT_ENCRYPTION_ALG : encryptionAlg;
        this.m_parameterSpec = parameterSpec;
        this.init();
    }

    public static ExchangingEncryptor create() {
        if (ExchangingEncryptor.isEncryptorOverriddenInEnvironment()) {
            return ExchangingEncryptor.createFromEnvironment();
        }
        return new ExchangingEncryptor();
    }

    public static ExchangingEncryptor create(String encryptionAlg, KeyExchangeParameterSpec keyExchangeParamSpec) {
        return new ExchangingEncryptor(encryptionAlg, keyExchangeParamSpec);
    }

    private static ExchangingEncryptor createFromEnvironment() {
        KeyExchangeParameterSpec keyExchangeParameterSpec = null;
        int bitLen = SecurityProperties.getKeyExchangeBitLen();
        if (bitLen >= 0) {
            keyExchangeParameterSpec = ExchangingEncryptor.createKeyExchangeParameterSpec(bitLen);
        }
        return new ExchangingEncryptor(SecurityProperties.getEncryptionAlgorithm(), keyExchangeParameterSpec);
    }

    private static KeyExchangeParameterSpec createKeyExchangeParameterSpec(int bitLen) {
        switch (bitLen) {
            case 511: 
            case 512: {
                return KeyExchangeParameterSpec.DH512.getInstance();
            }
            case 1023: 
            case 1024: {
                return KeyExchangeParameterSpec.DH1024.getInstance();
            }
        }
        KeyExchangeMessages.bitLengthUsage(bitLen);
        return null;
    }

    private static boolean isEncryptorOverriddenInEnvironment() {
        return SecurityProperties.getKeyExchangeBitLen() > 0 || null != SecurityProperties.getEncryptionAlgorithm();
    }

    protected void init() {
        try {
            this.getLocalPublicKey();
        }
        catch (Exception e) {
            s_logger.throwing(this.getClass().getName(), "init()", e);
        }
    }

    public String getEncryptionAlgorithm() {
        return this.m_encryptionAlg;
    }

    public KeyExchange getKeyExchange() throws CryptoException {
        if (null == this.m_keyExchange) {
            this.m_keyExchange = KeyExchange.create(this.getEncryptionAlgorithm(), this.getKeyExchangeParameterSpec());
        }
        return this.m_keyExchange;
    }

    public KeyExchangeParameterSpec getKeyExchangeParameterSpec() {
        return this.m_parameterSpec;
    }

    public void setRemotePublicKey(byte[] bytes) throws CryptoException {
        this.getKeyExchange().setRemotePublicKey(bytes);
    }

    byte[] getRemotePublicKey() throws CryptoException {
        PublicKey pubKey = this.getKeyExchange().getRemotePublicKey();
        if (null == pubKey) {
            return null;
        }
        return pubKey.getEncoded();
    }

    public byte[] getLocalPublicKey() throws CryptoException {
        return this.getKeyExchange().getLocalPublicKey().getEncoded();
    }

    byte[] getLocalPrivateKey() throws CryptoException {
        return this.getKeyExchange().getLocalPrivateKey().getEncoded();
    }

    public byte[] getEncryptedValue(String in) throws CryptoException {
        try {
            if (null == in) {
                in = "";
            }
            Cipher ecipher = Cipher.getInstance(this.getKeyExchange().getEncryptionAlgorithm());
            ecipher.init(1, this.getKeyExchange().getSecretKey());
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.log(Level.FINEST, "enccryption cipher used: {0}/{1}", new String[]{ecipher.getAlgorithm(), String.valueOf(ecipher.getBlockSize())});
            }
            return ecipher.doFinal(in.getBytes(CHARSET_NAME));
        }
        catch (Exception e) {
            s_logger.throwing(this.getClass().getName(), "getEncryptedValue()", e);
            throw new EncryptionException(e);
        }
    }

    public String getDecryptedValue(byte[] encryptedValue) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(this.getKeyExchange().getEncryptionAlgorithm());
            cipher.init(2, this.getKeyExchange().getSecretKey());
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.log(Level.FINEST, "decryption cipher used: {0}/{1}", new String[]{cipher.getAlgorithm(), String.valueOf(cipher.getBlockSize())});
            }
            return new String(cipher.doFinal(encryptedValue), CHARSET_NAME);
        }
        catch (Exception e) {
            s_logger.throwing(this.getClass().getName(), "getDecryptedValue()", e);
            throw new EncryptionException(e);
        }
    }

    public static class EncryptionException
    extends CryptoException {
        public EncryptionException(Throwable throwable) {
            super(throwable);
        }
    }
}

