/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import oracle.oc4j.rmi.MethodSpecification;

public class ServerRmiMethodCache {
    private int m_receivedMethodsLength = 0;
    private Method[] m_receivedMethods = new Method[10];
    private Map m_badMethods;
    private Map m_methodSpecs = new HashMap();
    private WeakReference m_currentLoader;

    public void reset() {
        this.m_receivedMethodsLength = 0;
        this.m_receivedMethods = new Method[10];
        this.m_badMethods = null;
        this.m_methodSpecs.clear();
        if (this.m_currentLoader != null) {
            this.m_currentLoader.clear();
        }
    }

    public Method readMethod(ObjectInputStream in, ClassLoader domainClassLoader) throws Throwable {
        int methodKey = IOUtils.readCompressedInt(in);
        this.checkClassLoader(domainClassLoader);
        if (methodKey > 0) {
            return this.getCachedMethod(methodKey, domainClassLoader);
        }
        return this.getNewMethodSpec(in, domainClassLoader, methodKey);
    }

    private Method getCachedMethod(int methodKey, ClassLoader domainClassLoader) throws Throwable {
        int methodID = methodKey - 1;
        if (methodID >= this.m_receivedMethodsLength) {
            throw new IOException("Invalid method id");
        }
        Method method = this.m_receivedMethods[methodID];
        if (method != null) {
            return method;
        }
        MethodSpecification methodSpec = (MethodSpecification)this.m_methodSpecs.get(new Integer(methodID));
        if (methodSpec != null) {
            this.m_receivedMethods[methodID] = methodSpec.getMethod(domainClassLoader);
            return this.m_receivedMethods[methodID];
        }
        throw this.getExceptionForBadMethod(methodID);
    }

    private Method getNewMethodSpec(ObjectInputStream in, ClassLoader domainClassLoader, int methodKey) throws Throwable {
        try {
            Method method = this.readMethodSpecification(in, domainClassLoader);
            this.cacheNewMethod(methodKey, method);
            return method;
        }
        catch (Throwable t) {
            if (this.m_badMethods == null) {
                this.m_badMethods = new HashMap();
            }
            this.m_badMethods.put(new Integer(this.m_receivedMethodsLength++), t);
            throw t;
        }
    }

    private synchronized void cacheNewMethod(int methodKey, Method method) {
        if (methodKey == 0) {
            this.addReceivedMethod(method);
        }
    }

    private Method readMethodSpecification(ObjectInputStream in, ClassLoader domainClassLoader) throws IOException, ClassNotFoundException, NoSuchMethodException {
        String methodClassName = in.readUTF();
        String methodName = in.readUTF();
        int argLength = IOUtils.readCompressedInt(in);
        String[] argClassNames = new String[argLength];
        for (int i = 0; i < argLength; ++i) {
            argClassNames[i] = in.readUTF();
        }
        MethodSpecification methodSpec = new MethodSpecification(methodClassName, methodName, argClassNames);
        this.m_methodSpecs.put(new Integer(this.m_receivedMethodsLength), methodSpec);
        return methodSpec.getMethod(domainClassLoader);
    }

    private void addReceivedMethod(Method method) {
        if (this.m_receivedMethodsLength >= this.m_receivedMethods.length) {
            Method[] oldTypes = this.m_receivedMethods;
            this.m_receivedMethods = new Method[oldTypes.length * 2];
            System.arraycopy(oldTypes, 0, this.m_receivedMethods, 0, oldTypes.length);
        }
        this.m_receivedMethods[this.m_receivedMethodsLength++] = method;
    }

    private Throwable getExceptionForBadMethod(int methodID) {
        if (this.m_badMethods == null) {
            return new NoSuchMethodError();
        }
        Throwable t = (Throwable)this.m_badMethods.get(new Integer(methodID));
        if (t != null) {
            return t;
        }
        return new NoSuchMethodError();
    }

    private void checkClassLoader(ClassLoader domainClassLoader) {
        if (this.m_currentLoader == null) {
            this.m_currentLoader = new WeakReference<ClassLoader>(domainClassLoader);
        } else {
            ClassLoader loader = (ClassLoader)this.m_currentLoader.get();
            if (loader == null || loader != domainClassLoader) {
                for (int i = 0; i < this.m_receivedMethodsLength; ++i) {
                    this.m_receivedMethods[i] = null;
                }
            }
        }
    }
}

