/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.reflect.InvocationHandler;
import com.evermind.reflect.Proxy;
import com.evermind.server.rmi.RMIInterfaceType;
import com.evermind.server.rmi.RemoteInvocationHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.WeakHashMap;
import oracle.oc4j.rmi.OracleRemoteException;

public class ClientRmiTypeCache {
    private int receivedTypesLength = 0;
    private InterfaceTypeCache[] receivedTypes = new InterfaceTypeCache[10];
    private static final Class[] INVOCATIONHANDLER_ARG = new Class[]{InvocationHandler.class};

    public void clear() {
        this.receivedTypesLength = 0;
        this.receivedTypes = new InterfaceTypeCache[10];
    }

    public synchronized RMIInterfaceType getCachedType(int typeIndex, ClassLoader classLoader) throws OracleRemoteException {
        if (typeIndex >= this.receivedTypesLength) {
            throw new OracleRemoteException("Unknown type id");
        }
        try {
            return this.receivedTypes[typeIndex].getInterfaceType(classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new OracleRemoteException("Unable to create InterfaceType: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new OracleRemoteException("Unable to create InterfaceType: " + e.getMessage());
        }
    }

    public synchronized int addReceivedType(String[] interfaceNames) throws OracleRemoteException {
        for (int i = 0; i < this.receivedTypesLength; ++i) {
            if (!this.receivedTypes[i].matchesInterfaces(interfaceNames)) continue;
            return this.addNewReceivedType(this.receivedTypes[i]);
        }
        return this.addNewReceivedType(new InterfaceTypeCache(interfaceNames));
    }

    private int addNewReceivedType(InterfaceTypeCache newType) {
        if (this.receivedTypesLength >= this.receivedTypes.length) {
            InterfaceTypeCache[] oldTypes = this.receivedTypes;
            this.receivedTypes = new InterfaceTypeCache[oldTypes.length * 2];
            System.arraycopy(oldTypes, 0, this.receivedTypes, 0, oldTypes.length);
        }
        this.receivedTypes[this.receivedTypesLength] = newType;
        return this.receivedTypesLength++;
    }

    private static class InterfaceTypeCache {
        private String[] m_interfaceNames;
        private WeakHashMap m_rmiInterfaces = new WeakHashMap();

        public InterfaceTypeCache(String[] interfaceNames) {
            this.m_interfaceNames = interfaceNames;
        }

        boolean matchesInterfaces(String[] interfaceNames) {
            ArrayList<String> unmatched = new ArrayList<String>(Arrays.asList(interfaceNames));
            for (int i = 0; i < this.m_interfaceNames.length; ++i) {
                if (unmatched.remove(this.m_interfaceNames[i])) continue;
                return false;
            }
            return unmatched.isEmpty();
        }

        RMIInterfaceType getInterfaceType(ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
            WeakReference reference = (WeakReference)this.m_rmiInterfaces.get(classLoader);
            if (reference == null || reference.get() == null) {
                Class[] interfaces = this.getNamedInterfaces(this.m_interfaceNames, classLoader);
                RMIInterfaceType result = new RMIInterfaceType(interfaces, Proxy.getProxyClass(classLoader, interfaces).getConstructor(INVOCATIONHANDLER_ARG));
                this.m_rmiInterfaces.put(classLoader, new WeakReference<RMIInterfaceType>(result));
                return result;
            }
            return (RMIInterfaceType)reference.get();
        }

        private Class[] getNamedInterfaces(String[] interfaceNames, ClassLoader loaderInUse) throws ClassNotFoundException {
            Class[] interfaces = new Class[interfaceNames.length + 1];
            for (int i = 0; i < interfaceNames.length; ++i) {
                interfaces[i] = Class.forName(interfaceNames[i], true, loaderInUse);
            }
            interfaces[interfaceNames.length] = RemoteInvocationHandler.COM_EVERMIND_SERVER_RMI_EVERMINDREMOTE;
            return interfaces;
        }
    }
}

