/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.rmi;

import com.evermind.io.IOUtils;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ClientRmiMethodCache {
    private Map m_sentMethods = new HashMap();
    private int m_sentMethodsLength = 0;

    public void reset() {
        this.m_sentMethods = new HashMap();
        this.m_sentMethodsLength = 0;
    }

    public void writeMethod(Method method, ObjectOutputStream out) throws IOException {
        Integer methodID = (Integer)this.m_sentMethods.get(method);
        if (methodID != null) {
            IOUtils.writeCompressedInt(out, methodID + 1);
        } else {
            IOUtils.writeCompressedInt(out, 0);
            methodID = new Integer(this.m_sentMethodsLength++);
            this.m_sentMethods.put(method, methodID);
            this.writeMethodSelector(out, method);
        }
    }

    protected void writeMethodSelector(ObjectOutputStream out, Method method) throws IOException {
        out.writeUTF(method.getDeclaringClass().getName());
        out.writeUTF(method.getName());
        Class<?>[] methodArgs = method.getParameterTypes();
        IOUtils.writeCompressedInt(out, methodArgs.length);
        for (int i = 0; i < methodArgs.length; ++i) {
            out.writeUTF(methodArgs[i].getName());
        }
    }
}

