/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.oc4j.query.ExternalProcessLauncher;
import oracle.oc4j.query.QueryUtils;
import oracle.oc4j.query.ThreadPoolQuery;
import oracle.oc4j.query.VMProcess;
import sun.misc.Perf;

public class VMStat
extends ThreadPoolQuery {
    private static String username = System.getProperty("user.name");
    public static int mypid = 0;
    private static final Perf perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
    static String tmpDirName = null;
    static String tmpUserDirName = null;
    public static final String dirNamePrefix = "hsperfdata_";

    public String getDescription() {
        return "List statistic info for the current VM." + EOL + EOL + "Args: [jps|pid|mem] <args>" + EOL + EOL + "jps: return the list of running java processes" + EOL + "pid: return current vm pid (guess)" + EOL + "mem: return current vm memory info" + EOL;
    }

    public void createQueryReport(String[] args) throws Exception {
        if (args.length == 0) {
            this.appendln(this.getDescription());
        } else {
            try {
                String cmd = args[0];
                switch (cmd.charAt(0)) {
                    case 'j': {
                        this.pids();
                        break;
                    }
                    case 'p': {
                        this.monpid();
                        break;
                    }
                    case 'm': {
                        this.mem();
                        break;
                    }
                    case 's': {
                        VMStat.runsh(args[1]);
                        break;
                    }
                    default: {
                        this.appendln(this.getDescription());
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.appendln(QueryUtils.getStackTrace(e));
            }
        }
    }

    private void mem() {
        long ttl = Runtime.getRuntime().totalMemory() / 1024L;
        long max = Runtime.getRuntime().maxMemory() / 1024L;
        long free = Runtime.getRuntime().freeMemory() / 1024L;
        VMProcess myp = this.getVMProcess(mypid);
        if (myp != null) {
            this.appendln("pid " + myp.pid + " ttl " + ttl + "K   free " + free + "K   max " + max + "K   vmem " + myp.mem + " cpu " + myp.cpu);
        } else {
            this.appendln("ttl " + ttl + "K   free " + free + "K   max " + max + "K");
        }
    }

    private VMProcess[] psUnix(String exeNameFilter) {
        ArrayList<VMProcess> processes = new ArrayList<VMProcess>(5);
        try {
            Properties props = QueryUtils.getEnvProperties();
            ExternalProcessLauncher l = new ExternalProcessLauncher();
            l.setCmd("/bin", "ps", "-o pid,user,vsize,time,cmd --no-headers -u " + username);
            boolean success = l.run();
            StringTokenizer tk = new StringTokenizer(l.getOutBuffer(), EOL);
            while (tk.hasMoreElements()) {
                String line = (String)tk.nextElement();
                String[] answer = line.trim().split("\\s+");
                if (answer.length <= 0) continue;
                VMProcess process = new VMProcess();
                process.cmd = answer[4].trim().toLowerCase();
                if (exeNameFilter == null || process.cmd.indexOf(exeNameFilter) < 0) continue;
                process.pid = Integer.parseInt(answer[0]);
                String user = answer[1].trim();
                process.mem = answer[2].trim();
                process.cpu = answer[3].trim();
                processes.add(process);
            }
        }
        catch (RuntimeException e) {
            this.appendln("Unix ps command is required  for this feature...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (Exception e) {
            this.appendln("Unix ps command is required for this feature...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        return processes.toArray(new VMProcess[0]);
    }

    private VMProcess[] psXP(String exeNameFilter) {
        ArrayList<VMProcess> processes = new ArrayList<VMProcess>(5);
        try {
            Properties props = QueryUtils.getEnvProperties();
            String WindowsRoot = props.getProperty("SystemRoot");
            ExternalProcessLauncher l = new ExternalProcessLauncher();
            if (exeNameFilter != null) {
                l.setCmd(WindowsRoot + File.separator + "system32", "cmd", "/c tasklist.exe /NH /V /FI \"USERNAME eq " + username + "\" /FI \"IMAGENAME eq " + ExternalProcessLauncher.addExtension(exeNameFilter) + "\" /FO CSV\"");
            } else {
                l.setCmd(WindowsRoot + File.separator + "system32", "cmd", "/c tasklist.exe /NH /V /FI \"USERNAME eq " + username + "\"/FI /FO CSV\"");
            }
            boolean success = l.run();
            StringTokenizer tk = new StringTokenizer(l.getOutBuffer(), EOL);
            while (tk.hasMoreElements()) {
                String line = (String)tk.nextElement();
                String[] answer = line.split("\",\"");
                if (answer.length <= 0) continue;
                VMProcess process = new VMProcess();
                process.cmd = answer[0].replace('\"', ' ').trim();
                process.pid = Integer.parseInt(answer[1].replace('\"', ' ').trim());
                process.mem = answer[4].replace('\"', ' ').trim();
                process.cpu = answer[7].replace('\"', ' ').trim();
                processes.add(process);
            }
        }
        catch (RuntimeException e) {
            this.appendln("Windows XP or greater is required for this feature...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (Exception e) {
            this.appendln("Windows XP or greater is required for this feature...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        return processes.toArray(new VMProcess[0]);
    }

    private VMProcess[] jps() {
        if (QueryUtils.isDos) {
            return this.psXP("java");
        }
        return this.psUnix("java");
    }

    private void pids() {
        VMStat v = new VMStat();
        VMProcess[] vps = v.jps();
        for (int i = 0; i < vps.length; ++i) {
            VMProcess vp = vps[i];
            this.appendln(vp.toString());
        }
    }

    private void monpid() {
        this.appendln(VMStat.myJavaPid());
    }

    private void _pids() {
        try {
            ExternalProcessLauncher l = new ExternalProcessLauncher();
            l.setAltJdkPath("C:\\jdk1.5.0_04");
            l.setJdkCmd("jps", "-lv");
            boolean success = l.run();
            BufferedReader reader = new BufferedReader(new StringReader(l.getOutBuffer()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                StringTokenizer tk = new StringTokenizer(line, " ");
                this.appendln(">> Pid:" + tk.nextToken() + " Class:" + tk.nextToken() + " Props" + tk.nextElement());
            }
            Set vmids = this.getUserVMIds();
            this.appendln("getUserVMIds:" + vmids.size());
            Iterator iterator = vmids.iterator();
            while (iterator.hasNext()) {
                Integer id = (Integer)iterator.next();
                this.appendln("VMId=" + id);
                byte[] ba = this.getUserVMData(id);
            }
        }
        catch (UnsupportedClassVersionError e) {
            this.appendln("Require JDK 1.5...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (RuntimeException e) {
            this.appendln("Jdk 1.5 not found please set -Doracle.oc4j.query.jdk15.path=<path to your jdk 1.5");
            this.appendln(QueryUtils.getStackTrace(e));
        }
        catch (Exception e) {
            this.appendln("Unexpected exception while trying to get pid...");
            this.appendln(QueryUtils.getStackTrace(e));
        }
    }

    private void parseJps(StringBuffer ret) {
    }

    public String getVMId_15() {
        try {
            Object threadMxBean = this.callStaticMethodOnClass("java.lang.management.ManagementFactory", "getRuntimeMXBean");
            Object name = this.callMethodOnObject(threadMxBean, "java.lang.management.RuntimeMXBean", "getName");
            String vmName = (String)name;
            String id = vmName.substring(0, vmName.indexOf("@"));
            System.out.println("PID=" + id);
            return id;
        }
        catch (ClassNotFoundException e) {
            this.appendln("Require JDK 1.5...");
            this.appendln(QueryUtils.getStackTrace(e));
            return null;
        }
    }

    public VMProcess getVMProcess(int pid) {
        VMProcess[] ps = this.jps();
        VMProcess it = null;
        for (int i = 0; i < ps.length; ++i) {
            it = ps[i];
            if (it.pid != pid) continue;
            return it;
        }
        return it;
    }

    public static int myJavaPid() {
        int mypid = 0;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.5")) {
            mypid = Integer.parseInt(new VMStat().getVMId_15());
        } else if (QueryUtils.isDos) {
            VMProcess[] ps = new VMStat().jps();
            VMProcess min = null;
            Date d = new Date();
            for (int i = 0; i < ps.length; ++i) {
                VMProcess p = ps[i];
                if (min == null) {
                    min = p;
                }
                if (min.cpu() <= p.cpu()) continue;
                min = p;
            }
            mypid = min.pid;
        } else {
            mypid = VMStat.getUnixShPPid();
        }
        return mypid;
    }

    private static int getUnixShPPid() {
        String ppidf = tmpDirName + File.separator + "ppid.sh";
        int pid = 0;
        try {
            ExternalProcessLauncher l = new ExternalProcessLauncher();
            File f = new File(ppidf);
            f.deleteOnExit();
            StringBuffer script = new StringBuffer();
            script.append("#!/bin/sh" + EOL);
            script.append("echo $PPID" + EOL);
            script.append(" " + EOL);
            FileOutputStream scriptFile = new FileOutputStream(f);
            scriptFile.write(script.toString().getBytes());
            scriptFile.flush();
            scriptFile.close();
            boolean success = l.run("chmod +x " + ppidf);
            success = l.run(ppidf);
            pid = Integer.parseInt(l.getOutBuffer().trim());
        }
        catch (FileNotFoundException e) {
            System.err.println("could not create file: " + ppidf);
        }
        catch (IOException e) {
            System.err.println("Unix /bin/sh command is required  for this feature...");
        }
        return pid;
    }

    public static void runsh(String cmd) {
        try {
            ExternalProcessLauncher l = new ExternalProcessLauncher();
            boolean success = l.run(cmd);
            System.out.println("[" + l.getOutBuffer() + "]" + success);
            System.out.println("[" + l.getErrorBuffer() + "]");
        }
        catch (Exception e) {
            System.err.println("Unix ps command is required  for this feature...");
        }
    }

    public static void main(String[] args) {
        VMStat v = new VMStat();
        mypid = VMStat.myJavaPid();
        System.out.println("My pid is... " + mypid);
        v.mem();
        VMProcess[] vps = v.jps();
        for (int i = 0; i < vps.length; ++i) {
            VMProcess vp = vps[i];
            System.out.println(vp.toString());
        }
    }

    public byte[] getUserVMData(int lvmid) {
        byte[] data = null;
        try {
            ByteBuffer bb = perf.attach(lvmid, "r");
            data = new byte[bb.limit()];
            bb.get(data);
        }
        catch (FileNotFoundException e2) {
            throw new RuntimeException(lvmid + " not found", e2);
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not map vm file for " + lvmid, e2);
        }
        return data;
    }

    public Set getUserVMIds() {
        File tmpdir = new File(tmpUserDirName);
        if (!tmpdir.exists() || !tmpdir.isDirectory()) {
            return null;
        }
        File[] files = tmpdir.listFiles();
        HashSet<Integer> jvmSet = new HashSet<Integer>();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].isFile() || !files[j].canRead()) continue;
                jvmSet.add(new Integer(files[j].getName()));
            }
        }
        return jvmSet;
    }

    static {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir.compareTo("/var/tmp/") == 0) {
            tmpdir = "/tmp/";
        }
        if (tmpdir.lastIndexOf(File.separator) != tmpdir.length() - 1) {
            tmpdir = tmpdir + File.separator;
        }
        tmpDirName = tmpdir;
        String username = System.getProperty("user.name");
        tmpUserDirName = tmpdir + File.separator + dirNamePrefix + username;
    }
}

