/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import com.evermind.server.ApplicationServerThread;
import com.evermind.util.ThreadPool;
import oracle.oc4j.query.QueryUtils;
import oracle.oc4j.query.ThreadPoolQuery;

public class ThreadPools
extends ThreadPoolQuery {
    public String getDescription() {
        return "List application server related thread for the current VM." + EOL + EOL + "Args: (list|pool|state) [arguments...]" + EOL + EOL + " list: list all threads on all pools" + EOL + " list <sys|req|cx>: list all thread in a specifc pool." + EOL + " pool: list all pools." + EOL + " pool <sys|req|cx>: list pool specific details." + EOL + " state <sys|req|cx> <id>: dump thread state for a specific thread id." + EOL;
    }

    public void createQueryReport(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                this.appendln(this.getDescription());
            } else {
                String cmd = args[0];
                switch (cmd.charAt(0)) {
                    case 'l': {
                        if (args.length > 1) {
                            this.list(args[1]);
                            break;
                        }
                        this.list();
                        break;
                    }
                    case 'p': {
                        if (args.length > 1) {
                            this.pools(args[1]);
                            break;
                        }
                        this.pools();
                        break;
                    }
                    case 's': {
                        if (args.length != 3) {
                            this.appendln("invalid number of arguments");
                            break;
                        }
                        this.state(args[1], args[2]);
                        break;
                    }
                    default: {
                        this.appendln(this.getDescription());
                    }
                }
            }
        }
        catch (Exception e) {
            this.appendln(QueryUtils.getStackTrace(e));
        }
    }

    public void pools() {
        this.appendln(this.groupInfoHeader());
        this.appendln(this.poolInfo("System", this.sys(), false));
        this.appendln(this.poolInfo("Request", this.req(), false));
        if (this.cx() != this.sys()) {
            this.appendln(this.poolInfo("Connection", this.cx(), false));
        } else {
            this.appendln(QueryUtils.pad("Connection", 41) + "Not configured - using System pool");
        }
    }

    public void pools(String poolName) {
        ThreadPool pool = this.getPoolFromName(poolName);
        this.appendln(this.groupInfoHeader());
        this.appendln(this.poolInfo(poolName, pool, true));
    }

    public String groupInfoHeader() {
        return QueryUtils.underline(QueryUtils.pad("Pool Name", 41) + QueryUtils.pad("min", 7) + QueryUtils.pad("max", 7) + QueryUtils.pad("queue", 7) + QueryUtils.pad("in queue", 7) + QueryUtils.pad("keepalive", 10), '=');
    }

    public String poolInfo(String name, ThreadPool p, boolean dumpIt) {
        int min = p.getMinPoolSize();
        int max = p.getMaxPoolSize();
        long maxqueue = p.getQueueCapacity();
        long queue = p.getQueueSize();
        long keepalive = p.getKeepAliveTime();
        String ret = QueryUtils.pad(name, 41) + QueryUtils.pad(min, 7) + QueryUtils.pad(max, 7) + QueryUtils.pad(maxqueue, 7) + QueryUtils.pad(queue, 7) + QueryUtils.pad(keepalive, 10);
        if (dumpIt) {
            ret = ret + EOL + QueryUtils.dump(p);
        }
        return ret;
    }

    public void list() {
        this.list("System");
        this.list("Request");
        if (this.sys() != this.cx()) {
            this.list("Connection");
        }
    }

    public void list(String poolName) {
        ThreadPool pool = this.getPoolFromName(poolName);
        if (pool == null) {
            this.appendln("invalid pool name." + poolName);
            return;
        }
        ThreadGroup rootGroup = pool.getThreadGroup();
        StringBuffer buffer = new StringBuffer(4096);
        buffer.append(poolName + "Pool - Total Threads: " + rootGroup.activeCount() + EOL);
        Thread[] threads = new Thread[rootGroup.activeCount()];
        rootGroup.enumerate(threads);
        buffer.append(this.threadInfoHeader() + EOL);
        for (int i = 0; i < threads.length; ++i) {
            buffer.append(this.threadInfo(threads[i], false) + EOL);
        }
        this.appendln(buffer.toString());
    }

    public void state(String poolName, String id) {
        ThreadPool pool = this.getPoolFromName(poolName);
        if (pool == null) {
            this.appendln("invalid pool name." + poolName);
            return;
        }
        long lid = 0L;
        try {
            lid = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            this.appendln("Invalid number format " + id);
            return;
        }
        ThreadGroup rootGroup = pool.getThreadGroup();
        Thread[] threads = new Thread[rootGroup.activeCount()];
        rootGroup.enumerate(threads);
        this.appendln(this.threadInfoHeader());
        for (int i = 0; i < threads.length; ++i) {
            ApplicationServerThread at = (ApplicationServerThread)threads[i];
            if (at.getInternalId() != lid) continue;
            this.appendln(this.threadInfo(threads[i], true) + EOL);
        }
        this.appendln();
    }

    private ThreadPool getPoolFromName(String pname) {
        String name = pname.toLowerCase();
        ThreadPool pool = name.charAt(0) == 's' ? this.sys() : (name.charAt(0) == 'r' ? this.req() : (name.charAt(0) == 'c' ? this.cx() : null));
        return pool;
    }

    public String threadInfoHeader() {
        return QueryUtils.underline(QueryUtils.pad("ID", 5) + QueryUtils.pad("Name", 50) + QueryUtils.pad("TState", 13) + QueryUtils.pad("Daemon", 7) + QueryUtils.pad("Alive", 5), '=');
    }

    public String threadInfo(Thread t, boolean dump) {
        ApplicationServerThread at = (ApplicationServerThread)t;
        long id = at.getInternalId();
        String name = at.getName();
        String state = at.state.toString();
        boolean d = t.isDaemon();
        boolean a = t.isAlive();
        String ret = QueryUtils.pad(id, 5) + QueryUtils.pad(name, 50) + QueryUtils.pad(state, 13) + QueryUtils.pad(d, 7) + QueryUtils.pad(a, 5);
        if (dump) {
            ret = ret + EOL + QueryUtils.dump(at) + EOL;
            ret = ret + EOL + QueryUtils.dump(at.state) + EOL;
        }
        return ret;
    }
}

