/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.oc4j.query.QueryUtils;

public final class ExternalProcessLauncher {
    static final int OUTPUT_BUFFER_SIZE = 16384;
    static final int BUFFER_SIZE = 8192;
    private String _altJdkPath;
    private String _cmdPath;
    private String _cmdArgs;
    private final boolean DEBUG = false;
    protected OutputStream outputStream = System.out;
    protected String errBuff;
    protected String outBuff;

    public ExternalProcessLauncher() {
        this._altJdkPath = System.getProperty("oracle.oc4j.query.jdk15.path", null);
    }

    public void setAltJdkPath(String path) {
        this._altJdkPath = new String(path);
    }

    public void setJdkCmd(String cmd, String args) throws InstantiationException {
        this._cmdPath = this.getJdkExecutable(cmd);
        this._cmdArgs = args;
    }

    public void setCmd(String path, String cmd, String args) throws InstantiationException {
        this._cmdPath = this.findCmdInPath(path, cmd);
        this._cmdArgs = args;
    }

    protected void dump() {
        System.out.println("javaHome          " + QueryUtils.javaHome);
        System.out.println("osName            " + QueryUtils.osName);
        System.out.println("pathSep           " + QueryUtils.pathSep);
        System.out.println("altJdkPath        " + this._altJdkPath);
        System.out.println("cmdPath           " + this._cmdPath);
        System.out.println("cmdArgs           " + this._cmdArgs);
    }

    protected static String addExtension(String command) {
        if (QueryUtils.isDos) {
            if (command.endsWith(".exe")) {
                return command;
            }
            return command + ".exe";
        }
        return command;
    }

    private static File findInDir(String dirName, String commandName) {
        File dir;
        File executable = null;
        if (dirName != null && commandName != null && (dir = QueryUtils.normalize(dirName)).isDirectory() && !(executable = new File(dir, ExternalProcessLauncher.addExtension(commandName))).exists()) {
            executable = null;
        }
        return executable;
    }

    public String getJdkExecutable(String command) throws InstantiationException {
        if (QueryUtils.osName.indexOf("netware") > -1) {
            return command;
        }
        String jdkHome = null;
        jdkHome = this._altJdkPath != null ? this.stripPath(this._altJdkPath) : this.stripPath(QueryUtils.javaHome);
        if (jdkHome.endsWith("jre")) {
            jdkHome = jdkHome.substring(0, jdkHome.length() - 3);
        }
        jdkHome = this.stripPath(jdkHome);
        return this.findCmdInPath(jdkHome, command);
    }

    private String findCmdInPath(String path, String command) throws InstantiationException {
        File jExecutable = null;
        if (QueryUtils.osName.equals("aix")) {
            jExecutable = ExternalProcessLauncher.findInDir(path + File.separator + "sh", command);
        }
        if (jExecutable == null) {
            jExecutable = ExternalProcessLauncher.findInDir(path + File.separator + "bin", command);
        }
        if (jExecutable == null) {
            jExecutable = ExternalProcessLauncher.findInDir(path, command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        throw new InstantiationException(ExternalProcessLauncher.addExtension(command) + " not found under " + path);
    }

    private String stripPath(String path) {
        if (path == null) {
            return path;
        }
        String retPath = null;
        char lastchar = path.charAt(path.length() - 1);
        retPath = (lastchar == '\\' || lastchar == '/') && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        return retPath;
    }

    protected String getOtherCmd(String home, String command) throws InstantiationException {
        File jExecutable = null;
        jExecutable = ExternalProcessLauncher.findInDir(home, ExternalProcessLauncher.addExtension(command));
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        throw new InstantiationException(ExternalProcessLauncher.addExtension(command) + " not found under " + home + ", specify the correct location of " + ExternalProcessLauncher.addExtension(command));
    }

    private int parseCmdOptions(ArrayList newOptions) {
        int numberOfOptions = 0;
        StringTokenizer st = new StringTokenizer(this._cmdArgs);
        while (st.hasMoreTokens()) {
            String option = st.nextToken();
            ++numberOfOptions;
            newOptions.add(option);
        }
        return numberOfOptions;
    }

    private String[] parseCmdOptions() {
        StringBuffer current = new StringBuffer();
        char[] cline = this._cmdArgs.trim().toCharArray();
        int cur = 0;
        int prev = 0;
        int delimiter = 64;
        boolean inQuote = false;
        for (int pos = 0; pos < cline.length; ++pos) {
            cur = cline[pos];
            if (!(cur != 32 && cur != 9 || inQuote)) {
                cur = delimiter;
            }
            if ((cur == 39 || cur == 34) && prev != 92) {
                inQuote = !inQuote;
            }
            prev = cur;
            cline[pos] = cur;
        }
        String newline = new String(cline, 0, cline.length);
        StringTokenizer st = new StringTokenizer(newline, "@");
        String[] args = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String option;
            args[i] = option = st.nextToken();
            ++i;
        }
        return args;
    }

    public boolean run() throws RuntimeException {
        int i;
        String[] options = this.parseCmdOptions();
        String[] aCmd = new String[1 + options.length];
        aCmd[0] = this._cmdPath;
        for (i = 0; i < options.length; ++i) {
            aCmd[i + 1] = options[i];
        }
        for (i = 0; i < aCmd.length; ++i) {
            if (aCmd[i] != null) continue;
            aCmd[i] = "";
        }
        return this.run(aCmd);
    }

    public boolean run(String cmdLine) throws RuntimeException {
        this._cmdArgs = cmdLine;
        String[] options = this.parseCmdOptions();
        return this.run(options);
    }

    public boolean run(String[] aCmd) throws RuntimeException {
        boolean isOkay;
        int exitValue = -1;
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(16384);
        ByteArrayOutputStream tmpOut = new ByteArrayOutputStream(16384);
        try {
            for (int i = 0; i < aCmd.length; ++i) {
                String s = aCmd[i];
            }
            Process process = Runtime.getRuntime().exec(aCmd);
            BufferedInputStream compilerErr = new BufferedInputStream(process.getErrorStream());
            BufferedInputStream compilerOut = new BufferedInputStream(process.getInputStream());
            StreamPumper errPumper = new StreamPumper(compilerErr, tmpErr);
            StreamPumper outPumper = new StreamPumper(compilerOut, tmpOut);
            errPumper.start();
            outPumper.start();
            process.waitFor();
            exitValue = process.exitValue();
            errPumper.join();
            compilerErr.close();
            outPumper.join();
            compilerOut.close();
            process.destroy();
            tmpErr.close();
            this.errBuff = tmpErr.toString();
            tmpOut.close();
            this.outBuff = tmpOut.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        catch (InterruptedException ie) {
            return false;
        }
        boolean bl = isOkay = exitValue == 0;
        if (tmpErr.size() > 0) {
            isOkay = false;
        }
        return isOkay;
    }

    public String getOutBuffer() {
        return this.outBuff;
    }

    public String getErrorBuffer() {
        return this.errBuff;
    }

    static class StreamPumper
    extends Thread {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 100;
        private OutputStream out;

        public StreamPumper(BufferedInputStream is, OutputStream out) {
            this.stream = is;
            this.out = out;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[8192];
            if (!this.endOfStream) {
                int bytesRead = this.stream.read(buf, 0, 8192);
                if (bytesRead > 0) {
                    this.out.write(buf, 0, bytesRead);
                } else if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    StreamPumper.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException ie) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

