/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.RecoverableByteBuffer;
import oracle.classloader.SharedCodeSource;
import oracle.classloader.query.ReportQuery;
import oracle.classloader.util.AnnotatedThrowable;
import oracle.classloader.util.ArrayUtils;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.MissingClass;
import oracle.classloader.util.ThrowableAnnotation;
import oracle.oc4j.query.Callers;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;

public class AuditLoader
extends ClassLoaderQuery {
    private static final String DEFAULT_APP_ROOT = "default.root";
    private static final int HEADING_MARGIN = 15;
    private boolean verbose;
    private boolean includeJREClasses;
    static /* synthetic */ Class class$java$lang$Class;

    public String getDescription() {
        return "Performs diagnostics on the contents of the specified loader(s).\n\nArgs: loaderName [loaderName] [-verbose] [-includeJREClasses]\n\nMay specify '*' to audit all shared loaders (try -XX:MaxPermSize=512m).";
    }

    public void createQueryReport(String[] args) throws Exception {
        boolean multiple;
        Audit audit;
        List loaders = this.parseArgs(args);
        int longestLoaderName = 0;
        ArrayList<Audit> results = new ArrayList<Audit>();
        Iterator iterator = loaders.iterator();
        while (iterator.hasNext()) {
            PolicyClassLoader loader = (PolicyClassLoader)iterator.next();
            String name = loader.getDisplayName();
            int length = name.length();
            if (length > longestLoaderName) {
                longestLoaderName = length;
            }
            audit = new Audit(loader, this.verbose, this.includeJREClasses);
            results.add(audit);
        }
        boolean bl = multiple = results.size() > 1;
        if (multiple) {
            int totalChecked = 0;
            int totalErrors = 0;
            Iterator iterator2 = results.iterator();
            while (iterator2.hasNext()) {
                audit = (Audit)iterator2.next();
                totalChecked += audit.getAllClasses().size();
                totalErrors += audit.getErrors().size();
            }
            this.appendln();
            this.append("Loaders checked: ");
            this.appendln(results.size());
            this.append("Classes checked: ");
            this.appendln(totalChecked);
            if (totalErrors == 0) {
                this.append("         Errors: 0");
            } else {
                this.appendln();
                int padTo = longestLoaderName + 1;
                this.appendAndPadTo("Shared-Library", padTo);
                this.appendln("Errors");
                this.appendAndPadTo("-", padTo - 1, '-');
                this.appendln(" ------");
                Iterator iterator3 = results.iterator();
                while (iterator3.hasNext()) {
                    Audit audit2 = (Audit)iterator3.next();
                    this.appendAndPadTo(audit2.getLoader().getDisplayName(), padTo);
                    this.appendAlignRight(audit2.getErrors().size(), 6);
                    this.appendln();
                }
                this.appendAndPadTo(" ", padTo);
                this.appendln("------");
                this.appendAndPadTo(" ", padTo);
                this.appendAlignRight(totalErrors, 6);
            }
            this.appendln();
        }
        Iterator iterator4 = results.iterator();
        while (iterator4.hasNext()) {
            Audit audit3 = (Audit)iterator4.next();
            this.append(audit3, multiple);
        }
    }

    private void append(Audit audit, boolean addSeparator) {
        if (addSeparator) {
            this.appendln();
            this.appendln("------------------------------------------------------------------------------");
        }
        this.appendln();
        this.append("Audit results for '");
        this.append(audit.getLoader().getDisplayName());
        this.append("' ");
        this.appendln(new Date(audit.getStartTime()));
        this.appendln();
        if (audit.getLoader().isSharedLoader()) {
            this.append("Imported by", audit.getSubscribers(), true, false);
            this.appendHeading("Default import", false);
            this.appendln(audit.isDefaultImport() ? "Yes" : "No");
        }
        this.append("Member classes", audit.getMemberClasses(), false, true);
        this.append("Member packages", audit.getMemberPackages(), false, true);
        if (this.verbose) {
            this.append("Direct external class dependencies", audit.getDirectDependentClasses(), true, true);
            this.append("Direct external package dependencies", audit.getDirectDependentPackages(), true, true);
            this.append("All external class dependencies", audit.getDependentClasses(), true, true);
            this.append("All external package dependencies", audit.getDependentPackages(), true, true);
            this.append("All external loader dependencies", audit.getDependentLoaders(), true, true);
        }
        this.append("Notes", audit.getNotes(), true, false);
        this.append("Warnings", audit.getWarnings(), true, false);
        this.append("Duplicates", audit.getDuplicates(), true, false);
        this.append("Errors", audit.getErrors(), true, false);
        Set toImport = audit.getLoadersToImport();
        if (audit.getErrors().size() > 0 && !toImport.isEmpty()) {
            int importErrorCount = audit.getImportErrorCount();
            String count = Integer.toString(importErrorCount);
            if (audit.getErrors().size() == importErrorCount) {
                count = "all";
            }
            String message = toImport.size() == 1 ? "Importing the following shared-library should correct " + count + " of the errors" : "Importing the following shared-libraries should correct " + count + " of the errors";
            this.append(message, toImport, true, false);
        }
        this.appendln();
        this.appendHeading("Execution time", false);
        int seconds = audit.getExecutionTimeSeconds();
        this.append(seconds);
        this.appendln(seconds == 1 ? " second" : " seconds");
    }

    private void appendHeading(String heading, boolean forceList) {
        this.append(heading);
        this.append(": ");
        if (!this.verbose && !forceList) {
            for (int indent = 15 - heading.length(); indent > 0; --indent) {
                this.append(' ');
            }
        }
    }

    private void append(String heading, Collection c, boolean forceList, boolean sortList) {
        boolean list;
        boolean bl = list = forceList || this.verbose;
        if (c.isEmpty()) {
            list = false;
        }
        this.appendHeading(heading, list);
        if (list) {
            this.appendln();
            this.appendln();
            this.appendNumberedList(sortList ? this.sort(c) : c);
            this.appendln();
        } else {
            this.append(c.size());
            this.appendln();
        }
    }

    private static List getLoaders(List codeSources) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator = codeSources.iterator();
        while (iterator.hasNext()) {
            SharedCodeSource source = (SharedCodeSource)iterator.next();
            Object[] subscribers = source.getSubscribers().getSubscribers();
            if (ArrayUtils.countNonNull((Object[])subscribers, (int)subscribers.length) <= 0) continue;
            for (int i = 0; i < subscribers.length; ++i) {
                Object subscriber = subscribers[i];
                if (subscriber == null) continue;
                result.add(subscriber);
            }
        }
        return result;
    }

    private List parseArgs(String[] args) {
        List<PolicyClassLoader> result = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.equals("!")) {
                result = AuditLoader.getAllLoaders();
                result.remove(AuditLoader.getRootLoader());
                result.remove(AuditLoader.findLoader((String)ClassLoadEnvironment.getExtensionLoaderName()));
                continue;
            }
            if (arg.equals("*")) {
                Iterator iterator = AuditLoader.getAllLoaders().iterator();
                while (iterator.hasNext()) {
                    PolicyClassLoader l = (PolicyClassLoader)iterator.next();
                    if (!l.isSharedLoader()) continue;
                    result.add(l);
                }
                continue;
            }
            if (arg.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-includeJREClasses")) {
                this.includeJREClasses = true;
                continue;
            }
            if (arg.indexOf(58) > 0) {
                PolicyClassLoader loader = AuditLoader.findLoader((String)arg);
                if (loader == null) {
                    throw new IllegalArgumentException("Loader \"" + arg + "\" not found.");
                }
                result.add(loader);
                continue;
            }
            PolicyClassLoader[] loaders = AuditLoader.findLoaders((String)arg);
            if (loaders == null) {
                throw new IllegalArgumentException("Loader \"" + arg + "\" not found.");
            }
            for (int j = 0; j < loaders.length; ++j) {
                PolicyClassLoader loader = loaders[j];
                result.add(loader);
            }
        }
        return result;
    }

    public static class Calls
    implements ClassVisitor,
    CodeVisitor {
        private MethodSignature[] signatures;
        private String currentClass;
        private String currentMethodName;
        private String currentMethodDesc;

        public Calls(MethodSignature[] signatures) {
            this.signatures = signatures;
        }

        public void visitClass(String className, byte[] classData, int classSize) {
            this.currentClass = className;
            ClassReader reader = new ClassReader(classData, 0, classSize);
            reader.accept((ClassVisitor)this, false);
        }

        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            this.currentMethodName = name;
            this.currentMethodDesc = desc;
            return this;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            for (int i = 0; i < this.signatures.length; ++i) {
                MethodSignature methodSignature = this.signatures[i];
                if (!methodSignature.matches(owner, name, desc)) continue;
                methodSignature.reportMatch(this.currentClass, this.currentMethodName, this.currentMethodDesc);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }
    }

    public static abstract class MethodSignature
    extends Callers.Signature {
        protected MethodSignature(String sig) {
            super(sig);
        }

        public abstract void reportMatch(String var1, String var2, String var3);
    }

    public static class Audit {
        private long startTime;
        private long endTime;
        private PolicyClassLoader loader;
        private boolean verbose;
        private boolean includeJREClasses;
        private Set checked = new HashSet();
        private List susbscribers = new ArrayList();
        private boolean defaultImport;
        private List duplicates = new ArrayList();
        private List errors = new ArrayList();
        private List warnings = new ArrayList();
        private Map memberClasses = new HashMap();
        private Set memberPackages = new HashSet();
        private Set dependentPackages = new HashSet();
        private Set dependentLoaders = new HashSet();
        private List dependentClasses = new ArrayList();
        private Set allDirectDependentClasses = new HashSet();
        private Set directDependentClasses = new HashSet();
        private Set directDependentPackages = new HashSet();
        private Class[] dependencyChain = new Class[1024];
        private List unusedImports = new ArrayList();
        private List unusedCodeSources = new ArrayList();
        private List notes = new ArrayList();
        private static RecoverableByteBuffer buffer = new RecoverableByteBuffer(32768);
        private boolean recordedLoadClass;
        private boolean recordedForName;
        private Set recordedForNameNoLoader = new HashSet();
        private int importErrorCount;
        private Set sharedLoadersToImport = new HashSet();
        private MethodSignature[] signatures = new MethodSignature[]{new LoadClass(), new ForNameNoLoader(), new ForName()};
        private Calls calls = new Calls(this.signatures);

        public Audit(PolicyClassLoader loader, boolean verbose, boolean includeJREClasses) throws IOException {
            int i;
            SharedCodeSource[] sources;
            this.loader = loader;
            this.verbose = verbose;
            this.includeJREClasses = includeJREClasses;
            this.startTime = System.currentTimeMillis();
            ClassLoadLogger.log((Level)Level.INFO, (String)("Auditing '" + loader.getDisplayName() + "' " + new Date(this.startTime)));
            PolicyClassLoader[] imports = loader.getImports();
            if (imports != null) {
                for (int i2 = 0; i2 < imports.length; ++i2) {
                    this.unusedImports.add(imports[i2]);
                }
            }
            if ((sources = loader.getCodeSources(true)) != null) {
                for (i = 0; i < sources.length; ++i) {
                    this.unusedCodeSources.add(sources[i]);
                }
            }
            for (i = 0; i < sources.length; ++i) {
                SharedCodeSource source = sources[i];
                this.collectMemberClasses(source);
            }
            Iterator<Object> iterator = this.memberClasses.keySet().iterator();
            while (iterator.hasNext()) {
                String memberClass = (String)iterator.next();
                this.loadAllDependencies(memberClass, 0);
            }
            this.checkDuplicates();
            if (loader.isSharedLoader()) {
                PolicyClassLoader[] importers = loader.getSubscribers().getSubscribers();
                for (int i3 = 0; i3 < importers.length; ++i3) {
                    if (importers[i3] == null) continue;
                    this.susbscribers.add(importers[i3]);
                    if (!importers[i3].getName().equals(AuditLoader.DEFAULT_APP_ROOT)) continue;
                    this.defaultImport = true;
                }
            }
            iterator = this.checked.iterator();
            while (iterator.hasNext()) {
                String className = (String)iterator.next();
                if (this.memberClasses.containsKey(className)) continue;
                this.dependentClasses.add(className);
            }
            iterator = this.allDirectDependentClasses.iterator();
            while (iterator.hasNext()) {
                String className = (String)iterator.next();
                if (this.memberClasses.containsKey(className)) continue;
                this.directDependentClasses.add(className);
                this.directDependentPackages.add(Audit.getPackageName(className));
            }
            iterator = this.unusedCodeSources.iterator();
            while (iterator.hasNext()) {
                SharedCodeSource cs = (SharedCodeSource)iterator.next();
                this.warnings.add(0, new UnusedCodeSource(cs));
            }
            iterator = this.unusedImports.iterator();
            while (iterator.hasNext()) {
                PolicyClassLoader imp = (PolicyClassLoader)iterator.next();
                this.warnings.add(0, new UnusedImport(imp));
            }
            this.endTime = System.currentTimeMillis();
        }

        void addLoaderToImport(PolicyClassLoader loader) {
            if (loader.isSharedLoader()) {
                this.sharedLoadersToImport.add(loader);
                ++this.importErrorCount;
            }
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public int getExecutionTimeSeconds() {
            return (int)(this.endTime - this.startTime) / 1000;
        }

        public List getSubscribers() {
            return this.susbscribers;
        }

        public boolean isDefaultImport() {
            return this.defaultImport;
        }

        public PolicyClassLoader getLoader() {
            return this.loader;
        }

        public Set getAllClasses() {
            return this.checked;
        }

        public List getNotes() {
            return this.notes;
        }

        public List getWarnings() {
            return this.warnings;
        }

        public List getErrors() {
            return this.errors;
        }

        public Set getMemberClasses() {
            return this.memberClasses.keySet();
        }

        public Set getMemberPackages() {
            return this.memberPackages;
        }

        public List getDependentClasses() {
            return this.dependentClasses;
        }

        public Set getDependentPackages() {
            return this.dependentPackages;
        }

        public Set getDependentLoaders() {
            return this.dependentLoaders;
        }

        public Set getDirectDependentClasses() {
            return this.directDependentClasses;
        }

        public Set getDirectDependentPackages() {
            return this.directDependentPackages;
        }

        public List getDuplicates() {
            return this.duplicates;
        }

        public Set getLoadersToImport() {
            return this.sharedLoadersToImport;
        }

        public int getImportErrorCount() {
            return this.importErrorCount;
        }

        private void collectMemberClasses(SharedCodeSource source) throws IOException {
            String[] paths = source.listFilePaths();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (!path.endsWith(".class")) continue;
                String className = path.replace('/', '.').substring(0, path.length() - 6);
                String packageName = Audit.getPackageName(className);
                SharedCodeSource original = (SharedCodeSource)this.memberClasses.get(className);
                if (original == null) {
                    this.memberClasses.put(className, source);
                } else {
                    this.duplicates.add(new DuplicateMember(className, original, source, this.verbose));
                }
                this.memberPackages.add(packageName);
                RecoverableByteBuffer buf = source.getResourceBytes(path, buffer);
                if (buf == null) {
                    throw new InternalError("buffer was null!");
                }
                buffer = buf;
                byte[] classData = buf.getArray();
                int classSize = buf.getBytesUsed();
                this.calls.visitClass(className, classData, classSize);
            }
        }

        private static String getPackageName(String className) {
            String packageName = className;
            int lastIndex = className.lastIndexOf(46);
            if (lastIndex >= 0) {
                packageName = packageName.substring(0, lastIndex);
            }
            return packageName;
        }

        public void checkDuplicates() {
            List visitedLoaders = ClassLoaderQuery.findLoadersVisitedBy((PolicyClassLoader)this.loader);
            SharedCodeSource[] sources = ClassLoaderQuery.findCodeSourcesNotVisitedBy((List)visitedLoaders);
            Iterator iterator = this.getMemberClasses().iterator();
            while (iterator.hasNext()) {
                String className = (String)iterator.next();
                String resourceName = className.replace('.', '/') + ".class";
                for (int i = 0; i < sources.length; ++i) {
                    SharedCodeSource source = sources[i];
                    try {
                        if (!this.containsDuplicate(source, resourceName)) continue;
                        SharedCodeSource original = (SharedCodeSource)this.memberClasses.get(className);
                        this.duplicates.add(new DuplicateNonMember(className, original, source, this.verbose));
                        continue;
                    }
                    catch (IOException e) {
                        ClassLoadLogger.log((Level)Level.WARNING, (String)("IOException " + e.getMessage() + " processing " + source));
                    }
                }
            }
        }

        private boolean containsDuplicate(SharedCodeSource source, String resourceName) throws IOException {
            if (source.containsResource(resourceName)) {
                PolicyClassLoader[] subscribers = source.getSubscribers().getSubscribers();
                for (int i = 0; i < subscribers.length; ++i) {
                    PolicyClassLoader subscriber = subscribers[i];
                    if (subscriber == null || subscriber.getName().equals(this.loader.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        private void loadAllDependencies(String className, int searchDepth) {
            if (!this.checked.contains(className)) {
                this.checked.add(className);
                boolean isMemberClass = this.memberClasses.get(className) != null;
                try {
                    PolicyClassLoader loader = searchDepth == 0 ? this.loader : this.dependencyChain[searchDepth - 1].getClassLoader();
                    Class<?> clz = loader.loadClass(className);
                    PolicyClassLoader defining = ClassLoaderQuery.getLoaderFor(clz);
                    String definingLoaderName = defining.getDisplayName();
                    if (searchDepth == this.dependencyChain.length) {
                        this.dependencyChain = (Class[])ArrayUtils.grow((Class)(class$java$lang$Class == null ? (class$java$lang$Class = AuditLoader.class$("java.lang.Class")) : class$java$lang$Class), (Object[])this.dependencyChain, (int)(this.dependencyChain.length * 2));
                    }
                    this.dependencyChain[searchDepth] = clz;
                    if (defining != loader) {
                        if (isMemberClass) {
                            this.warnings.add(new UnexpectedDefiningLoader(className, defining, this.verbose));
                        } else {
                            this.dependentLoaders.add(definingLoaderName);
                            this.dependentPackages.add(Audit.getPackageName(className));
                        }
                        this.unusedImports.remove(defining);
                    } else if (!this.unusedCodeSources.isEmpty()) {
                        SharedCodeSource cs = ClassLoaderQuery.getCodeSourceFor(clz);
                        this.unusedCodeSources.remove(cs);
                    }
                    if (this.includeJREClasses || clz.getClassLoader() != null) {
                        List dependencies = ClassLoaderQuery.getDependencies(clz);
                        Iterator iterator = dependencies.iterator();
                        while (iterator.hasNext()) {
                            String dependency = (String)iterator.next();
                            if (this.memberClasses.get(dependency) != null) continue;
                            if (searchDepth == 0) {
                                this.allDirectDependentClasses.add(dependency);
                            }
                            this.loadAllDependencies(dependency, searchDepth + 1);
                        }
                    }
                }
                catch (Throwable t) {
                    if (searchDepth == 0) {
                        this.errors.add(new Error(null, className, t, this.loader, this.verbose));
                    }
                    Class dependentClass = this.dependencyChain[searchDepth - 1];
                    if (dependentClass.getClassLoader() == this.loader) {
                        this.errors.add(new Error(dependentClass, className, t, this.loader, this.verbose));
                    }
                    this.warnings.add(new Error(dependentClass, className, t, this.loader, this.verbose, true));
                }
            }
        }

        private class ForName
        extends MethodSignature {
            public ForName() {
                super("java.lang.Class.forName(java.lang.String;java.lang.ClassLoader)java.lang.Class");
            }

            public void reportMatch(String callingClass, String callingMethodName, String callingMethodDesc) {
                if (!Audit.this.recordedForName) {
                    Audit.this.notes.add(new Message("Uses Class.forName(String, ClassLoader)"));
                    Audit.this.recordedForName = true;
                }
            }
        }

        private class ForNameNoLoader
        extends MethodSignature {
            public ForNameNoLoader() {
                super("java.lang.Class.forName(java.lang.String)java.lang.Class");
            }

            public void reportMatch(String callingClass, String callingMethodName, String callingMethodDesc) {
                if (!callingMethodName.equals("class$")) {
                    String caller = callingClass + " " + callingMethodName + "()";
                    if (!Audit.this.recordedForNameNoLoader.contains(caller)) {
                        Audit.this.warnings.add(new Message(caller + " uses Class.forName(String) but should pass loader."));
                        Audit.this.recordedForNameNoLoader.add(caller);
                    }
                }
            }
        }

        private class LoadClass
        extends MethodSignature {
            public LoadClass() {
                super("java.lang.ClassLoader.loadClass(java.lang.String)java.lang.Class");
            }

            public void reportMatch(String callingClass, String callingMethodName, String callingMethodDesc) {
                if (!Audit.this.recordedLoadClass) {
                    Audit.this.notes.add(new Message("Uses ClassLoader.loadClass(String)"));
                    Audit.this.recordedLoadClass = true;
                }
            }
        }

        public class Error
        extends ClassResult {
            private Class dependee;
            private Throwable error;
            private PolicyClassLoader loader;
            private boolean warning;

            public Error(Class dependee, String failedClass, Throwable error, PolicyClassLoader loader, boolean verbose) {
                super(dependee == null ? failedClass : dependee.getName(), failedClass, verbose);
                this.dependee = dependee;
                this.error = error;
                this.loader = loader;
            }

            public Error(Class dependee, String failedClass, Throwable error, PolicyClassLoader loader, boolean verbose, boolean warnOnly) {
                this(dependee, failedClass, error, loader, verbose);
                this.warning = warnOnly;
            }

            public Throwable getError() {
                return this.error;
            }

            protected void append() {
                String memberClass = this.getMemberClass();
                String failedClass = this.getTargetClass();
                Throwable error = this.getError();
                boolean direct = this.isDirect();
                if (direct) {
                    this.append(failedClass);
                    this.append(": ");
                } else {
                    this.append(failedClass);
                    this.append(" (dependency of ");
                    this.append(memberClass);
                    if (this.dependee != null && this.dependee.getClassLoader() != this.loader) {
                        this.append(" in ");
                        this.append(ClassLoaderQuery.getDisplayNameFor((ClassLoader)this.dependee.getClassLoader(), (boolean)false));
                    }
                    this.append("): ");
                }
                if (error instanceof AnnotatedThrowable) {
                    boolean done = false;
                    ThrowableAnnotation annotation = ((AnnotatedThrowable)error).getAnnotation();
                    if (annotation instanceof MissingClass) {
                        MissingClass missing = (MissingClass)annotation;
                        List otherSources = missing.getAvailableElsewhere();
                        if (otherSources.isEmpty()) {
                            this.append(missing.getMissingClassName());
                            this.append(" NOT FOUND, and not available in any loader.");
                            done = true;
                        } else {
                            List loaders = AuditLoader.getLoaders(otherSources);
                            if (loaders.size() == 0 && otherSources.size() == 1) {
                                this.append(missing.getMissingClassName());
                                this.append(" NOT FOUND, but available in " + otherSources.get(0) + ".");
                                done = true;
                            } else if (loaders.size() == 1) {
                                this.append(missing.getMissingClassName());
                                PolicyClassLoader loader = (PolicyClassLoader)loaders.get(0);
                                this.append(" NOT FOUND, but available in " + loader + ".");
                                if (!this.warning) {
                                    Audit.this.addLoaderToImport(loader);
                                }
                                done = true;
                            } else if (loaders.size() > 1) {
                                this.append(missing.getMissingClassName());
                                this.appendln(" NOT FOUND, but available in the following loaders:");
                                this.appendln();
                                for (int i = 0; i < loaders.size(); ++i) {
                                    PolicyClassLoader l = (PolicyClassLoader)loaders.get(i);
                                    this.indent();
                                    this.indentLineNumber(i);
                                    this.appendln(l.getDisplayName());
                                    if (this.warning) continue;
                                    Audit.this.addLoaderToImport(this.loader);
                                }
                                this.appendln();
                                done = true;
                            }
                        }
                    }
                    if (!done) {
                        this.appendln();
                        this.appendln();
                        this.appendWrapped("", 8, Integer.MAX_VALUE, error);
                        this.appendln();
                    }
                } else {
                    this.append(error);
                }
            }
        }

        public class UnexpectedDefiningLoader
        extends ClassResult {
            private PolicyClassLoader loader;

            public UnexpectedDefiningLoader(String memberClass, PolicyClassLoader loader, boolean verbose) {
                super(memberClass, memberClass, verbose);
                this.loader = loader;
            }

            protected void append() {
                if (this.loader.isSharedLoader()) {
                    this.append("Found " + this.getMemberClass() + " in imported shared-library: " + this.loader.getDisplayName());
                } else {
                    this.append("Found " + this.getMemberClass() + " in parent loader: " + this.loader.getDisplayName());
                }
                this.append(". Consider removing this class.");
            }
        }

        public class DuplicateNonMember
        extends ClassResult {
            private SharedCodeSource original;
            private SharedCodeSource duplicate;

            public DuplicateNonMember(String memberClass, SharedCodeSource original, SharedCodeSource duplicate, boolean verbose) {
                super(memberClass, memberClass, verbose);
                this.original = original;
                this.duplicate = duplicate;
            }

            protected void append() {
                String origFile = this.original.getFile().getName();
                String dupFile = this.duplicate.getFile().getName();
                String loaders = "";
                boolean started = false;
                PolicyClassLoader[] subscribers = this.duplicate.getSubscribers().getSubscribers();
                for (int i = 0; i < subscribers.length; ++i) {
                    if (subscribers[i] == null) continue;
                    if (!started) {
                        started = true;
                        loaders = subscribers[i].getDisplayName();
                        continue;
                    }
                    loaders = loaders + ", ";
                    loaders = loaders + subscribers[i].getDisplayName();
                }
                this.append(this.getMemberClass() + " from " + origFile + " is also available in " + dupFile + " in " + loaders + ". Consider refactoring into another shared-library.");
            }
        }

        public class DuplicateMember
        extends ClassResult {
            private SharedCodeSource original;
            private SharedCodeSource duplicate;

            public DuplicateMember(String memberClass, SharedCodeSource original, SharedCodeSource duplicate, boolean verbose) {
                super(memberClass, memberClass, verbose);
                this.original = original;
                this.duplicate = duplicate;
            }

            protected void append() {
                String origFile = this.original.getFile().getName();
                String dupFile = this.duplicate.getFile().getName();
                if (this.original == this.duplicate) {
                    this.append(this.getMemberClass() + " was found more than once in " + origFile + ". All but one should be removed.");
                } else {
                    this.append(this.getMemberClass() + " was found in both " + origFile + " and " + dupFile + ". The latter instance will be ignored and should be removed.");
                }
            }
        }

        public abstract class ClassResult
        extends Result {
            private String memberClass;
            private String targetClass;
            private boolean verbose;

            protected ClassResult(String memberClass, String targetClass, boolean verbose) {
                this.memberClass = memberClass;
                this.targetClass = targetClass;
                this.verbose = verbose;
            }

            public String getMemberClass() {
                return this.memberClass;
            }

            public String getTargetClass() {
                return this.targetClass;
            }

            public boolean isDirect() {
                return this.memberClass.equals(this.targetClass);
            }

            public boolean verbose() {
                return this.verbose;
            }
        }

        public static class UnusedImport
        extends Result {
            private PolicyClassLoader imp;

            public UnusedImport(PolicyClassLoader imp) {
                this.imp = imp;
            }

            protected void append() {
                this.append("No classes were loaded from import " + this.imp.getDisplayName() + ". Consider removing.");
            }
        }

        public static class UnusedCodeSource
        extends Result {
            private SharedCodeSource source;

            public UnusedCodeSource(SharedCodeSource cs) {
                this.source = cs;
            }

            protected void append() {
                this.append("No classes were loaded from " + this.source + ". Consider removing.");
            }
        }

        public static class Message
        extends Result {
            private String msg;

            public Message(String msg) {
                this.msg = msg;
            }

            protected void append() {
                this.append(this.msg);
            }
        }

        public static abstract class Result
        extends ReportQuery {
            public String getDescription() {
                return null;
            }

            public void createQueryReport(String[] args) throws Exception {
            }

            public String toString() {
                this.append();
                return this.getReport();
            }

            protected abstract void append();
        }
    }
}

