/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.peek.LogHandler;
import oracle.oc4j.peek.LoggerHandler;
import oracle.oc4j.peek.LoggerTree;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.TreeHandler;

public class LoggersHandler
extends TreeHandler {
    private static final String ARROW = "&#8658;";
    private static final String LEFT_SPACE_ARROW = " &#8658;";
    private static final String BOTH_SPACE_ARROW = " &#8658; ";
    private static final String TREE_VIEW = "tree";
    private static final String TABLE_VIEW = "table";
    private static final String COOKIE_NAME = "loggers.view";
    private static final String TABLE_SCRIPT = "<script type=\"text/javascript\" id=\"js\">\n\t$(document).ready(function() {\n\t\t$(\"table\").tablesorter({\n\t\t\tsortList: [[0,0]]\n\t\t});\n\t});\n</script>\n";
    private static final String TABLE_BEGIN = "<table class=\"tablesorter\" cellspacing=\"1\"> \n<thead>\n<tr>\n    <th>Name</th>\n    <th>Type</th>\n    <th>Parent</th>\n    <th>Level</th>\n    <th>Handlers</th>\n</tr>\n</thead>\n<tbody>\n";
    private static final String TABLE_END = "</tbody>\n</table>\n";
    private static final String[] LOG_PREFIXES = new String[]{"com.sun.", "com.evermind.", "oracle.as.", "oracle.ias.", "oracle.j2ee.", "oracle.oc4j.", "oracle."};

    public String getURISuffix() {
        return "loggers";
    }

    protected void extraHeaders(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.getWriter().write(TABLE_SCRIPT);
    }

    protected void writeTree(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean asTable = this.useTableView(pathArgument, request, response);
        PrintWriter out = response.getWriter();
        LoggerTree tree = new LoggerTree();
        ((Writer)out).write("<h3>Handlers</h3>\n");
        List handlers = tree.getHandlers();
        for (int i = 0; i < handlers.size(); ++i) {
            Level level;
            LoggerTree.HandlerRef ref = (LoggerTree.HandlerRef)handlers.get(i);
            String path = ref.getLogFile();
            int refCount = ref.getReferenceCount();
            Handler h = ref.getHandler();
            String title = h.toString();
            String link = LogHandler.getLinkTo(path, title);
            this.writeHandlerRefAnchor(ref, out);
            ((Writer)out).write(BOTH_SPACE_ARROW);
            boolean isTrace = LoggersHandler.isTraceHandler(h);
            if (isTrace) {
                ((Writer)out).write("<b class=\"trace\">");
            }
            ((Writer)out).write(link);
            if (isTrace) {
                ((Writer)out).write("</b>");
            }
            ((Writer)out).write(" (");
            ((Writer)out).write(Integer.toString(refCount));
            if (isTrace) {
                ((Writer)out).write(" trace");
            }
            ((Writer)out).write(" logger");
            if (refCount != 1) {
                ((Writer)out).write("s");
            }
            if ((level = h.getLevel()).intValue() != Level.ALL.intValue()) {
                ((Writer)out).write(". Note: handler filters messages below " + level + "!");
            }
            ((Writer)out).write(")<br>\n");
        }
        ((Writer)out).write("<br>\n");
        this.writeLoggers(out, tree, asTable);
    }

    protected boolean useTableView(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean asTable = true;
        String view = LoggersHandler.getCookieValue(COOKIE_NAME, null, request);
        if (TABLE_VIEW.equals(pathArgument) && !TABLE_VIEW.equals(view)) {
            view = TABLE_VIEW;
            LoggersHandler.setCookie(COOKIE_NAME, view, response);
        } else if (TREE_VIEW.equals(pathArgument) && !TREE_VIEW.equals(view)) {
            view = TREE_VIEW;
            asTable = false;
            LoggersHandler.setCookie(COOKIE_NAME, view, response);
        } else if (TREE_VIEW.equals(view)) {
            asTable = false;
        }
        return asTable;
    }

    protected void writeLoggers(Writer out, LoggerTree tree, boolean asTable) throws Exception {
        out.write("<h3 class=\"no-break\">Loggers</h3>      | ");
        if (asTable) {
            this.writeSwitchViewLink(TREE_VIEW, out);
            out.write(" | ");
            this.writeCurrentViewName(TABLE_VIEW, out);
            out.write(" |  <em>Click header to sort. Hold shift key to sort multiple columns.</em>");
        } else {
            this.writeCurrentViewName(TREE_VIEW, out);
            out.write(" | ");
            this.writeSwitchViewLink(TABLE_VIEW, out);
            out.write(" |");
        }
        out.write("<br />\n");
        out.write("<br />\n");
        if (asTable) {
            this.writeTable(out, tree);
        } else {
            this.writeNode(out, tree, tree.getRoot(), false, new boolean[128], 0);
        }
        out.write("<br>\n");
    }

    private void writeCurrentViewName(String currentView, Writer out) throws Exception {
        out.write("<b>");
        out.write(currentView);
        out.write("</b>");
    }

    private void writeSwitchViewLink(String otherViewName, Writer out) throws Exception {
        out.write("<a title=\"Switch to ");
        out.write(otherViewName);
        out.write(" view.\" href=\"");
        out.write(Peek.getContextRoot());
        out.write(this.getURISuffix());
        out.write(47);
        out.write(otherViewName);
        out.write("\">");
        out.write(otherViewName);
        out.write("</a>");
    }

    private void writeHandlerRefAnchor(LoggerTree.HandlerRef ref, Writer out) throws Exception {
        out.write("<a name=\"h");
        out.write(Integer.toString(ref.getID()));
        out.write("\">");
        out.write("<b class=\"num-box\">");
        out.write(Integer.toString(ref.getID()));
        out.write("&nbsp;</b>");
        out.write("</a>");
        out.write("&nbsp;");
    }

    private void writeHandlerRefLink(LoggerTree tree, Handler h, Writer out) throws Exception {
        LoggerTree.HandlerRef ref = tree.getRefFor(h);
        out.write("<a href=\"#h");
        out.write(Integer.toString(ref.getID()));
        out.write("\">");
        out.write("<b class=\"num-box\">");
        out.write(Integer.toString(ref.getID()));
        out.write("&nbsp;</b>");
        out.write("</a>");
    }

    private void writeNode(Writer out, LoggerTree tree, LoggerTree.Node node, boolean parentsLastChild, boolean[] parentDepth, int depth) throws Exception {
        Logger l = node.getLogger();
        boolean isTrace = LoggersHandler.isTraceLogger(l);
        if (isTrace) {
            out.write("<b class=\"trace\">");
        }
        String link = LoggerHandler.getLinkTo(l, LoggersHandler.getTitle(l));
        LoggersHandler.startNode(link, out, parentsLastChild, parentDepth, depth);
        if (isTrace) {
            out.write("</b>");
        }
        this.writeLoggerConfig(tree, l, out);
        out.write(10);
        List children = node.getChildren();
        int childCount = children.size();
        int lastChild = childCount - 1;
        for (int i = 0; i < childCount; ++i) {
            LoggerTree.Node child = (LoggerTree.Node)children.get(i);
            this.writeNode(out, tree, child, i == lastChild, parentDepth, depth + 1);
        }
        LoggersHandler.endNode(out, parentDepth, depth);
    }

    private void writeLoggerConfig(LoggerTree tree, Logger logger, Writer out) throws Exception {
        if (logger != null) {
            boolean useParent = logger.getUseParentHandlers();
            Handler[] handlers = logger.getHandlers();
            Level level = logger.getLevel();
            boolean wroteArrow = false;
            if (level == null && !useParent) {
                level = LoggerTree.ROOT_LEVEL;
            }
            if (level != null) {
                out.write(32);
                out.write(level.toString());
                out.write(LEFT_SPACE_ARROW);
                wroteArrow = true;
            }
            if (handlers != null && handlers.length > 0) {
                if (wroteArrow) {
                    out.write(32);
                } else {
                    out.write(BOTH_SPACE_ARROW);
                }
                boolean first = true;
                for (int i = 0; i < handlers.length; ++i) {
                    Handler h = handlers[i];
                    if (first) {
                        first = false;
                    } else {
                        out.write(32);
                    }
                    this.writeHandlerRefLink(tree, h, out);
                }
            }
            if (useParent) {
                this.writeLoggerConfig(tree, logger.getParent(), out);
            }
        }
    }

    public static boolean isTraceLogger(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        return handlers != null && handlers.length == 1 && LoggersHandler.isTraceHandler(handlers[0]);
    }

    private static boolean isTraceHandler(Handler handler) {
        return handler.getClass().getName().startsWith(TraceLogger.class.getName());
    }

    private static String getLoggerType(Logger logger, boolean initialCap) {
        if (LoggersHandler.isTraceLogger(logger)) {
            return initialCap ? "Trace" : "trace";
        }
        String name = logger.getName();
        if (name.equals("") || name.equals("global")) {
            return initialCap ? "JRE" : "jre";
        }
        for (int i = 0; i < LOG_PREFIXES.length; ++i) {
            String prefix = LOG_PREFIXES[i];
            if (!name.startsWith(prefix)) continue;
            return LoggersHandler.getLoggerType(name, prefix, initialCap);
        }
        return LoggersHandler.getLoggerType(name, "", initialCap);
    }

    private static String getLoggerType(String loggerName, String prefix, boolean initialCap) {
        int dot;
        String result = loggerName.substring(prefix.length());
        if (initialCap && result.length() > 2) {
            result = Character.toUpperCase(result.charAt(0)) + result.substring(1);
        }
        if ((dot = result.indexOf(46)) > 0) {
            result = result.substring(0, dot);
        }
        return result;
    }

    static String getTitle(Logger logger) {
        StringBuffer buf = new StringBuffer();
        buf.append(LoggersHandler.getLoggerType(logger, true));
        buf.append(" logger ");
        buf.append(LoggerTree.getDisplayName(logger));
        buf.append(" (");
        buf.append(Integer.toHexString(System.identityHashCode(logger)));
        buf.append(')');
        return buf.toString();
    }

    private void writeTable(Writer out, LoggerTree tree) throws Exception {
        out.write(TABLE_BEGIN);
        List nodes = tree.getNodes();
        Collections.sort(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            LoggerTree.Node node = (LoggerTree.Node)nodes.get(i);
            this.writeTableRow2(out, tree, node);
        }
        out.write(TABLE_END);
    }

    private void writeTableRow2(Writer out, LoggerTree tree, LoggerTree.Node node) throws Exception {
        out.write("<tr>\n");
        Logger logger = node.getLogger();
        String link = LoggerHandler.getLinkTo(logger, LoggersHandler.getTitle(logger));
        this.writeTableCell(out, link);
        String type = LoggersHandler.getLoggerType(logger, false);
        this.writeTableCell(out, type);
        Logger parent = logger.getParent();
        if (parent == null) {
            this.writeTableCell(out, "none");
        } else {
            link = LoggerHandler.getLinkTo(parent, LoggersHandler.getTitle(parent));
            this.writeTableCell(out, link);
        }
        String level = LoggerHandler.getLevel(logger).toString();
        if (parent == null) {
            level = level + "&nbsp;&nbsp;&nbsp;";
        }
        this.writeTableCell(out, level);
        StringBuffer buf = new StringBuffer(1024);
        this.appendHandlerLinks(tree, logger, buf);
        this.writeTableCell(out, buf.toString());
        out.write("</tr>\n");
    }

    private void appendHandlerLinks(LoggerTree tree, Logger logger, StringBuffer buf) {
        if (logger != null) {
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler h = handlers[i];
                LoggerTree.HandlerRef ref = tree.getRefFor(h);
                String id = Integer.toString(ref.getID());
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append("<a href=\"#h");
                buf.append(id);
                buf.append("\">");
                buf.append("<b class=\"num-box\">");
                buf.append(id);
                buf.append("&nbsp;</b>");
                buf.append("</a>");
            }
            Logger parent = logger.getParent();
            if (parent == null) {
                buf.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            } else if (logger.getUseParentHandlers()) {
                this.appendHandlerLinks(tree, parent, buf);
            }
        }
    }

    private void writeTableCell(Writer out, String cell) throws Exception {
        out.write("   <td>");
        out.write(cell);
        out.write("</td>\n");
    }
}

