/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.classloader.util.LogStreamHandler;
import oracle.j2ee.util.TraceLogger;

public class LoggerTree {
    public static final String UNKNOWN = "unknown";
    public static final String CONSOLE = "console";
    public static final Level ROOT_LEVEL = LogManager.getLogManager().getLogger("").getLevel();
    private static final String ROOT_NAME = "root";
    private static final String ODL_HANDLER_CLASS = "oracle.core.ojdl.logging.ODLHandler";
    private static final String ODL_HANDLER_LOG_WRITER_FIELD_NAME = "m_logWriter";
    private static final String ODL_WRITER_CANONICAL_PATH_FIELD_NAME = "m_canonicalPath";
    private Node root;
    private Map handlers = new HashMap();
    private List handlerRefs = new ArrayList();
    private Set loggerTypes = new HashSet();
    private Set formatterTypes = new HashSet();
    private Map loggers = new HashMap();
    private List nodes = new ArrayList();

    public static String getDisplayName(Logger logger) {
        String loggerName = logger.getName();
        if (loggerName.length() == 0) {
            loggerName = ROOT_NAME;
        }
        return loggerName;
    }

    public LoggerTree() {
        int i;
        this.root = this.getNode(Logger.getLogger(""));
        LogManager mgr = LogManager.getLogManager();
        Enumeration<String> e = mgr.getLoggerNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Logger logger = mgr.getLogger(name);
            this.loggerTypes.add(logger.getClass());
            this.addHandlers(logger);
            this.getNode(logger);
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            this.wire((Node)this.nodes.get(i));
        }
        Collections.sort(this.handlerRefs);
        for (i = 0; i < this.handlerRefs.size(); ++i) {
            ((HandlerRef)this.handlerRefs.get(i)).setID(i + 1);
        }
    }

    private void addHandlers(Logger logger) {
        Logger parent;
        Handler[] handlerarray = logger.getHandlers();
        for (int i = 0; i < handlerarray.length; ++i) {
            Handler h = handlerarray[i];
            HandlerRef ref = (HandlerRef)this.handlers.get(h);
            if (ref == null) {
                ref = new HandlerRef(h);
                this.handlers.put(h, ref);
                this.handlerRefs.add(ref);
            } else {
                ref.addReference();
            }
            Formatter f = h.getFormatter();
            if (f == null) continue;
            this.formatterTypes.add(f.getClass());
        }
        if (logger.getUseParentHandlers() && (parent = logger.getParent()) != null) {
            this.addHandlers(parent);
        }
    }

    private void wire(Node n) {
        Node parent = null;
        if (n != this.root && n.getParent() == null) {
            Logger parentLogger = n.getLogger().getParent();
            if (parentLogger != null) {
                parent = (Node)this.loggers.get(parentLogger);
                n.setParent(parent);
            } else {
                System.out.println("WARNING: No parent found for " + n.getLogger().getName());
            }
        }
        if (parent != null) {
            parent.addChild(n);
        }
    }

    public List getNodes() {
        return this.nodes;
    }

    public Node getNode(Logger logger) {
        Node result = (Node)this.loggers.get(logger);
        if (result == null) {
            result = new Node(logger);
            this.loggers.put(logger, result);
            this.nodes.add(result);
        }
        return result;
    }

    public Node getRoot() {
        return this.root;
    }

    public List getHandlers() {
        return this.handlerRefs;
    }

    public Set getLoggerTypes() {
        return this.loggerTypes;
    }

    public Set getFormatterTypes() {
        return this.formatterTypes;
    }

    public List getLoggers() {
        return this.nodes;
    }

    public HandlerRef getRefFor(Handler h) {
        return (HandlerRef)this.handlers.get(h);
    }

    public static String getLogFile(Handler handler) {
        String result = UNKNOWN;
        handler.flush();
        Class<?> c = handler.getClass();
        if (c == LogStreamHandler.class) {
            if (((LogStreamHandler)handler).getFile() != null) {
                result = ((LogStreamHandler)handler).getFile().getPath();
            }
        } else if (c.getName().equals(ODL_HANDLER_CLASS)) {
            result = LoggerTree.getODLHandlerPath(handler);
        } else if (c == ConsoleHandler.class) {
            result = LoggerTree.getConsoleLogFile();
        } else if (c.getName().startsWith(TraceLogger.class.getName())) {
            result = LoggerTree.getConsoleLogFile();
        } else if (c == StreamHandler.class) {
            result = LoggerTree.getConsoleLogFile();
        }
        return result;
    }

    private static String getConsoleLogFile() {
        return CONSOLE;
    }

    private static String getODLHandlerPath(Handler handler) {
        String result;
        Class<?> handlerClass = handler.getClass();
        try {
            Field logWriterField = handlerClass.getDeclaredField(ODL_HANDLER_LOG_WRITER_FIELD_NAME);
            logWriterField.setAccessible(true);
            Object logWriter = logWriterField.get(handler);
            Field pathField = logWriter.getClass().getDeclaredField(ODL_WRITER_CANONICAL_PATH_FIELD_NAME);
            pathField.setAccessible(true);
            result = (String)pathField.get(logWriter);
        }
        catch (Exception e) {
            result = UNKNOWN;
        }
        return result;
    }

    public static class HandlerRef
    implements Comparable {
        private int id;
        private Handler handler;
        private int referenceCount;

        public HandlerRef(Handler h) {
            this.handler = h;
            this.referenceCount = 1;
        }

        void setID(int id) {
            this.id = id;
        }

        public void addReference() {
            ++this.referenceCount;
        }

        public int getID() {
            return this.id;
        }

        public int hashCode() {
            return this.handler.hashCode();
        }

        public boolean equals(Object it) {
            return this.handler.equals(it);
        }

        public int compareTo(Object ref) {
            return ((HandlerRef)ref).referenceCount - this.referenceCount;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public int getReferenceCount() {
            return this.referenceCount;
        }

        public String getLogFile() {
            return LoggerTree.getLogFile(this.handler);
        }
    }

    public static class Node
    implements Comparable {
        private Node parent;
        private Logger logger;
        private String sortName;
        private List children = new ArrayList();
        private boolean sorted;

        private Node(Logger logger) {
            this.logger = logger;
            this.sortName = LoggerTree.getDisplayName(logger).toLowerCase();
        }

        public Node getParent() {
            return this.parent;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public List getChildren() {
            if (!this.sorted) {
                Collections.sort(this.children);
                this.sorted = true;
            }
            return this.children;
        }

        public void addChild(Node child) {
            this.children.add(child);
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public int compareTo(Object node) {
            return this.sortName.compareTo(((Node)node).sortName);
        }
    }
}

