/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ClassLoadTracing;
import oracle.classloader.util.LocalizedText;
import oracle.classloader.util.LogStreamHandler;
import oracle.oc4j.peek.LogHandler;
import oracle.oc4j.peek.LoggerTree;
import oracle.oc4j.peek.LoggersHandler;
import oracle.oc4j.peek.PageHandler;
import oracle.oc4j.peek.Peek;

public class LoggerHandler
extends PageHandler {
    private static final String LEVEL_PARAM = "level";
    private static final String FILE_PARAM = "file";
    private static final String REMOVE_FILE_PARAM = "remove";
    private static final String RESET_OPTIONS_PARAM = "reset";
    private static final String MESSAGE_PARAM = "msg";
    private static final String MESSAGE_LEVEL_PARAM = "msg-level";
    private static final String OPTIONS_PARAM = "options";
    private static final Pattern REMOVE_PATTERN = Pattern.compile("-DX=");
    private static final String SUBMIT_BUTTON = "<input type=\"submit\" id=\"logger-submit\" value=\"Update\" />\n";
    private static final String FILE_BEGIN_FIXED = "<input type=\"text\" name=\"file\" id=\"file\" value=\"";
    private static final String FILE_BEGIN_VARIABLE_1 = "<input type=\"text\" name=\"file\" size=\"";
    private static final String FILE_BEGIN_VARIABLE_2 = "\" value=\"";
    private static final String FILE_END = "\"/>\n";
    private static final String FILE_BEGIN_DEFAULT = "<input type=\"text\" name=\"file\" id=\"file-default\" value=\"";
    private static final String FILE_END_DEFAULT = "&lt;add file&gt;\" onclick=\"clickClear(this, '&lt;add file&gt;')\" onblur=\"clickRecall(this,'&lt;add file&gt;')\"/><br />\n";
    private static final String MESSAGE_BOX = "<br /><textarea rows=\"5\" name=\"msg\" id=\"msg\" onclick=\"clickClear(this, '&lt;write to log&gt;')\" onblur=\"clickRecall(this,'&lt;write to log&gt;')\">&lt;write to log&gt;</textarea>\n";
    private static final String OPTIONS_BOX_BEGIN_FIXED = "<input type=\"text\" name=\"options\" id=\"options\" value=\"";
    private static final String OPTIONS_BOX_BEGIN_VARIABLE_1 = "<input type=\"text\" name=\"options\" size=\"";
    private static final String OPTIONS_BOX_BEGIN_VARIABLE_2 = "\" value=\"";
    private static final String OPTIONS_BOX_END = "\"/>\n";
    private static final String OPTIONS_BOX_END_DEFAULT = "&lt;see below&gt;\" onclick=\"clickClear(this, '&lt;see below&gt;')\" onblur=\"clickRecall(this,'&lt;see below&gt;')\"/>\n";
    protected static final String[] INFO_BOX = new String[]{"info-box"};
    private static final String BEGIN = "<div class=\"tree\">\n";
    private static final String END = "</div>\n";
    private static final int MAX_FIXED_TEXT_SIZE = 90;
    public static Level[] LEVELS = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};

    public String getURISuffix() {
        return "logger";
    }

    public static String getLinkTo(Logger logger) {
        return LoggerHandler.getLinkTo(logger, null);
    }

    public static String getLinkTo(Logger logger, String title) {
        if (logger == null) {
            return "none";
        }
        StringBuffer buf = new StringBuffer(256);
        if (title != null) {
            buf.append("<a title=\"");
            buf.append(title);
            buf.append("\" href=\"");
        } else {
            buf.append("<a href=\"");
        }
        buf.append(Peek.getContextRoot());
        buf.append("logger/");
        String name = LoggerTree.getDisplayName(logger);
        buf.append(name);
        buf.append("\">");
        buf.append(name);
        buf.append("</a>");
        return buf.toString();
    }

    protected void pageBody(String loggerName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        Logger logger = LogManager.getLogManager().getLogger(loggerName);
        if (logger == null && loggerName.equals("root")) {
            logger = LogManager.getLogManager().getLogger("");
        }
        if (logger == null) {
            ((Writer)out).write("Unknown logger: ");
            ((Writer)out).write(loggerName);
        } else {
            String msg;
            ((Writer)out).write(BEGIN);
            boolean isClassLoaderLogger = logger == ClassLoadLogger.getLogger();
            String query = request.getQueryString();
            if (query != null && query.length() > 0 && (msg = LoggerHandler.applyChanges(request, logger, isClassLoaderLogger)) != null && msg.length() > 0) {
                ((Writer)out).write(msg);
                ((Writer)out).write("<br />\n");
                ((Writer)out).write("<br />\n");
            }
            LoggerHandler.writeHeading3(LoggersHandler.getTitle(logger), out);
            ((Writer)out).write("<br />\n");
            ((Writer)out).write("<form action=\"");
            ((Writer)out).write(Peek.getContextRoot());
            ((Writer)out).write("logger/");
            ((Writer)out).write(loggerName);
            ((Writer)out).write("\">\n");
            LoggerHandler.beginTable(out);
            String parentLink = LoggerHandler.getLinkTo(logger.getParent());
            LoggerHandler.writeTableRow("Parent", parentLink, INFO_BOX, 0, out);
            LoggerHandler.writeLevelDropBox(LEVEL_PARAM, LoggerHandler.getLevel(logger), out);
            LoggerHandler.writeMessageBox(logger, out);
            LoggerHandler.writeHandlers(logger, out);
            if (isClassLoaderLogger) {
                LoggerHandler.writeOptionsBox(logger, out);
            }
            LoggerHandler.endTable(out);
            ((Writer)out).write("<br />\n");
            ((Writer)out).write("<br />\n");
            ((Writer)out).write(SUBMIT_BUTTON);
            ((Writer)out).write("</form>\n");
            ((Writer)out).write("<br />\n");
            if (isClassLoaderLogger) {
                LocalizedText text = ClassLoadLogger.getText();
                String help0 = text.getText("log.usage");
                String help1 = text.getText("log.usage.1", (Object)"X");
                help1 = REMOVE_PATTERN.matcher(help1).replaceAll("");
                ((Writer)out).write("<div class=\"black\">\n");
                ((Writer)out).write("<pre>");
                ((Writer)out).write(LoggerHandler.cleanAngleBrackets(help0));
                ((Writer)out).write("\n");
                ((Writer)out).write(LoggerHandler.cleanAngleBrackets(help1));
                ((Writer)out).write("</pre>");
                ((Writer)out).write("\n</div>\n");
            }
            ((Writer)out).write(END);
        }
    }

    protected static String cleanAngleBrackets(String string) {
        string = LESS_THAN.matcher(string).replaceAll("&lt;");
        string = GREATER_THAN.matcher(string).replaceAll("&gt;");
        return string;
    }

    private static String applyChanges(HttpServletRequest request, Logger logger, boolean isClassLoaderLogger) {
        String msg;
        String remove;
        String newFile;
        Level newLevel;
        String result = null;
        String newLevelStr = request.getParameter(LEVEL_PARAM);
        if (newLevelStr != null && (newLevel = Level.parse(newLevelStr)) != null && !newLevel.equals(LoggerHandler.getLevel(logger))) {
            if (isClassLoaderLogger) {
                ClassLoadLogger.setLogLevel((Level)newLevel);
            } else {
                logger.setLevel(newLevel);
            }
        }
        if ((newFile = request.getParameter(FILE_PARAM)) != null && newFile.length() > 0 && newFile.charAt(0) != '<') {
            result = LoggerHandler.setTempHandler(logger, newFile, isClassLoaderLogger);
        }
        if ((remove = request.getParameter(REMOVE_FILE_PARAM)) != null) {
            LoggerHandler.removeTempHandler(logger, isClassLoaderLogger);
        }
        if ((msg = request.getParameter(MESSAGE_PARAM)) != null && msg.length() > 0 && msg.charAt(0) != '<') {
            Level level = Level.CONFIG;
            String msgLevel = request.getParameter(MESSAGE_LEVEL_PARAM);
            if (msgLevel != null) {
                level = Level.parse(msgLevel);
            }
            logger.log(level, msg);
        }
        if (isClassLoaderLogger) {
            String reset;
            String options = request.getParameter(OPTIONS_PARAM);
            if (options != null && options.length() > 0 && options.charAt(0) != '<') {
                ClassLoadTracing.activate((String)options);
            }
            if ((reset = request.getParameter(RESET_OPTIONS_PARAM)) != null && reset.length() > 0) {
                ClassLoadTracing.deactivate();
            }
        }
        return result;
    }

    private static String setTempHandler(Logger logger, String path, boolean isClassLoaderLogger) {
        if (isClassLoaderLogger) {
            ClassLoadLogger.resetHandlers((String)path);
        } else {
            LoggerHandler.removeTempHandler(logger, false);
            try {
                logger.addHandler((Handler)new LogStreamHandler(path));
            }
            catch (Exception e) {
                return e.toString();
            }
        }
        return null;
    }

    private static Handler removeTempHandler(Logger logger, boolean isClassLoaderLogger) {
        if (isClassLoaderLogger) {
            ClassLoadLogger.resetHandlers(null);
        } else {
            Handler[] array = logger.getHandlers();
            for (int i = 0; i < array.length; ++i) {
                Handler h = array[i];
                if (h.getClass() != (class$oracle$classloader$util$LogStreamHandler == null ? LoggerHandler.class$("oracle.classloader.util.LogStreamHandler") : class$oracle$classloader$util$LogStreamHandler)) continue;
                logger.removeHandler(h);
                return h;
            }
        }
        return null;
    }

    private static void writeOptionsBox(Logger logger, Writer out) throws Exception {
        LoggerHandler.beginTableRow("Options", INFO_BOX, 0, out);
        String options = ClassLoadEnvironment.getTraceOptions();
        if (options != null) {
            if (options.length() > 90) {
                out.write(OPTIONS_BOX_BEGIN_VARIABLE_1);
                out.write(Integer.toString(options.length()));
                out.write("\" value=\"");
            } else {
                out.write(OPTIONS_BOX_BEGIN_FIXED);
            }
            out.write(options);
            out.write("\"/>\n");
            out.write(" ");
            out.write("<a href=\"");
            out.write(Peek.getContextRoot());
            out.write("logger/");
            out.write(logger.getName());
            out.write(63);
            out.write(RESET_OPTIONS_PARAM);
            out.write("=true\">reset</a>");
        } else {
            out.write(OPTIONS_BOX_BEGIN_FIXED);
            out.write(OPTIONS_BOX_END_DEFAULT);
        }
        LoggerHandler.endTableRow(out);
    }

    private static void writeMessageBox(Logger logger, Writer out) throws Exception {
        LoggerHandler.beginTableRow("Message", INFO_BOX, 0, out);
        LoggerHandler.writeLevelDropBoxRow(MESSAGE_LEVEL_PARAM, LoggerHandler.getLevel(logger), out);
        out.write(MESSAGE_BOX);
        LoggerHandler.endTableRow(out);
    }

    private static void writeHandlers(Logger logger, Writer out) throws Exception {
        LoggerHandler.beginTableRow("Handlers", INFO_BOX, 0, out);
        LoggerHandler.writeHandlers(logger, out, false, 1);
        LoggerHandler.endTableRow(out);
    }

    private static void writeHandlers(Logger logger, Writer out, boolean inherited, int handlerNumber) throws Exception {
        Logger parent;
        boolean wroteFileBox = false;
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (int i = 0; i < handlers.length; ++i) {
                Handler h = handlers[i];
                if (!LoggerHandler.writeHandler(logger, inherited, handlerNumber++, h, out)) continue;
                wroteFileBox = true;
            }
        }
        if (logger.getUseParentHandlers() && (parent = logger.getParent()) != null) {
            LoggerHandler.writeHandlers(parent, out, true, handlerNumber + 1);
        }
        if (!inherited && !wroteFileBox) {
            out.write(FILE_BEGIN_DEFAULT);
            out.write(FILE_END_DEFAULT);
        }
    }

    private static boolean writeHandler(Logger logger, boolean inherited, int handlerNumber, Handler handler, Writer out) throws Exception {
        String path = LoggerTree.getLogFile(handler);
        String title = handler.toString();
        out.write(Integer.toString(handlerNumber));
        out.write(". ");
        if (!inherited && handler.getClass() == LogStreamHandler.class) {
            if (path.length() > 90) {
                out.write(FILE_BEGIN_VARIABLE_1);
                out.write(Integer.toString(path.length()));
                out.write("\" value=\"");
            } else {
                out.write(FILE_BEGIN_FIXED);
            }
            out.write(path);
            out.write("\"/>\n");
            out.write(" ");
            out.write("<a href=\"");
            out.write(Peek.getContextRoot());
            out.write("log/");
            out.write(path);
            out.write("\">view</a>");
            out.write(" | ");
            out.write("<a href=\"");
            out.write(Peek.getContextRoot());
            out.write("logger/");
            out.write(logger.getName());
            out.write(63);
            out.write(REMOVE_FILE_PARAM);
            out.write("=true\">remove</a>");
            out.write("<br />\n");
            return true;
        }
        String link = LogHandler.getLinkTo(path, title);
        out.write(link);
        if (inherited) {
            out.write(" (inherited)");
        }
        if (!Level.ALL.equals(handler.getLevel())) {
            out.write(" Note: handler filters messages below " + handler.getLevel() + "!");
        }
        out.write("<br />\n");
        return false;
    }

    public static Level getLevel(Logger logger) {
        Level result = logger.getLevel();
        if (result == null) {
            if (logger.getUseParentHandlers()) {
                Logger parent = logger.getParent();
                if (parent != null) {
                    result = LoggerHandler.getLevel(parent);
                }
            } else {
                result = LoggerTree.ROOT_LEVEL;
            }
        }
        return result;
    }

    private static void writeLevelDropBox(String name, Level level, Writer out) throws Exception {
        LoggerHandler.beginTableRow("Level", INFO_BOX, 0, out);
        LoggerHandler.writeLevelDropBoxRow(name, level, out);
    }

    private static void writeLevelDropBoxRow(String name, Level level, Writer out) throws Exception {
        out.write("<select name=\"");
        out.write(name);
        out.write("\">\n");
        for (int i = 0; i < LEVELS.length; ++i) {
            Level l = LEVELS[i];
            String levelName = l.getName();
            out.write("<option value=\"");
            out.write(levelName);
            if (l.equals(level)) {
                out.write("\" selected>");
            } else {
                out.write("\">");
            }
            out.write(levelName);
            out.write("</option>\n");
        }
        out.write("</select>\n");
    }
}

