/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.peek;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.classloader.util.ClassLoadEnvironment;
import oracle.oc4j.peek.PageHandler;
import oracle.oc4j.peek.Peek;
import oracle.oc4j.peek.QueryHandler;

public class HelpHandler
extends PageHandler {
    private static final List QUERY_CLASS_NAMES = Peek.QUERY_CLASS_NAMES;
    private static final String HELP_0 = "<p>Select from the View menu above, or click one of the links below for detailed help.</p><p>To search for a class, resource or jar, enter the name above and click the 'go' button&#151;see ";
    private static final String HELP_1 = " or \n";
    private static final String HELP_2 = " for syntax details.</p>\n";
    private static final Set FILTERED_QUERIES = HelpHandler.getFilteredQueries();

    private static Set getFilteredQueries() {
        HashSet<String> result = new HashSet<String>();
        result.add("Exit");
        result.add("LoaderTree");
        result.add("ListQueries");
        result.add("SharedLibraries");
        return result;
    }

    public String getURISuffix() {
        return "help";
    }

    public static String getLinkTo(String queryClassName) {
        StringBuffer buf = new StringBuffer(256);
        buf.append("<a href=\"");
        buf.append(Peek.getContextRoot());
        buf.append("help/");
        buf.append(queryClassName);
        buf.append("\">");
        buf.append(queryClassName);
        buf.append("</a>");
        return buf.toString();
    }

    protected String getQueryFieldValue(String pathArgument, HttpServletRequest request) {
        if (pathArgument != null) {
            return pathArgument;
        }
        return super.getQueryFieldValue(pathArgument, request);
    }

    protected void pageBody(String pathArgument, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter out = response.getWriter();
        if (pathArgument == null) {
            HelpHandler.help(out);
        } else {
            HelpHandler.help(pathArgument, out);
        }
    }

    protected static void help(Writer out) throws Exception {
        out.write("<div class=\"black\">\n");
        out.write(HELP_0);
        out.write(HelpHandler.getLinkTo("FindResource"));
        out.write(HELP_1);
        out.write(HelpHandler.getLinkTo("FindCodeSource"));
        out.write(HELP_2);
        String link = HelpHandler.getHelpLink();
        if (link != null) {
            out.write("<p>Please see the <a target=\"wiki\" href=\"");
            out.write(link);
            out.write("\">wiki</a> page for further information.</p>");
        }
        HelpHandler.beginTable(out);
        Iterator iterator = QUERY_CLASS_NAMES.iterator();
        while (iterator.hasNext()) {
            String queryClassName = (String)iterator.next();
            String description = QueryHandler.getQueryDescription(queryClassName);
            if (description == null || FILTERED_QUERIES.contains(queryClassName)) continue;
            link = HelpHandler.getLinkTo(queryClassName) + "&nbsp;&nbsp;";
            HelpHandler.beginTableRow(link, "lightbg3", out);
            int eol = description.indexOf(10);
            if (eol < 0) {
                eol = description.length();
            }
            description = description.substring(0, eol);
            out.write(description);
            HelpHandler.endTableRow(out);
        }
        HelpHandler.endTable(out);
        out.write("<br />\n");
        out.write("</div>\n");
    }

    protected static void help(String queryClassName, Writer out) throws Exception {
        String name = ClassLoadEnvironment.getQueryClassName((String)queryClassName);
        String description = QueryHandler.getQueryDescription(name);
        out.write("<div class=\"black\">\n");
        int index = description.indexOf("Args:");
        if (index >= 0) {
            index = description.indexOf("loaderName", index);
        }
        if (index > 0) {
            out.write(description.substring(0, index));
            out.write("<form>\n");
            out.write("<select id=\"loader-name\" onChange=\"insertLoaderName()\">\n");
            out.write("<option value=''>-- loaderName --</option>\n");
            List names = HelpHandler.getLoaderNames();
            Iterator iterator = names.iterator();
            while (iterator.hasNext()) {
                String loaderName = (String)iterator.next();
                out.write("<option value=\" ");
                out.write(loaderName);
                out.write("\">");
                out.write(loaderName);
                out.write("</option>\n");
            }
            out.write("</select>\n");
            out.write("</form>\n");
            out.write(description.substring(index + 11));
        } else {
            out.write(description);
        }
        out.write("</div>");
    }
}

