/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.network;

import EDU.oswego.cs.dl.util.concurrent.Mutex;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.DoubleLinkedList;
import com.evermind.util.DoubleLinkedListNode;
import com.evermind.util.ThreadPool;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.oc4j.network.NIOServerSocketDriver;
import oracle.oc4j.network.ReadHandlerPool;
import oracle.oc4j.network.ServerSocketDriver;
import oracle.oc4j.network.ServerSocketReadHandler;

public class ServerSocketAcceptHandler {
    private NIOServerSocketDriver serverSocketDriver;
    private ServerSocketChannel serverSocketChannel;
    private InetSocketAddress endPoint;
    private ServerSocket serverSocket;
    private int backlog;
    private boolean clientAuth = false;
    private String[] cipherSuites;
    private ConnectionCount connMgr;
    private ThreadPool reqThreadPool;
    private ThreadPool connectionThreadPool;
    private ThreadPool emergencyThreadPool;
    private long maxDelayedAcceptWaitTime = 60000L;
    private SSLSocketFactory sslSocketFactory;
    private long MAX_READ_WAIT = 120000L;
    protected static boolean DEFAULT_MORE_REQUEST_FLAG = true;
    private boolean defaultMoreRequestFlag = DEFAULT_MORE_REQUEST_FLAG;
    private boolean suspended;
    private static final long DEFAULT_HOUSEKEEPING_INTERVAL = 3000L;
    private long houseKeepingInterval = 3000L;
    private long nextHouseKeeping;
    private IdleHandlers idleHandlers;
    private boolean blockingAccept;
    private boolean blockingRead;
    private ReadHandlerPool handlerPool;
    private int localPort = -1;
    public static final int NO_POOLING = -1;
    public static final int UNBOUND_POOLING = 0;
    private AcceptImpl impl;
    private volatile boolean shutdownInvoked;
    private volatile AcceptedSocketInfo lastAccepted = null;
    private volatile boolean idleConnectionFound = false;
    private static HashMap sharedPools = new HashMap();

    private static ReadHandlerPool createHandlerPool(int max, int min, ServerSocketAcceptHandler owner) {
        ReadHandlerPool pool = new ReadHandlerPool(min, max, 1000L, Long.MAX_VALUE);
        return pool;
    }

    public ServerSocketAcceptHandler(NIOServerSocketDriver driver, InetSocketAddress endPoint, int backlog) {
        this.serverSocketDriver = driver;
        this.endPoint = endPoint;
        this.backlog = backlog;
        this.disableHouseKeeping();
        this.idleHandlers = new IdleHandlers();
        this.setBlockingAccept(true);
        this.setBlockingRead(false);
        this.shutdownInvoked = false;
        this.connMgr = new ConnectionCount(Integer.MAX_VALUE);
    }

    void procAccepted(SelectionKey key, SocketChannel channel, Socket socket) {
        this.lastAccepted = new AcceptedSocketInfo(key, channel, socket);
        if (!this.connMgr.increment()) {
            return;
        }
        this.getThreadPool().launch(new AcceptHandlerHorse(key, channel, socket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolOptions(boolean shared, String name, int max, int min) {
        if (!shared) {
            this.handlerPool = ServerSocketAcceptHandler.createHandlerPool(max, min, this);
        } else {
            HashMap hashMap = sharedPools;
            synchronized (hashMap) {
                this.handlerPool = (ReadHandlerPool)sharedPools.get(name);
                if (this.handlerPool == null) {
                    this.handlerPool = ServerSocketAcceptHandler.createHandlerPool(max, min, this);
                    sharedPools.put(name, this.handlerPool);
                }
            }
        }
        this.handlerPool.register(this);
    }

    private void resumeAccept() {
        this.impl.resumeAccept();
    }

    private void suspendAccept() throws IOException {
        this.impl.suspendAccept();
    }

    public void setSSLSocketFactory(SSLSocketFactory _sslSocketFactory, SSLConfig sslConfig) {
        this.sslSocketFactory = _sslSocketFactory;
        this.clientAuth = null != sslConfig && "true".equalsIgnoreCase(sslConfig.getNeedsClientAuth());
        this.cipherSuites = null == sslConfig ? null : sslConfig.getCipherSuites();
    }

    public void setMaxConnection(int maxConnection) {
        this.connMgr.setMaxConnection(maxConnection);
    }

    public void setBlockingAccept(boolean blockingAccept) {
        this.blockingAccept = blockingAccept;
    }

    public void setBlockingRead(boolean blockingRead) {
        this.blockingRead = blockingRead;
    }

    protected boolean isSSLEnabled() {
        return this.sslSocketFactory != null;
    }

    private boolean isSuspended() {
        return this.suspended;
    }

    private void setSuspended(boolean supsended) {
        this.suspended = this.suspended;
    }

    void connect() throws IOException {
        this.impl = this.blockingAccept ? new BImpl() : new NBImpl();
        this.impl.connect();
    }

    private boolean doBindSockets(ServerSocketReadHandler handler, Socket realSocket, SSLSocket sslSocket) {
        try {
            handler.bindAcceptHandler(this);
            handler.setSockets(realSocket, sslSocket);
            handler.bindSocket();
            return true;
        }
        catch (Throwable e) {
            this.handlerPool.releaseHandlerNoEx(handler, false);
            return false;
        }
    }

    void selectorThreadHouseKeeping() {
        if (this.idleConnectionFound) {
            this.idleHandlers.expireHandlers();
            this.idleConnectionFound = false;
        }
    }

    private void procClientSocket(Socket realSocket, SSLSocket sslSocket, boolean newThread) {
        ServerSocketReadHandler handler = null;
        handler = this.handlerPool.getHandler(this.getLocalPort());
        if (!this.doBindSockets(handler, realSocket, sslSocket)) {
            return;
        }
        if (newThread) {
            this.getThreadPool().launch(handler.getSafeRunnable());
        } else {
            handler.getSafeRunnable().run();
        }
    }

    protected SSLSocket doSSLHandShaking(Socket clientSocket) throws IOException {
        if (!this.isSSLEnabled()) {
            return null;
        }
        SSLSocket sslSocket = (SSLSocket)this.sslSocketFactory.createSocket(clientSocket, this.endPoint.getHostName(), this.endPoint.getPort(), true);
        this.configureSocket(sslSocket);
        sslSocket.startHandshake();
        return sslSocket;
    }

    protected void configureSocket(SSLSocket sslSocket) {
        if (null != this.cipherSuites) {
            sslSocket.setEnabledCipherSuites(this.cipherSuites);
        }
        sslSocket.setWantClientAuth(this.clientAuth);
        sslSocket.setNeedClientAuth(this.clientAuth);
        sslSocket.setUseClientMode(false);
    }

    void noExCloseSocket(Socket socket, String message, Level level) {
        block9: {
            try {
                try {
                    if (this.isSSLEnabled()) {
                        socket.getChannel().configureBlocking(true);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    socket.shutdownInput();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (Exception e) {
                    // empty catch block
                }
                socket.close();
            }
            catch (Exception e) {
                if (!ServerSocketDriver.logger.isLoggable(level) || message == null) break block9;
                ServerSocketDriver.logger.log(level, message, e);
            }
        }
    }

    private void noExCloseServerSocket(ServerSocket sSocket, String message, Level level) {
        block2: {
            try {
                sSocket.close();
            }
            catch (Exception e) {
                if (!ServerSocketDriver.logger.isLoggable(level) || message == null) break block2;
                ServerSocketDriver.logger.log(level, message, e);
            }
        }
    }

    protected ServerSocketReadHandler getReadHandler() {
        return new ServerSocketReadHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectDelayedAcceptedNoSync() {
        try {
            block8: {
                if (!this.overwriteHandleDelayedAccepted()) {
                    this.noExCloseSocket(this.lastAccepted.socket, null, Level.WARNING);
                    Object var4_1 = null;
                    this.noExCloseSocket(this.lastAccepted.socket, "Exception in socket.close", Level.WARNING);
                    this.connMgr.decrement();
                    return;
                }
                try {
                    SSLSocket sslSocket = this.doSSLHandShaking(this.lastAccepted.socket);
                }
                catch (IOException e) {
                    if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block8;
                    ServerSocketDriver.logger.log(Level.WARNING, "IOException in ServerSocketAcceptHandler$AcceptHandlerHorse:run", e);
                }
            }
            try {
                this.handleDelayedAccepted(this.lastAccepted.socket.getOutputStream());
            }
            catch (Exception e) {
                if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                    ServerSocketDriver.logger.log(Level.WARNING, "IOException in timing out delayed accepted socket", e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.noExCloseSocket(this.lastAccepted.socket, "Exception in socket.close", Level.WARNING);
            this.connMgr.decrement();
            throw throwable;
        }
        Object var4_2 = null;
        this.noExCloseSocket(this.lastAccepted.socket, "Exception in socket.close", Level.WARNING);
        this.connMgr.decrement();
    }

    public ServerSocketChannel getServerSocketChannel() throws IOException {
        if (this.serverSocketChannel == null) {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocket = this.serverSocketChannel.socket();
            this.serverSocket.bind(this.endPoint, this.backlog);
            this.localPort = this.endPoint.getPort() == 0 ? this.serverSocket.getLocalPort() : this.endPoint.getPort();
        }
        return this.serverSocketChannel;
    }

    public SocketAddress getEndPoint() {
        return this.endPoint;
    }

    public boolean waitForAlive() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private void persistConnection(ServerSocketReadHandler handler) {
        block3: {
            try {
                if (this.isIdleTimeoutNeeded()) {
                    this.idleHandlers.addReadHandler(handler);
                }
                handler.onRegisterForRead();
                this.serverSocketDriver.selectForRead(handler);
            }
            catch (Throwable e) {
                if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block3;
                ServerSocketDriver.logger.log(Level.WARNING, "Exception in persisting a connection", e);
            }
        }
    }

    void endReadHandlerRun(boolean _moreRequest, ServerSocketReadHandler _readHandler) {
        this.endReadHandlerRun(_moreRequest, _readHandler, this.MAX_READ_WAIT);
    }

    void endReadHandlerRun(boolean _moreRequest, ServerSocketReadHandler handler, long _readWait) {
        if (this.shutdownInvoked && _moreRequest) {
            this.noExCloseSocket(handler.getSocket(), "AcceptHandler shut-down in progress, forcing close the socket", Level.WARNING);
            _moreRequest = false;
        }
        if (_moreRequest) {
            this.persistConnection(handler);
        } else {
            boolean reuseHandler = true;
            try {
                handler.unbindSocket();
            }
            catch (Throwable e) {
                reuseHandler = false;
            }
            this.handlerPool.releaseHandler(handler, reuseHandler);
            this.connMgr.decrement();
        }
    }

    public void setThreadPool(ThreadPool _threadPool) {
        this.reqThreadPool = _threadPool;
    }

    public ThreadPool getThreadPool() {
        return this.reqThreadPool;
    }

    public void setConnectionThreadPool(ThreadPool threadPool) {
        this.connectionThreadPool = threadPool;
    }

    public ThreadPool getConnectionThreadPool() {
        return this.connectionThreadPool != null ? this.connectionThreadPool : this.reqThreadPool;
    }

    protected boolean overwriteHandleDelayedAccepted() {
        return false;
    }

    protected void handleDelayedAccepted(OutputStream os) {
    }

    public void setMaxWaitingTimeSeconds(long _second) {
        this.maxDelayedAcceptWaitTime = 1000L * _second;
    }

    protected ServerSocketReadHandler getTimeoutReadHandler() {
        return null;
    }

    public ThreadPool getEmergencyThreadPool() {
        return this.emergencyThreadPool;
    }

    public void setEmergencyThreadPool(ThreadPool _tpool) {
        this.emergencyThreadPool = _tpool;
    }

    public NIOServerSocketDriver getDriver() {
        return this.serverSocketDriver;
    }

    public void shutdown() {
        this.shutdownInvoked = true;
        this.idleHandlers.clear();
        this.impl.shutdown();
        this.noExCloseServerSocket(this.serverSocket, null, Level.WARNING);
        this.handlerPool.unregister(this);
        this.serverSocketChannel = null;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public long getIdleSocketTimeout() {
        return 60000L;
    }

    boolean isIdleTimeoutNeeded() {
        return this.getIdleSocketTimeout() > 0L;
    }

    public void housekeeping() {
        long current = System.currentTimeMillis();
        if (current < this.nextHouseKeeping) {
            return;
        }
        this.nextHouseKeeping = current + this.houseKeepingInterval;
        if (this.idleHandlers.isConnectionIdleTooLong()) {
            this.idleConnectionFound = true;
            this.serverSocketDriver.wakeupSelector();
            this.serverSocketDriver.setAcceptHandlerHousekeepingNow(true);
        }
        this.impl.housekeeping(current);
    }

    protected void procDelayedAccepted() {
        this.idleHandlers.expireOneHandler();
        if (!this.connMgr.maxConnectionsExceed()) {
            this.getThreadPool().launch(new AcceptHandlerHorse(this.lastAccepted.key, this.lastAccepted.channel, this.lastAccepted.socket));
            return;
        }
        this.rejectDelayedAccepted();
    }

    protected void rejectDelayedAccepted() {
        this.impl.rejectDelayedAccepted();
    }

    void enableHouseKeeping() {
        this.nextHouseKeeping = System.currentTimeMillis() + this.houseKeepingInterval;
    }

    void disableHouseKeeping() {
        this.nextHouseKeeping = Long.MAX_VALUE;
    }

    public boolean removeFromIdle(ServerSocketReadHandler handler) {
        return this.idleHandlers.removeHandler(handler);
    }

    private static class AcceptedSocketInfo {
        SelectionKey key;
        SocketChannel channel;
        Socket socket;

        AcceptedSocketInfo(SelectionKey key, SocketChannel channel, Socket socket) {
            this.key = key;
            this.channel = channel;
            this.socket = socket;
        }

        AcceptedSocketInfo(AcceptedSocketInfo info) {
            this.key = info.key;
            this.channel = info.channel;
            this.socket = info.socket;
        }

        public boolean equals(Object other) {
            AcceptedSocketInfo o = (AcceptedSocketInfo)other;
            return o.socket.equals(this.socket);
        }
    }

    private class ConnectionCount {
        private int maxConnection;
        private volatile int connectionCounter;
        Object ConnCounterLock = new Object();

        ConnectionCount(int maxConnection) {
            this.setMaxConnection(maxConnection);
        }

        void decrement() {
            --this.connectionCounter;
            if (ServerSocketAcceptHandler.this.isSuspended() && !this.maxConnectionsExceed()) {
                ServerSocketAcceptHandler.this.resumeAccept();
            }
        }

        protected boolean maxConnectionsExceed() {
            return this.connectionCounter >= this.maxConnection;
        }

        boolean increment() {
            block3: {
                ++this.connectionCounter;
                if (!this.maxConnectionsExceed()) {
                    return true;
                }
                try {
                    ServerSocketAcceptHandler.this.suspendAccept();
                }
                catch (Exception e) {
                    --this.connectionCounter;
                    if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block3;
                    ServerSocketDriver.logger.log(Level.WARNING, "Exception in ServerSocketAcceptHandler:suspendAccept", e);
                }
            }
            return false;
        }

        void setMaxConnection(int maxConnection) {
            this.maxConnection = maxConnection;
        }
    }

    public class AcceptHandlerHorse
    implements Runnable {
        private SelectionKey selectionKey;
        private SocketChannel clientSocketChannel;
        private SSLSocket sslSocket;
        private Socket socket;

        public AcceptHandlerHorse(SelectionKey key, SocketChannel cSocketChannel, Socket socket) {
            this.selectionKey = key;
            this.clientSocketChannel = cSocketChannel;
            this.socket = socket;
        }

        public void run() {
            try {
                if (this.clientSocketChannel != null) {
                    this.sslSocket = ServerSocketAcceptHandler.this.doSSLHandShaking(this.clientSocketChannel.socket());
                }
            }
            catch (IOException e) {
                if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                    ServerSocketDriver.logger.log(Level.WARNING, "IOException in ServerSocketAcceptHandler$AcceptHandlerHorse:run", e);
                }
                ServerSocketAcceptHandler.this.noExCloseSocket(this.socket, "Exception in socket.close", Level.WARNING);
                ServerSocketAcceptHandler.this.connMgr.decrement();
                return;
            }
            ServerSocketAcceptHandler.this.procClientSocket(this.socket, this.sslSocket, false);
        }
    }

    class NBImpl
    implements AcceptImpl {
        private ServerSocketChannel sChannel;
        private long delayedAcceptedDeadline;
        private Mutex delayedAcceptLock = new Mutex();
        private AcceptedSocketInfo suspendedAccepted;

        NBImpl() {
        }

        public void connect() throws IOException {
            this.resumeAccept();
        }

        public void housekeeping(long current) {
            if (this.delayedAcceptedDeadline > current) {
                return;
            }
            ServerSocketAcceptHandler.this.procDelayedAccepted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAccept() {
            try {
                this.delayedAcceptLock.acquire();
                this.delayedAcceptedDeadline = Long.MAX_VALUE;
                ServerSocketAcceptHandler.this.serverSocketDriver.selectForAccept(ServerSocketAcceptHandler.this);
                this.suspendedAccepted.socket = null;
            }
            catch (Exception e) {
                if (ServerSocketDriver.logger.isLoggable(Level.SEVERE)) {
                    ServerSocketDriver.logger.log(Level.SEVERE, "Cannot re-register socket channel for accept", e);
                }
            }
            finally {
                this.delayedAcceptLock.release();
            }
        }

        public void shutdown() {
            try {
                this.suspendAccept();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void suspendAccept() throws IOException {
            this.delayedAcceptedDeadline = System.currentTimeMillis() + ServerSocketAcceptHandler.this.maxDelayedAcceptWaitTime;
            this.suspendedAccepted = new AcceptedSocketInfo(ServerSocketAcceptHandler.this.lastAccepted);
            ServerSocketAcceptHandler.this.serverSocketDriver.suspendAccept(((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).lastAccepted.key);
        }

        public void rejectDelayedAccepted() {
            block3: {
                try {
                    this.delayedAcceptLock.acquire();
                    if (!ServerSocketAcceptHandler.this.lastAccepted.equals(this.suspendedAccepted)) {
                        return;
                    }
                    ServerSocketAcceptHandler.this.rejectDelayedAcceptedNoSync();
                    this.delayedAcceptLock.release();
                }
                catch (InterruptedException e) {
                    if (!ServerSocketDriver.logger.isLoggable(Level.FINE)) break block3;
                    ServerSocketDriver.logger.log(Level.FINE, "Cannot acquire Mutex", e);
                }
            }
        }
    }

    class BImpl
    implements AcceptImpl,
    Runnable {
        private Object shutdownSync = new Object();
        private transient boolean exitRunMethod = true;

        BImpl() {
        }

        public void connect() throws IOException {
            ServerSocketAcceptHandler.this.getServerSocketChannel().configureBlocking(true);
            ServerSocketAcceptHandler.this.getConnectionThreadPool().launch(this);
        }

        public void housekeeping(long current) {
        }

        public void rejectDelayedAccepted() {
            ServerSocketAcceptHandler.this.rejectDelayedAcceptedNoSync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAccept() {
            Object object = ((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).connMgr.ConnCounterLock;
            synchronized (object) {
                try {
                    ((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).connMgr.ConnCounterLock.notify();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            this.exitRunMethod = false;
            try {
                try {
                    ServerSocketAcceptHandler.this.waitForAlive();
                    while (!ServerSocketAcceptHandler.this.shutdownInvoked) {
                        try {
                            Socket clientSocket = ServerSocketAcceptHandler.this.serverSocket.accept();
                            ServerSocketAcceptHandler.this.procAccepted(null, clientSocket.getChannel(), clientSocket);
                        }
                        catch (Throwable e) {
                            if (ServerSocketAcceptHandler.this.shutdownInvoked || !ServerSocketDriver.logger.isLoggable(Level.WARNING)) continue;
                            ServerSocketDriver.logger.log(Level.WARNING, "Exception in processing accepted socket", e);
                        }
                    }
                    Object var3_4 = null;
                    object = this.shutdownSync;
                }
                catch (Throwable e) {
                    if (ServerSocketAcceptHandler.this.shutdownInvoked && ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                        ServerSocketDriver.logger.log(Level.WARNING, "Exception in blocking while loop", e);
                    }
                    Object var3_5 = null;
                    Object object3 = this.shutdownSync;
                    synchronized (object3) {
                        this.exitRunMethod = true;
                        this.shutdownSync.notify();
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                Object object2 = this.shutdownSync;
                synchronized (object2) {
                    this.exitRunMethod = true;
                    this.shutdownSync.notify();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.exitRunMethod = true;
                this.shutdownSync.notify();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            ServerSocketAcceptHandler.this.noExCloseServerSocket(ServerSocketAcceptHandler.this.serverSocket, null, Level.WARNING);
            while (!this.exitRunMethod) {
                try {
                    Object object = this.shutdownSync;
                    synchronized (object) {
                        if (!this.exitRunMethod) {
                            this.shutdownSync.wait(100L);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void suspendAccept() throws IOException {
            Object object = ((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).connMgr.ConnCounterLock;
            synchronized (object) {
                block5: {
                    try {
                        ((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).connMgr.ConnCounterLock.wait(ServerSocketAcceptHandler.this.maxDelayedAcceptWaitTime);
                    }
                    catch (Exception e) {
                        if (!ServerSocketAcceptHandler.this.shutdownInvoked) break block5;
                        ServerSocketAcceptHandler.this.noExCloseSocket(((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).lastAccepted.socket, null, Level.WARNING);
                        ServerSocketAcceptHandler.this.connMgr.decrement();
                        return;
                    }
                }
            }
            ServerSocketAcceptHandler.this.procDelayedAccepted();
        }
    }

    static interface AcceptImpl {
        public void connect() throws IOException;

        public void housekeeping(long var1);

        public void rejectDelayedAccepted();

        public void resumeAccept();

        public void suspendAccept() throws IOException;

        public void shutdown();
    }

    public class IdleHandlers
    extends DoubleLinkedList {
        public void addReadHandler(ServerSocketReadHandler handler) {
            this.addLast(handler.getIdleDLLNode());
        }

        private void closeIdleHandler(ServerSocketReadHandler handler) {
            block3: {
                try {
                    SelectionKey key = handler.getChannel().keyFor(ServerSocketAcceptHandler.this.serverSocketDriver.getSelector());
                    if (key == null) {
                        return;
                    }
                    key.cancel();
                }
                catch (Exception e) {
                    if (ServerSocketAcceptHandler.this.shutdownInvoked || !ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block3;
                    ServerSocketDriver.logger.log(Level.WARNING, "Exception in SelectionKey cancel", e);
                }
            }
            ServerSocketAcceptHandler.this.noExCloseSocket(handler.getSocket(), "close the idle connection", Level.WARNING);
            ServerSocketAcceptHandler.this.endReadHandlerRun(false, handler, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expireHandlers() {
            long current = System.currentTimeMillis();
            IdleHandlers idleHandlers = this;
            synchronized (idleHandlers) {
                ServerSocketReadHandler handler;
                DoubleLinkedListNode node;
                while ((node = this.peek()) != null && (handler = (ServerSocketReadHandler)node.getRealNode()).waitTooLongREAD_OP(current)) {
                    this.closeIdleHandler(handler);
                    this.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expireOneHandler() {
            IdleHandlers idleHandlers = this;
            synchronized (idleHandlers) {
                DoubleLinkedListNode node = this.peek();
                if (node != null) {
                    ServerSocketReadHandler handler = (ServerSocketReadHandler)node.getRealNode();
                    this.closeIdleHandler(handler);
                    this.removeFirst();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConnectionIdleTooLong() {
            long current = System.currentTimeMillis();
            IdleHandlers idleHandlers = this;
            synchronized (idleHandlers) {
                DoubleLinkedListNode node = this.peek();
                if (node != null) {
                    ServerSocketReadHandler handler = (ServerSocketReadHandler)node.getRealNode();
                    return handler.waitTooLongREAD_OP(current);
                }
                return false;
            }
        }

        public boolean removeHandler(ServerSocketReadHandler handler) {
            return this.remove(handler.getIdleDLLNode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = ((ServerSocketAcceptHandler)ServerSocketAcceptHandler.this).connMgr.ConnCounterLock;
            synchronized (object) {
                IdleHandlers idleHandlers = this;
                synchronized (idleHandlers) {
                    DoubleLinkedListNode node;
                    while ((node = this.peek()) != null) {
                        this.closeIdleHandler((ServerSocketReadHandler)node.getRealNode());
                        this.removeFirst();
                    }
                }
            }
        }
    }
}

