/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.network;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.oc4j.network.ServerSocketAcceptHandler;
import oracle.oc4j.network.ServerSocketDriver;
import oracle.oc4j.network.ServerSocketReadHandler;

public class NIOServerSocketDriver
implements Runnable {
    static final int ONE_SECOND = 1000;
    private ArrayList acceptHandlers;
    private volatile boolean alive;
    private Selector selector;
    private transient boolean exitSelectorThread = false;
    private long selectTimeout = Long.getLong("selector.timeout.milli.sec", 60000L);
    private volatile boolean exitRunMethod = true;
    private volatile boolean acceptHandlerHousekeepingNow;
    private Object shutdownSync = new Object();
    private SelectorThreadTask selectorThreadTask;

    public NIOServerSocketDriver() {
        this.reset();
    }

    public void selectForAccept(ServerSocketAcceptHandler _acceptHandler) throws IOException {
        ServerSocketChannel _serverSocketChannel = _acceptHandler.getServerSocketChannel();
        _serverSocketChannel.configureBlocking(false);
        SelectionKey _key = _serverSocketChannel.register(this.selector, 16, _acceptHandler);
    }

    public void addAcceptHandler(ServerSocketAcceptHandler _acceptHandler) {
        this.acceptHandlers.add(_acceptHandler);
    }

    public void selectForRead(ServerSocketReadHandler handler) {
        this.selectorThreadTask.selectForRead(handler);
    }

    public void connect() throws IOException {
        this.selector = Selector.open();
        for (int i = 0; i < this.acceptHandlers.size(); ++i) {
            ((ServerSocketAcceptHandler)this.acceptHandlers.get(i)).connect();
        }
    }

    protected void handleAccept(SelectionKey key) throws IOException {
        ServerSocketChannel server = (ServerSocketChannel)key.channel();
        SocketChannel acceptedSocketChannel = server.accept();
        ServerSocketAcceptHandler handler = (ServerSocketAcceptHandler)key.attachment();
        acceptedSocketChannel.configureBlocking(true);
        handler.procAccepted(key, acceptedSocketChannel, acceptedSocketChannel.socket());
    }

    protected void handleRead(SelectionKey _key) {
        ServerSocketReadHandler handler;
        try {
            handler = (ServerSocketReadHandler)_key.attachment();
            if (handler.acceptHandler.isIdleTimeoutNeeded() && !handler.acceptHandler.removeFromIdle(handler)) {
                return;
            }
            _key.cancel();
            _key.channel().configureBlocking(true);
        }
        catch (IOException e) {
            if (ServerSocketDriver.logger.isLoggable(Level.FINE)) {
                ServerSocketDriver.logger.log(Level.FINE, "Read handler was just removed (correctly)", e);
            }
            return;
        }
        handler.acceptHandler.getThreadPool().launch(handler.getSafeRunnable());
    }

    protected boolean isAlive() {
        return this.alive;
    }

    public void reset() {
        this.acceptHandlers = new ArrayList();
        this.setAlive(true);
        this.selectorThreadTask = new SelectorThreadTask();
    }

    void setAcceptHandlerHousekeepingNow(boolean b) {
        this.acceptHandlerHousekeepingNow = b;
    }

    protected void selfHouseKeeping() {
        this.selectorThreadTask.procDelayedRegisters();
        if (this.acceptHandlerHousekeepingNow) {
            for (int i = 0; i < this.acceptHandlers.size(); ++i) {
                ((ServerSocketAcceptHandler)this.acceptHandlers.get(i)).selectorThreadHouseKeeping();
            }
            this.setAcceptHandlerHousekeepingNow(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        this.exitRunMethod = false;
        try {
            this.waitForAlive();
            while (this.isAlive()) {
                try {
                    this.selfHouseKeeping();
                    this.select();
                }
                catch (IOException e) {
                    if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) continue;
                    ServerSocketDriver.logger.log(Level.WARNING, "IOException in NIOServerSocketDriver:run", e);
                }
                catch (Throwable e) {
                    if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) continue;
                    ServerSocketDriver.logger.log(Level.WARNING, "NON-IOException Throwable in NIOServerSocketDriver:run", e);
                }
            }
            this.shutdownDriver();
            Object var3_4 = null;
            object = this.shutdownSync;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Object object2 = this.shutdownSync;
            synchronized (object2) {
                this.exitRunMethod = true;
                this.shutdownSync.notify();
            }
            throw throwable;
        }
        synchronized (object) {
            this.exitRunMethod = true;
            this.shutdownSync.notify();
        }
    }

    private void shutdownDriver() {
        for (int i = 0; i < this.acceptHandlers.size(); ++i) {
            ((ServerSocketAcceptHandler)this.acceptHandlers.get(i)).shutdown();
        }
        try {
            this.getSelector().selectNow();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            this.getSelector().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void select() throws IOException {
        try {
            this.selector.select(this.selectTimeout);
        }
        catch (ClosedSelectorException e) {
            if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                ServerSocketDriver.logger.log(Level.WARNING, "ClosedSelectorException in NIOServerSocketDriver:select", e);
            }
            return;
        }
        catch (IOException e) {
            if (!e.getMessage().equals("Interrupted system call") && ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                ServerSocketDriver.logger.log(Level.WARNING, "IOException in NIOServerSocketDriver:select", e);
            }
            return;
        }
        catch (NullPointerException e) {
            if (ServerSocketDriver.logger.isLoggable(Level.FINEST)) {
                ServerSocketDriver.logger.log(Level.FINEST, "NullPointerException in NIOServerSocketDriver:select", e);
            }
            return;
        }
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            if (key.isAcceptable()) {
                this.handleAccept(key);
                continue;
            }
            if (key.isReadable()) {
                this.handleRead(key);
                continue;
            }
            if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) continue;
            ServerSocketDriver.logger.log(Level.WARNING, "Unhandled key state: " + key);
        }
    }

    void wakeupSelector() {
        try {
            this.getSelector().wakeup();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutSelfDown() {
        try {
            this.getSelector().wakeup();
        }
        catch (Throwable e) {
            // empty catch block
        }
        while (!this.exitRunMethod) {
            try {
                Object e = this.shutdownSync;
                synchronized (e) {
                    if (!this.exitRunMethod) {
                        this.shutdownSync.wait(100L);
                    }
                }
            }
            catch (Exception e) {
            }
        }
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        if (!alive) {
            this.shutSelfDown();
        }
    }

    public void setSelectTimeout(long _selectTimeout) {
        this.selectTimeout = _selectTimeout;
    }

    public void suspendAccept(SelectionKey key) {
        key.cancel();
    }

    protected boolean waitForAlive() {
        boolean _atLeastOneAlive = false;
        for (int i = 0; i < this.acceptHandlers.size(); ++i) {
            ServerSocketAcceptHandler handler = (ServerSocketAcceptHandler)this.acceptHandlers.get(i);
            if (!handler.waitForAlive()) continue;
            _atLeastOneAlive = true;
            handler.enableHouseKeeping();
        }
        return _atLeastOneAlive;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public class SelectorThreadTask {
        private ArrayList[] delayedRegisters;
        private int addedTo = 0;
        private Object listLock = new Object();

        public SelectorThreadTask() {
            this.delayedRegisters = new ArrayList[2];
            this.delayedRegisters[0] = new ArrayList(100);
            this.delayedRegisters[1] = new ArrayList(100);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectForRead(ServerSocketReadHandler handler) {
            block6: {
                try {
                    boolean firstInTheList;
                    handler.getChannel().configureBlocking(false);
                    Object object = this.listLock;
                    synchronized (object) {
                        firstInTheList = this.delayedRegisters[this.addedTo].size() == 0;
                        this.delayedRegisters[this.addedTo].add(handler);
                    }
                    if (firstInTheList) {
                        NIOServerSocketDriver.this.selector.wakeup();
                    }
                }
                catch (Exception e) {
                    if (!ServerSocketDriver.logger.isLoggable(Level.WARNING)) break block6;
                    ServerSocketDriver.logger.log(Level.WARNING, "Exception in NIOServerSocketDriver:selectForRead", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void procDelayedRegisters() {
            ArrayList list;
            if (this.delayedRegisters[this.addedTo].size() == 0) {
                return;
            }
            try {
                NIOServerSocketDriver.this.getSelector().selectNow();
            }
            catch (Exception e) {
                // empty catch block
            }
            Object object = this.listLock;
            synchronized (object) {
                list = this.delayedRegisters[this.addedTo];
                this.addedTo = 1 - this.addedTo;
            }
            int size = list.size();
            for (int x = 0; x < size; ++x) {
                ServerSocketReadHandler handler = (ServerSocketReadHandler)list.get(x);
                try {
                    handler.getChannel().register(NIOServerSocketDriver.this.selector, 1, handler);
                    continue;
                }
                catch (CancelledKeyException e) {
                    if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                        ServerSocketDriver.logger.log(Level.WARNING, "CancelledKeyException in NIOServerSocketDriver:procDelayedRegisters", e);
                    }
                    Object object2 = this.listLock;
                    synchronized (object2) {
                        this.delayedRegisters[this.addedTo].add(handler);
                        continue;
                    }
                }
                catch (IOException e) {
                    if (ServerSocketDriver.logger.isLoggable(Level.WARNING)) {
                        ServerSocketDriver.logger.log(Level.WARNING, "IOException in NIOServerSocketDriver:procDelayedRegisters", e);
                    }
                    handler.removeImmediate();
                }
            }
            list.clear();
        }
    }
}

