/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.naming.url.opmn;

import com.evermind.naming.memory.FlatMapContext;
import com.evermind.server.cluster.ServerIdentification;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;
import oracle.oc4j.naming.url.URLHandler;
import oracle.oc4j.naming.url.opmn.opmnURLContext;
import oracle.oc4j.naming.url.opmn.opmncorbaURLHandler;

public class opmncorbaURLContext
extends opmnURLContext {
    static final String OPMN_IIOP_LOOKUP_URL = "opmn:corbaname::";
    private static final String CORBANAME_URL_PREFIX = "corbaname::";

    opmncorbaURLContext(Hashtable environment, opmnURLContext.OpmnProxy proxy) {
        super(environment, proxy);
    }

    protected ResolveResult getRootURLContext(String url, Hashtable env) throws NamingException {
        try {
            opmncorbaURLHandler urlHandler = new opmncorbaURLHandler(url);
            ServerIdentification[] servers = this.getServersFromOpmn(urlHandler.getHost(), urlHandler.getPort(), urlHandler.getInstanceName(), urlHandler.getLookupString());
            if (servers.length == 0) {
                throw new NamingException("Could not obtain list of servers from OPMN");
            }
            if (servers.length == 1) {
                return new ResolveResult((Object)new InitialContext(), new CompositeName().add(this.getLookupURL(servers[0], urlHandler.getLookupString())));
            }
            return new ResolveResult((Object)this.createMultipleURLResolvingContext(servers, urlHandler, env, url), new CompositeName().add(url));
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    private Context createMultipleURLResolvingContext(final ServerIdentification[] servers, final URLHandler urlHandler, final Hashtable env, final String url) throws Exception {
        return new FlatMapContext(){

            public Object lookup(Name name) throws NamingException {
                try {
                    if (name.get(0).equals(url)) {
                        Object result = opmncorbaURLContext.this.getURLContextFactory("corbaname").getObjectInstance(opmncorbaURLContext.this.getLookupURLsForMultipleServers(servers, urlHandler.getLookupString()), null, null, env);
                        return result;
                    }
                }
                catch (Exception e) {
                    throw new NamingException(e.toString());
                }
                return null;
            }
        };
    }

    private String[] getLookupURLsForMultipleServers(ServerIdentification[] servers, String application) {
        String[] urls = new String[servers.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.getLookupURL(servers[i], application);
        }
        return urls;
    }

    private String getLookupURL(ServerIdentification server, String application) {
        StringBuffer buf = new StringBuffer(CORBANAME_URL_PREFIX);
        buf.append(server.getAddress());
        buf.append(':');
        buf.append(server.getPort());
        if (application != null) {
            buf.append('#');
            buf.append(application);
        }
        return buf.toString();
    }
}

