/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.extensions;

import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.logging.Logger;
import oracle.classloader.ClassLoaderQuery;
import oracle.hooks.Extension;
import oracle.hooks.Hook;
import oracle.hooks.InterruptProtocol;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.hooks.ApplicationProtocol;
import oracle.oc4j.hooks.ServerProtocol;
import oracle.oc4j.util.FileLockUtil;

public class UseDeploymentLockFile
implements Extension {
    private static FileLockUtil s_fileLockUtil = null;
    private static FileChannel s_lockFile = null;
    private static FileLock s_lock = null;
    private static Logger s_logger = TraceLogger.getLogger(UseDeploymentLockFile.class);
    protected static String s_lockFileName = null;
    private static boolean s_hookInstalled = false;
    private static final String NUMPROCS_PROPERTY_STRING = "oracle.ons.numprocs";

    public void activate(String[] args) {
        try {
            if (s_lockFileName == null) {
                String instanceDirectory = OC4JRuntimeProperties.getOracleJ2eeHome();
                if (instanceDirectory == null || instanceDirectory.equals("")) {
                    instanceDirectory = ClassLoaderQuery.getHomeDirectory().getCanonicalPath();
                }
                s_lockFileName = instanceDirectory + File.separatorChar + "DEPLOYMENT_LOCK";
            }
            FileChannel s_lockFile = new RandomAccessFile(s_lockFileName, "rw").getChannel();
            s_fileLockUtil = new FileLockUtil(s_lockFile, s_logger, -1);
        }
        catch (Throwable e) {
            throw (RuntimeException)new RuntimeException("Unable to open deployment lockfile: " + s_lockFileName).initCause(e);
        }
        ServerProtocol.PRE_SET_CONFIG.addHook("GetLock", new GetLockReadSetConfig());
        ServerProtocol.POST_SET_CONFIG.addHook("ReleaseLock", new ReleaseLockReadConfig());
        ServerProtocol.PRE_CHECK_FOR_UPDATES.addHook("GetLock", new GetLockReadCheckForUpdate());
        ServerProtocol.POST_CHECK_FOR_UPDATES.addHook("ReleaseLock", new ReleaseLockReadCheckForUpdates());
        ApplicationProtocol.PRE_DEPLOY_APPLICATION.addHook("GetLock", new GetLockDeployApplication());
        ApplicationProtocol.POST_DEPLOY_APPLICATION.addHook("ReleaseLock", new ReleaseLockDeployApplication());
        ApplicationProtocol.PRE_UNDEPLOY_APPLICATION.addHook("GetLock", new GetLockEditUndeployApplication());
        ApplicationProtocol.POST_UNDEPLOY_APPLICATION.addHook("ReleaseLock", new ReleaseLockUndeployApplication());
        ApplicationProtocol.PRE_UPDATE_EJB_MODULE.addHook("GetLock", new GetLockEditEJBModule());
        ApplicationProtocol.POST_UPDATE_EJB_MODULE.addHook("ReleaseLock", new ReleaseLockUpdateEJBMOdule());
    }

    public Class[] getDependentProtocols() {
        return new Class[]{ApplicationProtocol.class, ServerProtocol.class};
    }

    protected static void getDeploymentLock() {
        try {
            s_fileLockUtil.acquire();
        }
        catch (IOException e) {
            s_logger.warning("fileLockUtil.acquire() throws exception " + e);
        }
        if (!s_fileLockUtil.isLocked()) {
            s_logger.warning("Failed to acquire a lock.It may fail to share applications with multiple oc4j instances.");
        }
    }

    protected static void releaseDeploymentLock() {
        if (s_fileLockUtil.isLocked()) {
            try {
                s_fileLockUtil.release();
            }
            catch (IOException e) {
                s_logger.finer("fileLockUtil.release() throws exception " + e);
            }
        }
    }

    protected static boolean isLocked() {
        return s_fileLockUtil.isLocked();
    }

    public static void installIfNeeded() {
        try {
            String num = System.getProperty(NUMPROCS_PROPERTY_STRING);
            if (num != null && Integer.parseInt(num) > 1 && !s_hookInstalled) {
                s_logger.finer("Installing File lock hooks");
                InterruptProtocol.loadDynamicExtension(UseDeploymentLockFile.class.getName(), null);
                s_hookInstalled = true;
            } else {
                s_logger.finer("File lock hooks not installed");
            }
        }
        catch (Throwable t) {
            s_logger.finer("File lock hooks not installed: " + t.getLocalizedMessage());
        }
    }

    protected static class ReleaseLockUpdateEJBMOdule
    implements Hook.Edit2 {
        protected ReleaseLockUpdateEJBMOdule() {
        }

        public Object execute(Object o1, Object o2) {
            UseDeploymentLockFile.releaseDeploymentLock();
            return null;
        }
    }

    protected static class ReleaseLockDeployApplication
    implements Hook.Edit2 {
        protected ReleaseLockDeployApplication() {
        }

        public Object execute(Object o1, Object o2) {
            UseDeploymentLockFile.releaseDeploymentLock();
            return null;
        }
    }

    protected static class ReleaseLockUndeployApplication
    implements Hook.Edit1 {
        protected ReleaseLockUndeployApplication() {
        }

        public Object execute(Object o2) {
            UseDeploymentLockFile.releaseDeploymentLock();
            return null;
        }
    }

    protected static class ReleaseLockReadCheckForUpdates
    implements Hook.Read2 {
        protected ReleaseLockReadCheckForUpdates() {
        }

        public void execute(Object o1, Object o2) {
            UseDeploymentLockFile.releaseDeploymentLock();
        }
    }

    protected static class ReleaseLockReadConfig
    implements Hook.Read2 {
        protected ReleaseLockReadConfig() {
        }

        public void execute(Object o1, Object o2) {
            UseDeploymentLockFile.releaseDeploymentLock();
        }
    }

    protected static class GetLockEditEJBModule
    implements Hook.Edit3 {
        protected GetLockEditEJBModule() {
        }

        public Object execute(Object o1, Object o2, Object o3) {
            UseDeploymentLockFile.getDeploymentLock();
            return null;
        }
    }

    protected static class GetLockDeployApplication
    implements Hook.Edit2 {
        protected GetLockDeployApplication() {
        }

        public Object execute(Object o1, Object o2) {
            UseDeploymentLockFile.getDeploymentLock();
            return null;
        }
    }

    protected static class GetLockEditUndeployApplication
    implements Hook.Edit1 {
        protected GetLockEditUndeployApplication() {
        }

        public Object execute(Object o2) {
            UseDeploymentLockFile.getDeploymentLock();
            return null;
        }
    }

    protected static class GetLockReadCheckForUpdate
    implements Hook.Read1 {
        protected GetLockReadCheckForUpdate() {
        }

        public void execute(Object o1) {
            UseDeploymentLockFile.getDeploymentLock();
        }
    }

    protected static class GetLockReadSetConfig
    implements Hook.Read2 {
        protected GetLockReadSetConfig() {
        }

        public void execute(Object o1, Object o2) {
            UseDeploymentLockFile.getDeploymentLock();
        }
    }
}

