/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.ejb.deployment;

import java.io.PrintWriter;
import oracle.oc4j.util.DocumentSemantics;
import org.w3c.dom.Node;

public class IorConfig {
    private TransportConfig m_transportConfig;
    private AsContext m_asContext;
    private SasContext m_sasContext;

    public static Object parse(Node node) {
        IorConfig config = new IorConfig();
        DocumentSemantics.build(node, (Object)config, "ior-security-config");
        return config;
    }

    public void recordConfiguration(Configurable configurable) {
        if (this.m_transportConfig != null) {
            this.m_transportConfig.recordConfiguration(configurable);
        }
        if (this.m_asContext != null) {
            this.m_asContext.recordConfiguration(configurable);
        }
        if (this.m_sasContext != null) {
            this.m_sasContext.recordConfiguration(configurable);
        }
    }

    public void writeXml(PrintWriter pw, String indent) {
        pw.println(indent + "<ior-security-config>");
        if (this.m_transportConfig != null) {
            this.m_transportConfig.writeXml(pw, indent + '\t');
        }
        if (this.m_asContext != null) {
            this.m_asContext.writeXml(pw, indent + '\t');
        }
        if (this.m_sasContext != null) {
            this.m_sasContext.writeXml(pw, indent + '\t');
        }
        pw.println(indent + "</ior-security-config>");
    }

    public TransportConfig createTransportConfig() {
        this.m_transportConfig = new TransportConfig();
        return this.m_transportConfig;
    }

    public AsContext createAsContext() {
        this.m_asContext = new AsContext();
        return this.m_asContext;
    }

    public SasContext createSasContext() {
        this.m_sasContext = new SasContext();
        return this.m_sasContext;
    }

    private static void assertNoneSupportedOrRequired(String name, String value) {
        if (!(value.equals("none") || value.equals("supported") || value.equals("required"))) {
            throw new RuntimeException(name + " incorrectly specified as '" + value + "'. It must be one of { none, supported, required }");
        }
    }

    private static void printField(PrintWriter pw, String indent, String name, String value, String defaultValue) {
        if (value.equals(defaultValue)) {
            return;
        }
        pw.println('\t' + indent + '<' + name + '>' + value + "</" + name + '>');
    }

    public class SasContext {
        private final String DEFAULT_CALLER_PROPAGATION = "supported";
        private String m_callerPropagation = "supported";

        public void setCallerPropagation(String callerPropagation) {
            IorConfig.assertNoneSupportedOrRequired("caller-propagation", callerPropagation);
            this.m_callerPropagation = callerPropagation;
        }

        public void recordConfiguration(Configurable configurable) {
            configurable.defineSasContext(this.m_callerPropagation);
        }

        public void writeXml(PrintWriter pw, String indent) {
            pw.println(indent + "<sas-context>");
            IorConfig.printField(pw, indent, "caller-propagation", this.m_callerPropagation, "supported");
            pw.println(indent + "</sas-context>");
        }
    }

    public class AsContext {
        private final String DEFAULT_AUTH_METHOD = "username_password";
        private final String DEFAULT_REALM = "default";
        private final boolean DEFAULT_REQUIRED = false;
        private String m_authMethod = "username_password";
        private String m_realm = "default";
        private boolean m_required = false;

        public void setAuthMethod(String authMethod) {
            if (!authMethod.equals("none") && !authMethod.equals("username_password")) {
                throw new RuntimeException("auth-method must be one of { none, username_password }");
            }
            this.m_authMethod = authMethod;
        }

        public void setRealm(String realm) {
            this.m_realm = realm;
        }

        public void setRequired(boolean required) {
            this.m_required = required;
        }

        void recordConfiguration(Configurable configurable) {
            configurable.defineAsContext(this.m_authMethod, this.m_realm, this.m_required);
        }

        public void writeXml(PrintWriter pw, String indent) {
            pw.println(indent + "<as-context>");
            IorConfig.printField(pw, indent, "auth-method", this.m_authMethod, "username_password");
            IorConfig.printField(pw, indent, "realm", this.m_realm, "default");
            IorConfig.printField(pw, indent, "required", Boolean.toString(this.m_required), Boolean.toString(false));
            pw.println(indent + "</as-context>");
        }
    }

    public class TransportConfig {
        private final String DEFAULT_INTEGRITY = "supported";
        private final String DEFAULT_CONFIDENTIALITY = "supported";
        private final String DEFAULT_TRUST_IN_TARGET = "supported";
        private final String DEFAULT_TRUST_IN_CLIENT = "supported";
        private String m_integrity = "supported";
        private String m_confidentiality = "supported";
        private String m_establishTrustInTarget = "supported";
        private String m_establishTrustInClient = "supported";

        public void setIntegrity(String integrity) {
            IorConfig.assertNoneSupportedOrRequired("integrity", integrity);
            this.m_integrity = integrity;
        }

        public void setConfidentiality(String confidentiality) {
            IorConfig.assertNoneSupportedOrRequired("confidentiality", confidentiality);
            this.m_confidentiality = confidentiality;
        }

        public void setEstablishTrustInTarget(String establishTrustInTarget) {
            IorConfig.assertNoneSupportedOrRequired("establish-trust-in-target", establishTrustInTarget);
            this.m_establishTrustInTarget = establishTrustInTarget;
        }

        public void setEstablishTrustInClient(String establishTrustInClient) {
            IorConfig.assertNoneSupportedOrRequired("establish-trust-in-client", establishTrustInClient);
            this.m_establishTrustInClient = establishTrustInClient;
        }

        void recordConfiguration(Configurable configurable) {
            configurable.defineTransportConfig(this.m_integrity, this.m_confidentiality, this.m_establishTrustInTarget, this.m_establishTrustInClient);
        }

        public void writeXml(PrintWriter pw, String indent) {
            pw.println(indent + "<transport-config>");
            IorConfig.printField(pw, indent, "integrity", this.m_integrity, "supported");
            IorConfig.printField(pw, indent, "confidentiality", this.m_confidentiality, "supported");
            IorConfig.printField(pw, indent, "establish-trust-in-client", this.m_establishTrustInClient, "supported");
            IorConfig.printField(pw, indent, "establish-trust-in-target", this.m_establishTrustInTarget, "supported");
            pw.println(indent + "</transport-config>");
        }
    }

    public static interface Configurable {
        public void defineTransportConfig(String var1, String var2, String var3, String var4);

        public void defineAsContext(String var1, String var2, boolean var3);

        public void defineSasContext(String var1);
    }
}

