/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.deployment;

import com.evermind.server.administration.ResourceFinder;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.ejb.BeanBinding;
import com.evermind.server.ejb.deployment.EJBReference;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.rmi.PortableRemoteObject;
import oracle.oc4j.rmi.OracleRemoteException;

public class ApplicationClientResourceFinder
implements ResourceFinder {
    private Context context;
    private ResourceFinder finder;

    public ApplicationClientResourceFinder(Context context) {
        this.context = context;
    }

    public Object getEjbBinding(EJBReference reference) throws InstantiationException, RemoteException {
        String location = reference.getLocation();
        if (location == null) {
            location = this.getLocation(reference);
        }
        Reference ref = null;
        if (reference.getHome() == null) {
            ref = BeanBinding.createBinding(location, reference);
        } else if (reference.isCreatedByAnnotation()) {
            try {
                Class<?> refClass = Thread.currentThread().getContextClassLoader().loadClass(reference.getHome());
                if (EJBHome.class.isAssignableFrom(refClass)) {
                    ref = BeanBinding.createHomeBinding(EJBHome.class, location, reference);
                }
                ref = BeanBinding.createBinding(location, reference);
            }
            catch (ClassNotFoundException e) {
                throw (InstantiationException)new InstantiationException("Unable to load ejb reference class: " + reference).initCause(e);
            }
        } else {
            ref = BeanBinding.createHomeBinding(EJBHome.class, location, reference);
        }
        return ref;
    }

    public Object getJCAConnectionResource(Context root, String location, ResourceReference reference) throws InstantiationException {
        return null;
    }

    public String getLocation(EJBReference reference) throws InstantiationException, RemoteException {
        return this.getFinder().getLocation(reference);
    }

    public String getLocation(String name, String type) throws RemoteException, InstantiationException {
        return this.getFinder().getLocation(name, type);
    }

    public Set getLocations(String type) throws RemoteException, InstantiationException {
        return this.getFinder().getLocations(type);
    }

    public Map getLocations(Map bindings) throws RemoteException, InstantiationException {
        return this.getFinder().getLocations(bindings);
    }

    public EJBHome getEJBHome(String name, String home, String remote, String type, String link, boolean local) throws RemoteException, InstantiationException {
        return this.getFinder().getEJBHome(name, home, remote, type, link, local);
    }

    private ResourceFinder lookupResourceFinder() throws RemoteException {
        try {
            return this.narrowToResourceFinder(this.context.lookup("oc4j:internal/ResourceFinder"));
        }
        catch (NamingException e) {
            try {
                return this.narrowToResourceFinder(this.context.lookup("java:comp/ResourceFinder"));
            }
            catch (NamingException namingException) {
                throw new OracleRemoteException(e.getMessage(), e);
            }
        }
    }

    protected ResourceFinder narrowToResourceFinder(Object obj) {
        return (ResourceFinder)PortableRemoteObject.narrow((Object)obj, (Class)ResourceFinder.class);
    }

    private ResourceFinder getFinder() throws RemoteException {
        if (this.finder == null) {
            this.finder = this.lookupResourceFinder();
        }
        return this.finder;
    }
}

