/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.transport;

import com.evermind.io.ClassLoaderObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.oc4j.corba.transport.CannotExtractObjectIDException;

public class OC4JObjectID
implements Serializable {
    private static final byte[] START_TOKEN = "OC4J<".getBytes();
    private static final byte[] END_TOKEN = ">OC4J".getBytes();
    private String m_applicationName;

    public OC4JObjectID(String application) {
        this.m_applicationName = application;
    }

    public static boolean hasOC4JObjectID(byte[] key) {
        int startOffset = OC4JObjectID.indexOf(key, START_TOKEN, 0);
        if (startOffset < 0) {
            return false;
        }
        int endOffset = OC4JObjectID.indexOf(key, END_TOKEN, startOffset + START_TOKEN.length);
        return endOffset > 0;
    }

    public static OC4JObjectID extract(byte[] key) throws IOException, ClassNotFoundException {
        return OC4JObjectID.extract(key, null);
    }

    public static OC4JObjectID extract(byte[] key, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (key == null) {
            throw new IOException("ObjectKey is null");
        }
        int startOffset = OC4JObjectID.indexOf(key, START_TOKEN, 0);
        if (startOffset < 0) {
            throw new CannotExtractObjectIDException();
        }
        int endOffset = OC4JObjectID.indexOf(key, END_TOKEN, startOffset + START_TOKEN.length);
        if (endOffset < 0) {
            throw new CannotExtractObjectIDException();
        }
        byte[] rawObjectID = new byte[endOffset - startOffset - START_TOKEN.length];
        System.arraycopy(key, startOffset + START_TOKEN.length, rawObjectID, 0, rawObjectID.length);
        ObjectInputStream ois = loader != null ? new ClassLoaderObjectInputStream(new ByteArrayInputStream(rawObjectID), loader) : new ObjectInputStream(new ByteArrayInputStream(rawObjectID));
        return (OC4JObjectID)ois.readObject();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(START_TOKEN);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        oos.flush();
        baos.write(END_TOKEN);
        return baos.toByteArray();
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    private static int indexOf(byte[] sequence, byte[] subsequence, int offset) {
        block0: for (int i = offset; i <= sequence.length - subsequence.length; ++i) {
            for (int j = 0; j < subsequence.length; ++j) {
                if (sequence[i + j] != subsequence[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

