/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.orb;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.io.IIOPInputStream;
import com.sun.corba.ee.impl.ior.iiop.IIOPProfileTemplateImpl;
import com.sun.corba.ee.impl.legacy.connection.EndPointInfoImpl;
import com.sun.corba.ee.internal.Interceptors.PIORB;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechList;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMechListHelper;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANS;
import com.sun.corba.ee.org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfile;
import com.sun.corba.ee.spi.legacy.connection.Connection;
import com.sun.corba.ee.spi.legacy.interceptor.RequestInfoExt;
import java.io.ObjectInputStream;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.corba.iiop.ClientIIOPSSLSocketFactory;
import oracle.oc4j.corba.iiop.IIOPClientInitializer;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.PortableInterceptor.ClientRequestInfo;

public class OrbManager {
    private static Logger traceLogger = TraceLogger.getLogger(OrbManager.class);
    private static OrbManager s_OrbManager;
    private static final String ORB_MANAGER = "com.oracle.CORBA.OrbManager";
    private ORB m_orb;

    public static ORB getClientOrb() {
        if (s_OrbManager == null) {
            OrbManager.createManager();
        }
        return s_OrbManager.getORBReference();
    }

    private static void createManager() {
        String orbManagerImpl = System.getProperty(ORB_MANAGER);
        traceLogger.finest("System property com.oracle.CORBA.OrbManager is set to " + orbManagerImpl);
        if (orbManagerImpl != null) {
            try {
                Class.forName(orbManagerImpl);
                traceLogger.finest("Successfully loaded via Class.forName" + orbManagerImpl);
                if (s_OrbManager == null) {
                    s_OrbManager = new OrbManager();
                    traceLogger.finest("Successfully created a new OrbManager()");
                }
            }
            catch (Exception e) {
                traceLogger.log(Level.INFO, "Exception creating orb manager: ", e);
                traceLogger.info("Could not initialize configured OrbManager.   Defaulting to " + OrbManager.class.getName());
            }
        } else {
            s_OrbManager = new OrbManager();
            traceLogger.finest("Successfully created a new OrbManager()");
        }
    }

    public static void setManager(OrbManager manager) {
        s_OrbManager = manager;
    }

    protected ORB getORBReference() {
        if (this.m_orb == null) {
            this.m_orb = ORB.init((String[])new String[0], (Properties)OrbManager.getClientProperties());
        }
        return this.m_orb;
    }

    public static Properties getClientProperties() {
        Properties systemProperties = System.getProperties();
        if (s_OrbManager == null) {
            OrbManager.createManager();
        }
        s_OrbManager.setSocketFactoryProperty(systemProperties);
        s_OrbManager.setORBClassProperty(systemProperties);
        s_OrbManager.setORBSingletonClassProperty(systemProperties);
        OrbManager.setORBProperty("org.omg.PortableInterceptor.ORBInitializerClass." + IIOPClientInitializer.class.getName(), IIOPClientInitializer.class.getName(), systemProperties);
        OrbManager.setORBProperty("javax.rmi.CORBA.StubClass", "com.sun.corba.ee.impl.javax.rmi.CORBA.StubDelegateImpl", systemProperties);
        OrbManager.setORBProperty("javax.rmi.CORBA.UtilClass", "com.sun.corba.ee.impl.javax.rmi.CORBA.Util", systemProperties);
        return systemProperties;
    }

    private static void setORBProperty(String key, String value, Properties props) {
        if (!props.containsKey(key)) {
            props.setProperty(key, value);
        }
    }

    protected void setORBClassProperty(Properties props) {
        props.setProperty("org.omg.CORBA.ORBClass", PIORB.class.getName());
    }

    protected void setORBSingletonClassProperty(Properties props) {
    }

    protected void setSocketFactoryProperty(Properties props) {
        props.setProperty("com.sun.CORBA.connection.ORBSocketFactoryClass", ClientIIOPSSLSocketFactory.class.getName());
    }

    public static Socket getRequestSocket(ClientRequestInfo cri) {
        return s_OrbManager.getSocket(cri);
    }

    protected Socket getSocket(ClientRequestInfo cri) {
        Connection c = ((RequestInfoExt)cri).connection();
        if (c != null) {
            return c.getSocket();
        }
        return null;
    }

    public static org.omg.IOP.TaggedComponent getTaggedComponent(Object o) {
        return s_OrbManager.getComponent(o);
    }

    protected org.omg.IOP.TaggedComponent getComponent(Object o) {
        TaggedComponent tcomp = (TaggedComponent)o;
        org.omg.IOP.TaggedComponent comp = tcomp.getIOPComponent(this.getORBReference());
        return comp;
    }

    public static Iterator getCsiSecMechList(Object ior) {
        return s_OrbManager.getMechList(ior);
    }

    protected Iterator getMechList(Object ior) {
        IIOPProfile prof = ((IOR)ior).getProfile();
        IIOPProfileTemplateImpl ptemp = (IIOPProfileTemplateImpl)prof.getTaggedProfileTemplate();
        Iterator itr = ptemp.iteratorById(33);
        return itr;
    }

    public static CompoundSecMech[] getCompoundSecMechList(byte[] b) {
        return s_OrbManager.getCompoundSecList(b);
    }

    protected CompoundSecMech[] getCompoundSecList(byte[] b) {
        EncapsInputStream in = new EncapsInputStream(this.getORBReference(), b, b.length);
        in.consumeEndian();
        CompoundSecMechList l = CompoundSecMechListHelper.read((InputStream)in);
        CompoundSecMech[] list = l.mechanism_list;
        return list;
    }

    public static TLS_SEC_TRANS getTlsSecTransComponent(byte[] b) {
        return s_OrbManager.getTlsSecTrans(b);
    }

    protected TLS_SEC_TRANS getTlsSecTrans(byte[] b) {
        EncapsInputStream in = new EncapsInputStream(this.getORBReference(), b, b.length);
        in.consumeEndian();
        TLS_SEC_TRANS ssl = TLS_SEC_TRANSHelper.read((InputStream)in);
        return ssl;
    }

    public static void setSSLManagers(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        s_OrbManager.setManagers(keyManagers, trustManagers);
    }

    protected void setManagers(KeyManager[] k, TrustManager[] t) {
        ClientIIOPSSLSocketFactory.setManagers(k, t);
    }

    public static Object createEndPointInfo(String type, int port, String hostname) {
        return s_OrbManager.createEndPointInfoImpl(type, port, hostname);
    }

    protected Object createEndPointInfoImpl(String type, int port, String hostname) {
        return new EndPointInfoImpl(type, port, hostname);
    }

    public static ClientSecurityMechanismSelector getSecurityMechanismSelector() {
        return s_OrbManager.getSecMechSelector();
    }

    protected ClientSecurityMechanismSelector getSecMechSelector() {
        traceLogger.entering(this.getClass().getName(), "getSecMechSelector()");
        return new ClientSecurityMechanismSelector();
    }

    public static void setClientCredentials(String userName, String passWord) {
        ClientSecurityMechanismSelector.setUserPassTuple(new PasswordAuthentication(userName, passWord.toCharArray()));
    }

    public static boolean objectReadAreAlreadyConnected(ObjectInputStream istream) {
        return istream instanceof IIOPInputStream;
    }
}

