/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.server;

import com.sun.corba.ee.spi.legacy.interceptor.ORBInitInfoExt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.oc4j.corba.iiop.ClientConnectionInterceptor;
import oracle.oc4j.corba.iiop.jts.pi.InterceptorImpl;
import oracle.oc4j.corba.iiop.security.Csiv2Manager;
import oracle.oc4j.corba.iiop.security.SecClientRequestInterceptor;
import oracle.oc4j.corba.iiop.security.SecServerRequestInterceptor;
import oracle.oc4j.corba.iiop.security.SecurityServiceImpl;
import oracle.oc4j.corba.iiop.server.ServerConnectionInterceptor;
import oracle.oc4j.corba.iiop.server.TxSecIORInterceptor;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class IIOPInitializer
extends LocalObject
implements ORBInitializer {
    private Logger m_logger = Logger.getLogger("oc4j.orb.logger");

    public IIOPInitializer() {
        System.setProperty("com.sun.jts.pi.CLIENT_POLICY_CHECKING", String.valueOf(false));
        System.setProperty("com.sun.jts.pi.INTEROP_MODE", String.valueOf(false));
    }

    public void pre_init(ORBInitInfo info) {
    }

    public void post_init(ORBInitInfo info) {
        Codec codec = null;
        codec = this.getCodec(info);
        try {
            this.registerCSIv2Interceptors(info, codec);
            this.registerTxInterceptors(info, codec);
            TxSecIORInterceptor iorInterceptor = new TxSecIORInterceptor(codec);
            info.add_ior_interceptor((IORInterceptor)iorInterceptor);
        }
        catch (Exception e) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "Exception registering JTS interceptors", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private void registerTxInterceptors(ORBInitInfo info, Codec codec) throws InvalidName, DuplicateName {
        Current pic = (Current)info.resolve_initial_references("PICurrent");
        int[] slotIds = new int[]{info.allocate_slot_id(), info.allocate_slot_id()};
        InterceptorImpl interceptor = new InterceptorImpl(pic, codec, slotIds);
        info.add_client_request_interceptor((ClientRequestInterceptor)interceptor);
        info.add_server_request_interceptor((ServerRequestInterceptor)interceptor);
        InterceptorImpl.setOrb((ORB)((ORBInitInfoExt)info).getORB());
    }

    private void registerCSIv2Interceptors(ORBInitInfo info, Codec codec) throws DuplicateName {
        SecServerRequestInterceptor sreq;
        ClientConnectionInterceptor cci = new ClientConnectionInterceptor("ClientConnInterceptor", 1);
        info.add_client_request_interceptor((ClientRequestInterceptor)cci);
        String serverSecInterceptor = System.getProperty("interop.secinterceptor.server");
        String clientSecInterceptor = System.getProperty("interop.secinterceptor.client");
        ClientRequestInterceptor creq = null;
        if (clientSecInterceptor != null) {
            try {
                creq = (ClientRequestInterceptor)this.createInterceptorFromProperty("SecClientRequestInterceptor", clientSecInterceptor, codec);
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.log(Level.FINE, "Exception registering security client request interceptor", e);
                    this.m_logger.log(Level.FINE, "Going to register default security client request interceptor");
                }
                creq = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
            }
        }
        if (serverSecInterceptor == null) {
            sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec);
        } else {
            try {
                sreq = (ServerRequestInterceptor)this.createInterceptorFromProperty("SecServerRequestInterceptor", serverSecInterceptor, codec);
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.log(Level.FINE, "Exception registering security server request receptor", e);
                    this.m_logger.log(Level.FINE, "Going to register default security server request interceptor");
                }
                sreq = new SecServerRequestInterceptor("SecServerRequestInterceptor", codec);
            }
        }
        if (creq == null) {
            creq = sreq;
        }
        info.add_client_request_interceptor(creq);
        ServerConnectionInterceptor sci = new ServerConnectionInterceptor(2);
        info.add_server_request_interceptor((ServerRequestInterceptor)sci);
        info.add_server_request_interceptor((ServerRequestInterceptor)sreq);
        SecurityServiceImpl ss = new SecurityServiceImpl();
        Csiv2Manager.setServerSecurityService(ss);
    }

    private Object createInterceptorFromProperty(String name, String clientSecInterceptor, Codec codec) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cInterceptorClass = Class.forName(clientSecInterceptor);
        Class[] paramTypes = new Class[]{String.class, Codec.class};
        Object[] params = new Object[]{name, codec};
        Constructor<?> constructor = cInterceptorClass.getConstructor(paramTypes);
        Object interceptor = constructor.newInstance(params);
        return interceptor;
    }

    private Codec getCodec(ORBInitInfo info) {
        Codec codec;
        CodecFactory cf = info.codec_factory();
        byte major_version = 1;
        byte minor_version = 2;
        Encoding encoding = new Encoding(0, major_version, minor_version);
        try {
            codec = cf.create_codec(encoding);
        }
        catch (UnknownEncoding unknownEncoding) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "Exception otaining codec", unknownEncoding);
            }
            throw new RuntimeException(unknownEncoding.getMessage());
        }
        return codec;
    }
}

