/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.iiop.security;

import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextToken;
import com.sun.corba.ee.org.omg.GSSUP.InitialContextTokenHelper;
import java.io.IOException;
import java.util.StringTokenizer;
import oracle.j2ee.corba.security.CSIV2Messages;
import oracle.oc4j.corba.iiop.security.ClientSecurityMechanismSelector;
import oracle.oc4j.corba.iiop.security.ConnectionContext;
import oracle.oc4j.corba.iiop.security.GSSUtils;
import oracle.oc4j.corba.iiop.security.SecurityMechanismException;
import oracle.oc4j.corba.orb.OrbManager;
import oracle.oc4j.corba.security.auth.login.PasswordCredential;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.IOP.Codec;

public class GSSUPToken {
    public static final String DELIMITER = "@";
    private byte[] cdr_encoded_token = new byte[0];
    PasswordCredential pwdcred = null;

    public GSSUPToken(ORB orb, Codec codec, PasswordCredential pwdcred) {
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        CSIV2Messages.fineMsg("Going to construct a GSSUPToken:");
        CSIV2Messages.fineMsg(pwdcred.toString());
        try {
            StringBuffer _name = new StringBuffer(pwdcred.getUser());
            String realm = pwdcred.getRealm();
            if (realm != null) {
                _name.append(DELIMITER);
                _name.append(realm);
            }
            name_utf8 = _name.toString().getBytes("UTF8");
            password_utf8 = pwdcred.getPassword().getBytes("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientSecurityMechanismSelector sms = OrbManager.getSecurityMechanismSelector();
        ConnectionContext cc = sms.getClientConnectionContext();
        CompoundSecMech mech = cc.getMechanism();
        byte[] target_name = mech.as_context_mech.target_name;
        CSIV2Messages.fineMsg("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
        CSIV2Messages.fineMsg("Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
        CSIV2Messages.fineMsg("Targetname      " + GSSUtils.dumpHex(target_name));
        InitialContextToken inctxToken = new InitialContextToken(name_utf8, password_utf8, target_name);
        Any a = orb.create_any();
        InitialContextTokenHelper.insert((Any)a, (InitialContextToken)inctxToken);
        try {
            this.cdr_encoded_token = codec.encode_value(a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CSIV2Messages.fineMsg("Mech specific token length (CDR encoded) = " + this.cdr_encoded_token.length);
    }

    public GSSUPToken(ORB orb, Codec codec, byte[] authtok) throws SecurityMechanismException {
        String name;
        byte[] name_utf8 = new byte[]{};
        byte[] password_utf8 = new byte[]{};
        byte[] target_name = new byte[]{};
        String username = "";
        String userpwd = "";
        String realm = "";
        byte[] encoded_token = new byte[]{};
        CSIV2Messages.fineMsg("Going to construct a GSSUPToken:");
        CSIV2Messages.fineMsg("Getting CDR encoded GSSUP mechanism token from client authentication token");
        encoded_token = GSSUtils.getMechToken(GSSUtils.GSSUP_MECH_OID, authtok);
        CSIV2Messages.fineMsg("CDR encoded mech specific token length = " + encoded_token.length);
        Any a = orb.create_any();
        try {
            a = codec.decode_value(encoded_token, InitialContextTokenHelper.type());
        }
        catch (Exception e) {
            CSIV2Messages.finerThrowableNoMsg(e);
        }
        InitialContextToken inctxToken = InitialContextTokenHelper.extract((Any)a);
        password_utf8 = inctxToken.password;
        name_utf8 = inctxToken.username;
        target_name = inctxToken.target_name;
        CSIV2Messages.fineMsg("Username (UTF8) " + GSSUtils.dumpHex(name_utf8));
        CSIV2Messages.fineMsg("Password (UTF8) " + GSSUtils.dumpHex(password_utf8));
        CSIV2Messages.fineMsg("Targetname      " + GSSUtils.dumpHex(target_name));
        try {
            username = new String(name_utf8, "UTF8");
            userpwd = new String(password_utf8, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int index = username.indexOf(DELIMITER);
        if (index == -1) {
            name = username;
        } else {
            if (index == 0) {
                throw new SecurityMechanismException("No name_value in username");
            }
            StringTokenizer strtok = new StringTokenizer(username, DELIMITER);
            name = strtok.nextToken();
            if (strtok.hasMoreTokens() && !(realm = strtok.nextToken()).equals("default")) {
                throw new SecurityMechanismException("Unknown realm");
            }
        }
        this.pwdcred = new PasswordCredential(name, userpwd, "default", target_name);
        CSIV2Messages.fineMsg(this.pwdcred.toString());
    }

    public byte[] getGSSToken() throws IOException {
        CSIV2Messages.finerMsg("GSSUP mech token : " + GSSUtils.dumpHex(this.cdr_encoded_token));
        byte[] gsstoken = GSSUtils.createMechIndToken(GSSUtils.GSSUP_MECH_OID, this.cdr_encoded_token);
        CSIV2Messages.fineMsg("GSSUP token length : " + gsstoken.length);
        CSIV2Messages.finerMsg("GSSUP token: " + GSSUtils.dumpHex(gsstoken));
        return gsstoken;
    }

    public PasswordCredential getPwdcred() {
        return this.pwdcred;
    }
}

