/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.corba.deployment;

import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class EjbIORConfigurationDescriptor {
    public static final String NONE = "none";
    public static final String SUPPORTED = "supported";
    public static final String REQUIRED = "required";
    public static final String USERNAME_PASSWORD = "username_password";
    public static final String DEFAULT_REALM = "default";
    private static final String SECURE_PROPERTIES_FILE = "ejb_sec_properties_location";
    private static final String SECURE_PROPERTIES = "ejb_sec.properties";
    private static final String USE_SSL = "nameservice.useSSL";
    private String integrity = "supported";
    private String confidentiality = "supported";
    private String establishTrustInTarget = "supported";
    private String establishTrustInClient = "supported";
    private String authenticationMethod = "username_password";
    private String realmName = "default";
    private String callerPropagation = "supported";
    private boolean required = false;

    public EjbIORConfigurationDescriptor() {
        Properties cprops = new Properties();
        try {
            String authRequired;
            FileInputStream fis;
            String spf = System.getProperty(SECURE_PROPERTIES_FILE);
            if (spf == null) {
                spf = OC4JRuntimeProperties.getJ2eeHomeDir() + File.separator + "config" + File.separator + SECURE_PROPERTIES;
            }
            try {
                File secFile = new File(spf);
                fis = new FileInputStream(secFile);
            }
            catch (FileNotFoundException e) {
                File secFile = new File(SECURE_PROPERTIES);
                fis = new FileInputStream(secFile);
            }
            cprops.load(fis);
            fis.close();
            boolean val = false;
            String us = cprops.getProperty(USE_SSL);
            if (us != null && !us.trim().equals("")) {
                val = new Boolean(us);
            }
            if (val) {
                this.integrity = REQUIRED;
                this.confidentiality = REQUIRED;
                this.establishTrustInClient = REQUIRED;
                this.establishTrustInTarget = SUPPORTED;
            }
            if ((authRequired = cprops.getProperty("interop.authRequired.enabled")) != null && !authRequired.trim().equals("") && (val = new Boolean(authRequired).booleanValue())) {
                this.required = true;
                this.authenticationMethod = USERNAME_PASSWORD;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public EjbIORConfigurationDescriptor(boolean enableUsernamePassword) {
        if (enableUsernamePassword) {
            this.required = true;
            this.authenticationMethod = USERNAME_PASSWORD;
        }
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for integrity:" + val);
        }
        this.integrity = val;
    }

    public String getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for confidentiality:" + val);
        }
        this.confidentiality = val;
    }

    public String getEstablishTrustInTarget() {
        return this.establishTrustInTarget;
    }

    public void setEstablishTrustInTarget(String val) {
        if (!val.equals(NONE) && !val.equals(SUPPORTED)) {
            throw new RuntimeException("Incorrect value for establishTrustInTarget:" + val);
        }
        this.establishTrustInTarget = val;
    }

    public String getEstablishTrustInClient() {
        return this.establishTrustInClient;
    }

    public void setEstablishTrustInClient(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for establishTrustInClient:" + val);
        }
        this.establishTrustInClient = val;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String val) {
        if (!val.equals(USERNAME_PASSWORD) && !val.equals(NONE)) {
            throw new RuntimeException("Incorrect value for authentication method:" + val);
        }
        this.authenticationMethod = val;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String val) {
        this.realmName = val;
    }

    public String getCallerPropagation() {
        return this.callerPropagation;
    }

    public void setCallerPropagation(String val) {
        if (!(val.equals(NONE) || val.equals(SUPPORTED) || val.equals(REQUIRED))) {
            throw new RuntimeException("Incorrect value for callerPropagation:" + val);
        }
        this.callerPropagation = val;
    }

    public boolean isAuthMethodRequired() {
        return this.required;
    }

    public void setAuthMethodRequired(boolean val) {
        this.required = val;
    }

    public String toString() {
        String s = "";
        s = s + "\n integrity " + this.integrity;
        s = s + "\n confidentiality " + this.confidentiality;
        s = s + "\n establishTrustInTarget " + this.establishTrustInTarget;
        s = s + "\n establishTrustInClient " + this.establishTrustInClient;
        s = s + "\n callerPropagation " + this.callerPropagation;
        s = s + "\n realm " + this.realmName;
        s = s + "\n authenticationMethod " + this.authenticationMethod + "\n";
        return s;
    }
}

