/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.SchedulerAggregationMBean;

public class SchedulerAggregation
extends J2EEManagedObjectBase
implements SchedulerAggregationMBean {
    public static final String MBEAN_OPER_ADD_BLACKOUT_WINDOW = "addBlackoutWindow";
    public static final String MBEAN_OPER_PAUSE = "pause";
    public static final String MBEAN_OPER_RESUME = "resume";
    public static final String MBEAN_OPER_CANCEL = "cancel";
    public static final String MBEAN_ATTR_JOBS = "Jobs";
    public static final String MBEAN_ATTR_SCHEDULERS = "Schedulers";
    public static final String MBEAN_NAME = ":j2eeType=OracleASSchedulerAggregate,name=singleton,J2EEServer=standalone";
    private static final String RESOURCE = "oracle.oc4j.admin.management.mbeans.Messages";
    private static final String LOGGER = "oracle.j2ee.scheduler";
    private Logger m_logger = null;

    public SchedulerAggregation() {
        this.setBaseObjectName(MBEAN_NAME);
        this.init();
    }

    public SchedulerAggregation(Locale loc) {
        super(loc);
        this.setBaseObjectName(MBEAN_NAME);
        this.init();
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo(MBEAN_ATTR_SCHEDULERS, "java.util.Collection", this.getLocalizedMessage("scheduleraggregation_list_schedulers"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo(MBEAN_ATTR_JOBS, "java.util.Collection", this.getLocalizedMessage("scheduleraggregation_list_jobs"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo(MBEAN_OPER_PAUSE, this.getLocalizedMessage("scheduleraggregation_pause_all"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo(MBEAN_OPER_CANCEL, this.getLocalizedMessage("scheduleraggregation_cancel_all"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo(MBEAN_OPER_RESUME, this.getLocalizedMessage("scheduleraggregation_resume_all"), new MBeanParameterInfo[]{new MBeanParameterInfo("replay", "boolean", this.getLocalizedMessage("scheduleraggregation_replay_on_resume"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo(MBEAN_OPER_ADD_BLACKOUT_WINDOW, this.getLocalizedMessage("scheduleraggregation_addblackout"), new MBeanParameterInfo[]{new MBeanParameterInfo("description", "java.lang.String", this.getLocalizedMessage("scheduleraggregation_blackout_window_desc")), new MBeanParameterInfo("datetime", "java.lang.String", this.getLocalizedMessage("scheduleraggregation_blackout_window_startinstant")), new MBeanParameterInfo("duration", "long", this.getLocalizedMessage("scheduleraggregation_blackout_window_duration"))}, "void", 1));
    }

    public String getDescription() {
        return this.getLocalizedMessage("scheduleraggregation_description");
    }

    public Collection getSchedulers() throws JMException {
        String schedulersPattern = "*:j2eeType=OracleASScheduler,*";
        Set schedulers = this.getSetObjectNameForPattern(schedulersPattern);
        return schedulers;
    }

    public Collection getJobs() throws JMException {
        String jobsPattern = "*:j2eeType=OracleASSchedulerJob,*";
        Set jobs = this.getSetObjectNameForPattern(jobsPattern);
        return jobs;
    }

    public void pause() {
        try {
            Collection jobs = this.getJobs();
            MBeanServer mbsrv = this.getMBeanServer();
            Iterator i = jobs.iterator();
            while (i.hasNext()) {
                ObjectName oName = (ObjectName)i.next();
                try {
                    mbsrv.invoke(oName, MBEAN_OPER_PAUSE, new Object[0], new String[0]);
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.WARNING, oName.toString(), t);
                }
            }
        }
        catch (JMException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void resume(boolean replay) {
        try {
            Collection jobs = this.getJobs();
            MBeanServer mbsrv = this.getMBeanServer();
            Iterator i = jobs.iterator();
            while (i.hasNext()) {
                ObjectName oName = (ObjectName)i.next();
                try {
                    mbsrv.invoke(oName, MBEAN_OPER_RESUME, new Object[]{new Boolean(replay)}, new String[]{"boolean"});
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.WARNING, oName.toString(), t);
                }
            }
        }
        catch (JMException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void cancel() {
        try {
            Collection jobs = this.getJobs();
            MBeanServer mbsrv = this.getMBeanServer();
            Iterator i = jobs.iterator();
            while (i.hasNext()) {
                ObjectName oName = (ObjectName)i.next();
                try {
                    mbsrv.invoke(oName, MBEAN_OPER_CANCEL, new Object[0], new String[0]);
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.WARNING, oName.toString(), t);
                }
            }
        }
        catch (JMException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void addBlackoutWindow(String description, String dateTime, long duration) {
        try {
            Collection schedulers = this.getSchedulers();
            MBeanServer mbsrv = this.getMBeanServer();
            Iterator i = schedulers.iterator();
            while (i.hasNext()) {
                ObjectName oName = (ObjectName)i.next();
                try {
                    mbsrv.invoke(oName, MBEAN_OPER_ADD_BLACKOUT_WINDOW, new Object[]{description, dateTime, new Long(duration)}, new String[]{"java.lang.String", "java.lang.String", "long"});
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.WARNING, oName.toString(), t);
                }
            }
        }
        catch (JMException e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    private Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = Logger.getLogger(LOGGER, RESOURCE);
        }
        return this.m_logger;
    }
}

