/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.connector.deployment.AuthenticationMechanism;
import com.evermind.server.connector.deployment.ConfigurationProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.callbackinterfaces.ManageableResourceAdapter;
import oracle.oc4j.admin.management.callbackinterfaces.ResourceAdapterCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEStateManageableObject;
import oracle.oc4j.admin.management.mbeans.JCASharedConnectionPool;
import oracle.oc4j.admin.management.mbeans.ResourceAdapterMBean;
import oracle.oc4j.admin.management.shared.JCAAuthenticationMechanism;
import oracle.oc4j.admin.management.shared.JCAConfigurationProperty;

public class ResourceAdapter
extends J2EEServerDependentObjectBase
implements ResourceAdapterMBean,
J2EEStateManageableObject {
    private static Logger logger_ = TraceLogger.getLogger(ResourceAdapter.class);
    private ResourceAdapterCallBackIf m_runtimeConfiguration = null;
    private String stdSuffix = null;
    boolean storeOC4JConnectors_ = false;
    boolean storeOC4JRa_ = false;
    private ManageableResourceAdapter m_adapter;

    public ResourceAdapter(ManageableResourceAdapter adapter, String name, String moduleName, String j2eeAppName) {
        this.m_adapter = adapter;
        this.m_runtimeConfiguration = adapter.getConfiguration();
        this.setBaseObjectName(":j2eeType=ResourceAdapter,name=" + name + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName());
        this.stdSuffix = ",ResourceAdapter=" + name + ",ResourceAdapterModule=" + moduleName + ",J2EEApplication=" + j2eeAppName + ",J2EEServer=" + this.getJ2eeServerName() + ",*";
        this.init();
    }

    public ResourceAdapter(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        HashMap<String, String> persistenceDescriptorProperties = new HashMap<String, String>();
        persistenceDescriptorProperties.put("persistPolicy", "OnUpdate");
        this.addStateManageableInfo();
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("configProperties", "java.util.List", this.getLocalizedMessage("resourceadapter_configProperties"), true, true, false), persistenceDescriptorProperties);
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("resourceAdapterClass", "java.lang.String", this.getLocalizedMessage("resourceadapter_resourceAdapterClass"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("messageListenerTypes", "java.util.Set", this.getLocalizedMessage("resourceadapter_messageListenerTypes"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionDefinitions", "java.util.List", this.getLocalizedMessage("resourceadapter_connectionDefinitions"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("connectionFactoryInterfaces", "java.util.List", this.getLocalizedMessage("resourceadapter_connectionFactoryInterfaces"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("managedConnectionFactories", "java.util.List", this.getLocalizedMessage("resourceadapter_managedConnectionFactories"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("managedConnectionFactoryClasses", "java.util.List", this.getLocalizedMessage("resourceadapter_managedConnectionFactoryClasses"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adminObjects", "java.util.List", this.getLocalizedMessage("resourceadapter_adminObjects"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adminObjectClasses", "java.util.List", this.getLocalizedMessage("resourceadapter_adminObjectClasses"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("jcaResource", "java.lang.String", this.getLocalizedMessage("resourceadapter_jcaResource"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("workManager", "java.lang.String", this.getLocalizedMessage("resourceadapter_workManager"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("endpointActivations", "java.util.List", this.getLocalizedMessage("resourceadapter_endpointActivations"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adapterType", "java.lang.String", this.getLocalizedMessage("resourceadapter_adapterType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("description", "java.lang.String", this.getLocalizedMessage("resourceadapter_description"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("vendorName", "java.lang.String", this.getLocalizedMessage("resourceadapter_vendorName"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("eisType", "java.lang.String", this.getLocalizedMessage("resourceadapter_eisType"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("adapterVersion", "java.lang.String", this.getLocalizedMessage("resourceadapter_adapterVersion"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("specVersion", "java.util.List", this.getLocalizedMessage("resourceadapter_specVersion"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("transactionSupport", "java.lang.String", this.getLocalizedMessage("resourceadapter_transactionSupport"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("authenticationMechanisms", "java.util.List", this.getLocalizedMessage("resourceadapter_authenticationMechanisms"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("reauthenticationSupport", "boolean", this.getLocalizedMessage("resourceadapter_reauthenticationSupport"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("licenseRequired", "boolean", this.getLocalizedMessage("resourceadapter_licenseRequired"), true, false, false));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("start", this.getLocalizedMessage("resourceadapter_start"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("stop", this.getLocalizedMessage("resourceadapter_stop"), new MBeanParameterInfo[0], "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("restart", this.getLocalizedMessage("resourceadapter_restart"), new MBeanParameterInfo[0], "void", 1));
        MBeanParameterInfo[] getSharedPoolCandidatesParams = new MBeanParameterInfo[]{new MBeanParameterInfo("managedConnectionFactory", "java.lang.String", this.getLocalizedMessage("resourceadapter_managedConnectionFactory"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getSharedPoolCandidates", this.getLocalizedMessage("resourceadapter_getSharedPoolCandidates"), getSharedPoolCandidatesParams, "[Ljava.lang.String;", 0));
        MBeanParameterInfo[] addSharedConnectionPoolParams = new MBeanParameterInfo[]{new MBeanParameterInfo("poolName", "java.lang.String", this.getLocalizedMessage("resourceadapter_poolName")), new MBeanParameterInfo("properties", "java.util.Map", this.getLocalizedMessage("resourceadapter_properties"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("addSharedConnectionPool", this.getLocalizedMessage("resourceadapter_addSharedConnectionPool"), addSharedConnectionPoolParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] removeSharedConnectionPoolParams = new MBeanParameterInfo[]{new MBeanParameterInfo("poolName", "java.lang.String", this.getLocalizedMessage("resourceadapter_poolName"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("removeSharedConnectionPool", this.getLocalizedMessage("resourceadapter_removeSharedConnectionPool"), removeSharedConnectionPoolParams, "void", 1), persistenceDescriptorProperties);
        MBeanParameterInfo[] getactivationspecClassParams = new MBeanParameterInfo[]{new MBeanParameterInfo("messageListenerType", "java.lang.String", this.getLocalizedMessage("resourceadapter_messageListenerType"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getactivationspecClass", this.getLocalizedMessage("resourceadapter_getactivationspecClass"), getactivationspecClassParams, "java.lang.String", 0));
        MBeanParameterInfo[] getrequiredConfigPropertiesParams = new MBeanParameterInfo[]{new MBeanParameterInfo("messageListenerType", "java.lang.String", this.getLocalizedMessage("resourceadapter_messageListenerType"))};
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getrequiredConfigProperties", this.getLocalizedMessage("resourceadapter_getrequiredConfigProperties"), getrequiredConfigPropertiesParams, "java.util.List", 0));
    }

    public final void start() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 1 || this.getstate() == 0) {
                    this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
                    return;
                }
                if (this.getstate() == 2) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("ResourceAdapter: " + thisObj + " currently stopping. It cannot be started until stop operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.m_adapter.start();
                this.reportStateManagementSuccess("j2ee.state.running", locHelp.getLocalizedMessage("statemanageable_success_start"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_start") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public final void startRecursive() {
        this.start();
    }

    public final void stop() {
        block11: {
            MessageLocalizationHelper locHelp;
            block10: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                if (this.getstate() == 3 || this.getstate() == 2) {
                    this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
                    return;
                }
                if (this.getstate() == 0) {
                    ObjectName thisObj = null;
                    try {
                        thisObj = this.getObjectName();
                    }
                    catch (MalformedObjectNameException e) {
                        // empty catch block
                    }
                    throw new JMXRuntimeException("ResourceAdapter: " + thisObj + " currently starting. It cannot be stopped until start operation completes.");
                }
                try {
                    Notification notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.m_adapter.stop();
                this.reportStateManagementSuccess("j2ee.state.stopped", locHelp.getLocalizedMessage("statemanageable_success_stop"));
            }
            catch (Throwable t) {
                try {
                    Notification notification = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block11;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void stop(Map params) {
        this.stop();
    }

    private void reportStateManagementSuccess(String nofifType, String notifMsg) {
        block2: {
            try {
                Notification notification = new Notification(nofifType, this.getObjectName(), 0L, new Date().getTime(), notifMsg + this.getObjectName());
                NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                notification.setUserData(userData);
                this.fireEvent(notification);
            }
            catch (MalformedObjectNameException e) {
                if (!logger_.isLoggable(Level.SEVERE)) break block2;
                logger_.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public List getconfigProperties() throws JMXException {
        List incomingAssembledProps = this.m_runtimeConfiguration.getConfigurationProperties();
        if (incomingAssembledProps != null) {
            ArrayList<JCAConfigurationProperty> outgoingList = new ArrayList<JCAConfigurationProperty>(incomingAssembledProps.size());
            Iterator iter = incomingAssembledProps.iterator();
            while (iter.hasNext()) {
                ConfigurationProperty assembledEntry = (ConfigurationProperty)iter.next();
                String runtimeValue = this.m_runtimeConfiguration.getRuntimeConfigurationProperty(assembledEntry.getName());
                JCAConfigurationProperty entry = new JCAConfigurationProperty(assembledEntry, runtimeValue);
                outgoingList.add(entry);
            }
            return outgoingList;
        }
        return Collections.EMPTY_LIST;
    }

    public void setconfigProperties(List incomingProps) throws JMXException {
        if (incomingProps != null) {
            JCAConfigurationProperty entry;
            Iterator iter = incomingProps.iterator();
            while (iter.hasNext()) {
                try {
                    entry = (JCAConfigurationProperty)iter.next();
                }
                catch (ClassCastException e) {
                    throw new JMXException((Throwable)e, "Unable to set configuration properties on resource adapter class via MBean.");
                }
            }
            iter = incomingProps.iterator();
            while (iter.hasNext()) {
                entry = (JCAConfigurationProperty)iter.next();
                try {
                    this.m_runtimeConfiguration.setRuntimeConfigurationProperty(entry.getName(), entry.getDeployedValue());
                }
                catch (Exception e) {
                    throw new JMXRuntimeException((Throwable)e, e.getMessage());
                }
            }
        }
        this.storeOC4JConnectors_ = true;
    }

    public String getresourceAdapterClass() throws JMXException {
        return this.m_runtimeConfiguration.getResourceAdapterClass();
    }

    public Set getmessageListenerTypes() throws JMXException {
        return new HashSet(this.m_runtimeConfiguration.getMessageListenerTypes());
    }

    public String getactivationspecClass(String messageListener) throws JMXException {
        return this.m_runtimeConfiguration.getActivationSpecClass(messageListener);
    }

    public List getrequiredConfigProperties(String messageListener) throws JMXException {
        List l = this.m_runtimeConfiguration.getRequiredConfigProperties(messageListener);
        ArrayList<JCAConfigurationProperty> outgoingList = new ArrayList<JCAConfigurationProperty>(l.size());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            JCAConfigurationProperty entry = new JCAConfigurationProperty((ConfigurationProperty)iter.next());
            outgoingList.add(entry);
        }
        return outgoingList;
    }

    public List getconnectionDefinitions() throws JMXException {
        String searchPattern = "*:j2eeType=JCAConnectionDefinition" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return Arrays.asList(res);
    }

    public List getconnectionFactoryInterfaces() throws JMXException {
        String searchPattern = "*:j2eeType=JCAConnectionDefinition" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        ArrayList<String> retVal = new ArrayList<String>(objs.length);
        MBeanServer mbeanServer = this.getMBeanServer();
        for (int i = 0; i < objs.length; ++i) {
            try {
                String cf = (String)mbeanServer.getAttribute(objs[i], "connectionFactoryInterface");
                retVal.add(cf);
                continue;
            }
            catch (Exception e) {
                throw new JMXException((Throwable)e, "Unable to retrieve connection factory interface list via MBean.");
            }
        }
        return retVal;
    }

    public List getmanagedConnectionFactories() throws JMXException {
        String searchPattern = "*:j2eeType=JCAManagedConnectionFactory" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return Arrays.asList(res);
    }

    public List getmanagedConnectionFactoryClasses() throws JMXException {
        return this.m_runtimeConfiguration.getManagedConnectionFactoryClasses();
    }

    public List getadminObjects() throws JMXException {
        String searchPattern = "*:j2eeType=JCAAdminObject" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return Arrays.asList(res);
    }

    public List getadminObjectClasses() throws JMXException {
        return this.m_runtimeConfiguration.getAdminObjectClasses();
    }

    public String getjcaResource() throws JMXException {
        String searchPattern = "*:j2eeType=JCAResource" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        if (objs.length != 1) {
            throw new JMXException("Unable to find the unique JCAResource MBean");
        }
        return objs[0].toString();
    }

    public String getworkManager() throws JMXException {
        String searchPattern = "*:j2eeType=WorkManagerResource" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        if (objs.length != 1) {
            throw new JMXException("Unable to find the unique WorkManagerResource MBean");
        }
        return objs[0].toString();
    }

    public List getendpointActivations() throws JMXException {
        String searchPattern = "*:j2eeType=JCAEndpointActivation" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return Arrays.asList(res);
    }

    public String getadapterType() throws JMXException {
        boolean outbound;
        boolean inbound = this.m_runtimeConfiguration.getMessageListenerTypes() != null;
        List mcfList = this.m_runtimeConfiguration.getManagedConnectionFactoryClasses();
        boolean bl = outbound = mcfList != null && mcfList.size() > 0;
        if (inbound && outbound) {
            return "bidirectional";
        }
        if (inbound) {
            return "inbound";
        }
        return "outbound";
    }

    public String getdescription() throws JMXException {
        return this.m_runtimeConfiguration.getDescription();
    }

    public String getvendorName() throws JMXException {
        return this.m_runtimeConfiguration.getVendor();
    }

    public String geteisType() throws JMXException {
        return this.m_runtimeConfiguration.getEISType();
    }

    public String getadapterVersion() throws JMXException {
        return this.m_runtimeConfiguration.getVersion();
    }

    public String getspecVersion() throws JMXException {
        return this.m_runtimeConfiguration.getSpecificationVersion();
    }

    public String gettransactionSupport() throws JMXException {
        if (this.getadapterType() == "inbound") {
            return "NoTransaction";
        }
        return this.m_runtimeConfiguration.getTxnSupport();
    }

    public List getauthenticationMechanisms() throws JMXException {
        List incomingList = this.m_runtimeConfiguration.getAuthMechanisms();
        if (incomingList != null) {
            ArrayList<JCAAuthenticationMechanism> outgoingList = new ArrayList<JCAAuthenticationMechanism>(incomingList.size());
            Iterator iter = incomingList.iterator();
            while (iter.hasNext()) {
                JCAAuthenticationMechanism entry = new JCAAuthenticationMechanism((AuthenticationMechanism)iter.next());
                outgoingList.add(entry);
            }
            return outgoingList;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean getreauthenticationSupport() throws JMXException {
        return this.m_runtimeConfiguration.getReauthSupport();
    }

    public boolean getlicenseRequired() throws JMXException {
        return this.m_runtimeConfiguration.isLicenseRequired();
    }

    public void restart() throws JMXException {
        this.stop();
        this.start();
    }

    public String[] getSharedPoolCandidates(String managedConnectionFactoryClass) throws JMXException {
        String searchPattern = "*:j2eeType=JCASharedConnectionPool" + this.stdSuffix;
        ObjectName[] objs = this.getObjectNameForPattern(searchPattern);
        MBeanServer mbeanServer = this.getMBeanServer();
        String[] res = new String[objs.length];
        String mcf = null;
        int j = 0;
        for (int i = 0; i < objs.length; ++i) {
            try {
                mcf = (String)mbeanServer.getAttribute(objs[i], "managedConnectionFactoryClass");
                if (mcf == null) {
                    res[j++] = objs[i].toString();
                    continue;
                }
                if (!mcf.equals(managedConnectionFactoryClass)) continue;
                res[j++] = objs[i].toString();
                continue;
            }
            catch (Exception e) {
                throw new JMXException((Throwable)e, "Failed to get shared connection pool  candidates list.");
            }
        }
        return res;
    }

    public void addSharedConnectionPool(String name, Map properties) throws JMXException {
        try {
            HashMap internalProperties = new HashMap();
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String externalName = (String)entry.getKey();
                Object value = entry.getValue();
                String internalName = JCASharedConnectionPool.getInternalPropertyName(externalName);
                internalProperties.put(internalName, value);
            }
            this.m_runtimeConfiguration.addSharedConnectionPool(name, internalProperties);
            this.storeOC4JRa_ = true;
        }
        catch (Exception e) {
            throw new JMXException((Throwable)e, "Unable to create shared connection pool via MBean.");
        }
    }

    public void removeSharedConnectionPool(String name) throws JMXException {
        try {
            this.m_runtimeConfiguration.removeSharedConnectionPool(name);
            this.storeOC4JRa_ = true;
        }
        catch (Exception e) {
            throw new JMXException((Throwable)e, "Unable to remove connection pool via MBean.");
        }
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            if (this.storeOC4JConnectors_) {
                this.m_runtimeConfiguration.persistUpdates();
            }
            if (this.storeOC4JRa_) {
                this.m_runtimeConfiguration.persistConfigChange();
            }
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final boolean getstateManageable() {
        return true;
    }

    public final int getstate() {
        return this.m_runtimeConfiguration.getComponentState();
    }

    public final long getstartTime() {
        return this.m_runtimeConfiguration.getStartTime();
    }
}

