/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameUtil;
import oracle.oc4j.admin.management.callbackinterfaces.JmsOperationsCallBackIf;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.JmsOperationsMBean;

public class JmsOperations
extends J2EEServerDependentObjectBase
implements JmsOperationsMBean {
    private JmsOperationsCallBackIf m_callback = null;

    public JmsOperations(JmsOperationsCallBackIf callback) {
        this.m_callback = callback;
        this.setBaseObjectName(":j2eeType=JmsOperationsResource,name=" + ObjectNameUtil.quote((String)"JmsOperations") + ",J2EEServer=" + "standalone");
        this.init();
    }

    public JmsOperations(Locale loc) {
        super(loc);
        this.init();
    }

    private void init() {
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("subscribe", this.getLocalizedMessage("jmsoperations_subscribe"), new MBeanParameterInfo[]{new MBeanParameterInfo("topic", "java.lang.String", this.getLocalizedMessage("jmsoperations_topic")), new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("selector", "java.lang.String", this.getLocalizedMessage("jmsoperations_selector")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID")), new MBeanParameterInfo("noLocal", "java.lang.Boolean", this.getLocalizedMessage("jmsoperations_noLocal"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("unsubscribe", this.getLocalizedMessage("jmsoperations_unsubscribe"), new MBeanParameterInfo[]{new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID"))}, "void", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("drainSubscription", this.getLocalizedMessage("jmsoperations_drainSubscription"), new MBeanParameterInfo[]{new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID")), new MBeanParameterInfo("transacted", "java.lang.Boolean", this.getLocalizedMessage("jmsoperations_transacted")), new MBeanParameterInfo("count", "java.lang.Integer", this.getLocalizedMessage("jmsoperations_drainCount"))}, "java.lang.Integer", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("showSubscriptionMessageHeaders", this.getLocalizedMessage("jmsoperations_getSubscriptionMessageHeaders"), new MBeanParameterInfo[]{new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID")), new MBeanParameterInfo("count", "java.lang.Integer", this.getLocalizedMessage("jmsoperations_browseCount"))}, "java.util.List", 0));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("browseSubscription", this.getLocalizedMessage("jmsoperations_browseSubscription"), new MBeanParameterInfo[]{new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID")), new MBeanParameterInfo("excludeBody", "java.lang.Boolean", this.getLocalizedMessage("jmsoperations_excludeBody")), new MBeanParameterInfo("count", "java.lang.Integer", this.getLocalizedMessage("jmsoperations_browseCount"))}, "java.lang.String", 1));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("showSubscriptionSummaries", this.getLocalizedMessage("jmsoperations_showSubscriptionSummaries"), new MBeanParameterInfo[]{new MBeanParameterInfo("topicName", "java.lang.String", this.getLocalizedMessage("jmsoperations_topicName")), new MBeanParameterInfo("includeState", "java.lang.Boolean", this.getLocalizedMessage("jmsoperations_includeState"))}, "java.util.List", 0));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("showSubscriptionSummary", this.getLocalizedMessage("jmsoperations_showSubscriptionSummary"), new MBeanParameterInfo[]{new MBeanParameterInfo("subscription", "java.lang.String", this.getLocalizedMessage("jmsoperations_subscription")), new MBeanParameterInfo("clientID", "java.lang.String", this.getLocalizedMessage("jmsoperations_clientID")), new MBeanParameterInfo("includeState", "java.lang.Boolean", this.getLocalizedMessage("jmsoperations_includeState"))}, "java.util.Map", 0));
    }

    public void subscribe(String topic, String subscription, String selector, String clientID, Boolean noLocal) throws Exception {
        this.m_callback.subscribe(topic, subscription, selector, clientID, noLocal);
    }

    public void unsubscribe(String subscription, String clientID) throws Exception {
        this.m_callback.unsubscribe(subscription, clientID);
    }

    public List showSubscriptionMessageHeaders(String subscription, String clientID, Integer count) throws Exception {
        return this.m_callback.showSubscriptionMessageHeaders(subscription, clientID, count);
    }

    public Integer drainSubscription(String subscription, String clientID, Boolean transacted, Integer count) throws Exception {
        return this.m_callback.drainSubscription(subscription, clientID, transacted, count);
    }

    public String browseSubscription(String subscription, String clientID, Boolean excludeBody, Integer count) throws Exception {
        return this.m_callback.browseSubscription(subscription, clientID, excludeBody, count);
    }

    public List showSubscriptionSummaries(String topicName, Boolean includeState) throws Exception {
        return this.m_callback.showSubscriptionSummaries(topicName, includeState);
    }

    public Map showSubscriptionSummary(String subscription, String clientID, Boolean includeState) throws Exception {
        return this.m_callback.showSubscriptionSummary(subscription, clientID, includeState);
    }
}

