/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.ApplicationServerTransactionManager;
import com.evermind.server.ApplicationServerTransactionManagerAdmin;
import com.evermind.server.ApplicationServerTransactionStats;
import com.evermind.server.DMSEvent;
import com.evermind.server.InvalidConfigurationException;
import java.io.IOException;
import java.util.Locale;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.TransactionManagerConfiguration;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.j2ee.transaction.TransactionDetail;
import oracle.j2ee.transaction.TransactionManagerConfigurationDetail;
import oracle.j2ee.transaction.recovery.RecoveryAbandonmentDetail;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.management.mbeans.J2EEResourceBase;
import oracle.oc4j.admin.management.mbeans.JTAResourceMBean;
import oracle.oc4j.admin.management.mbeans.JTAResourceMeta;
import oracle.oc4j.admin.management.mbeans.StatisticsProvider;
import oracle.oc4j.admin.management.shared.statistic.JTAStatsImpl;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSCountStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSMetric;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSStatistic;
import oracle.oc4j.admin.management.shared.statistic.dms.DMSTimeStatistic;

public class JTAResource
extends J2EEResourceBase
implements JTAResourceMBean,
StatisticsProvider {
    public ApplicationServerTransactionManagerAdmin m_tmAdmin;

    public JTAResource(ApplicationServerTransactionManager tm, String domain, String j2eeServerName, String name) {
        super(domain, j2eeServerName, name);
        this.m_tmAdmin = new ApplicationServerTransactionManagerAdmin(tm);
        this.setBaseObjectNameForJTAResource(j2eeServerName);
        new JTAResourceMeta(this);
        this.m_tmAdmin.setJTAResource(this);
    }

    public JTAResource(ApplicationServerTransactionManager tm, String name) {
        super(name);
        this.m_tmAdmin = new ApplicationServerTransactionManagerAdmin(tm);
        this.setBaseObjectNameForJTAResource();
        new JTAResourceMeta(this);
        this.m_tmAdmin.setJTAResource(this);
    }

    public JTAResource(String domain, String j2eeServerName, String name) {
        super(domain, j2eeServerName, name);
        this.setBaseObjectNameForJTAResource(j2eeServerName);
        new JTAResourceMeta(this);
    }

    public JTAResource(String name) {
        super(name);
        this.setBaseObjectNameForJTAResource();
        new JTAResourceMeta(this);
    }

    private void setBaseObjectNameForJTAResource() {
        this.setBaseObjectNameForJTAResource(this.getJ2eeServerName());
    }

    private void setBaseObjectNameForJTAResource(String j2eeServerName) {
        super.setBaseObjectName(":j2eeType=JTAResource,name=" + this.getQuotedName() + ",J2EEServer=" + j2eeServerName);
    }

    public JTAResource(Locale loc) {
        super(loc);
        new JTAResourceMeta(this);
    }

    public Xid[] getinDoubtXids() {
        return this.m_tmAdmin.getInDoubtXids();
    }

    public Xid[] getactiveXids() {
        return this.m_tmAdmin.getActiveXids();
    }

    public void setRollbackOnly(Xid xid) throws SystemException, IllegalStateException {
        this.m_tmAdmin.adminRollback(xid);
    }

    public void rollbackTransaction(Xid xid) throws SystemException, IllegalStateException {
        this.m_tmAdmin.rollbackTransaction(xid);
    }

    public void heuristicRollback(Xid xid) throws SystemException, IllegalStateException {
        this.m_tmAdmin.heuristicRollback(xid);
    }

    public void heuristicCommit(Xid xid) throws SystemException, IllegalStateException {
        this.m_tmAdmin.heuristicCommit(xid);
    }

    public Xid[] getheuristicCommittedXids() {
        return this.m_tmAdmin.getHeurCompletedTxsForState(10);
    }

    public Xid[] getheuristicRolledbackXids() {
        return this.m_tmAdmin.getHeurCompletedTxsForState(11);
    }

    public TransactionDetail[] getcurrentTransactionDetail() {
        int i;
        ApplicationServerTransaction[] liveTxs = this.m_tmAdmin.getCopyOfTransactions();
        GlobalTransaction[] recoveringTransactions = this.m_tmAdmin.getRecoveryManagerAdmin().getCopyOfTransactions();
        TransactionDetail[] txDetail = new TransactionDetail[liveTxs.length + recoveringTransactions.length];
        for (i = 0; i < liveTxs.length; ++i) {
            txDetail[i] = new TransactionDetail(liveTxs[i]);
        }
        while (i < liveTxs.length + recoveringTransactions.length) {
            txDetail[i] = new TransactionDetail(recoveringTransactions[i - liveTxs.length]);
            ++i;
        }
        return txDetail;
    }

    public void settransactionTimeout(int txTimeout) throws InvalidConfigurationException {
        if (txTimeout < 1) {
            throw new InvalidConfigurationException("transaction-timeout must be greater than 0");
        }
        this.m_tmAdmin.setDefaultTransactionTimeout(txTimeout);
        this.m_tmAdmin.getConfig().setTransactionTimeout(txTimeout);
    }

    public int gettransactionTimeout() {
        return this.m_tmAdmin.getConfig().getTransactionTimeout();
    }

    public void setmaxConcurrentTransactions(int maxConncurrentTx) throws InvalidConfigurationException {
        if (maxConncurrentTx < 1 && maxConncurrentTx != -1) {
            throw new InvalidConfigurationException("max-concurrent-transactions must be greater than 0 or equal -1 (for unlimited)");
        }
        this.m_tmAdmin.getConfig().setMaxConcurrentTransactions(maxConncurrentTx);
        this.m_tmAdmin.setMaxConcurrentTransactions(maxConncurrentTx);
    }

    public int getmaxConcurrentTransactions() {
        return this.m_tmAdmin.getMaxConcurrentTransactions();
    }

    public void configureCoordinator(String coordinatorType, String logType, String logLocation, String userName, String password, int retryCount) throws InvalidConfigurationException {
        this.getNonNullConfig().configureCoordinator(coordinatorType, logType, logLocation, userName, password, retryCount);
    }

    public void configureFileLoggingPerformance(int minPoolSize, int maxOpenFiles, int oldFileReleaseSize) throws InvalidConfigurationException {
        this.getNonNullConfig().configureFileLoggingPerformance(minPoolSize, maxOpenFiles, oldFileReleaseSize);
    }

    public void configureDatabaseLoggingPerformance(int batchCreateInterval, int batchStateInterval, int batchPurgeInterval) throws InvalidConfigurationException {
        this.getNonNullConfig().configureDatabaseLoggingPerformance(batchCreateInterval, batchStateInterval, batchPurgeInterval);
    }

    private TransactionManagerConfiguration getNonNullConfig() throws InvalidConfigurationException {
        TransactionManagerConfiguration config = this.m_tmAdmin.getConfig();
        if (config == null) {
            throw new InvalidConfigurationException("transaction-manager.xml config file does not exist or is not specified in server.xml");
        }
        return config;
    }

    public TransactionManagerConfigurationDetail gettransactionManagerConfigurationDetail() throws InvalidConfigurationException {
        return this.m_tmAdmin.getConfig().getTransactionManagerConfigurationDetail();
    }

    public void clearStats() {
        this.m_tmAdmin.getStats().clearStats();
    }

    public void addThresholdEvent(String thresholdStatisticName, int threshold, int repeatNotificationInterval) throws InvalidConfigurationException {
        this.m_tmAdmin.addThresholdEvent(thresholdStatisticName, threshold, repeatNotificationInterval, this.getNotificationBroadcaster());
    }

    public void removeThresholdEvent(String thresholdStatisticName) throws InvalidConfigurationException {
        this.m_tmAdmin.removeThresholdEvent(thresholdStatisticName);
    }

    public void setrecoveryRetryInterval(int seconds) throws InvalidConfigurationException {
        this.m_tmAdmin.getRecoveryManagerAdmin().setrecoveryRetryInterval(seconds);
        this.m_tmAdmin.getConfig().setRecoveryRetryInterval(seconds);
    }

    public int getrecoveryRetryInterval() throws InvalidConfigurationException {
        return this.m_tmAdmin.getRecoveryManagerAdmin().getrecoveryRetryInterval();
    }

    public void abandonRecovery(Xid xid) {
        this.m_tmAdmin.getRecoveryManagerAdmin().abandonRecovery(xid);
    }

    public void abandonRecoveryForType(String type) {
        this.m_tmAdmin.getRecoveryManagerAdmin().abandonRecoveryForType(type);
    }

    public void setAbandonRecoveryTimeForType(String type, int time) throws InvalidConfigurationException, IOException {
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetail = this.m_tmAdmin.getRecoveryManagerAdmin().setAbandonRecoveryTimeForType(type, time);
        this.m_tmAdmin.getConfig().updateRecoveryAbandonmentToConfigXML(recoveryAbandonmentDetail, "setAbandonRecoveryTimeForType");
    }

    public void setAbandonRecoveryTimeForResourceManager(String appName, String jndiLocation, int time) throws InvalidConfigurationException, IOException {
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetail = this.m_tmAdmin.getRecoveryManagerAdmin().setAbandonRecoveryTimeForResourceManager(appName, jndiLocation, time);
        this.m_tmAdmin.getConfig().updateRecoveryAbandonmentToConfigXML(recoveryAbandonmentDetail, "setAbandonRecoveryTimeForResourceManager");
    }

    public void setAbandonRecoveryCountForType(String type, int count) throws InvalidConfigurationException, IOException {
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetail = this.m_tmAdmin.getRecoveryManagerAdmin().setAbandonRecoveryCountForType(type, count);
        this.m_tmAdmin.getConfig().updateRecoveryAbandonmentToConfigXML(recoveryAbandonmentDetail, "setAbandonRecoveryCountForType");
    }

    public void setAbandonRecoveryCountForResourceManager(String appName, String jndiLocation, int count) throws InvalidConfigurationException, IOException {
        RecoveryAbandonmentDetail[] recoveryAbandonmentDetail = this.m_tmAdmin.getRecoveryManagerAdmin().setAbandonRecoveryCountForResourceManager(appName, jndiLocation, count);
        this.m_tmAdmin.getConfig().updateRecoveryAbandonmentToConfigXML(recoveryAbandonmentDetail, "setAbandonRecoveryCountForResourceManager");
    }

    public void fireEvent(Notification notification) {
        super.fireEvent(notification);
    }

    public final void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        try {
            this.m_tmAdmin.getConfig().store();
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public final boolean geteventProvider() {
        return true;
    }

    public boolean getstatisticsProvider() {
        return true;
    }

    public Stats getstats() {
        DMSStatistic[] stats = new DMSStatistic[ApplicationServerTransactionStats.JTA_STAT_NAMES.length + DMSEvent.JTA_STAT_NAMES.length];
        this.createStatsForNames(0, ApplicationServerTransactionStats.JTA_STAT_NAMES, stats);
        this.createStatsForNames(ApplicationServerTransactionStats.JTA_STAT_NAMES.length, DMSEvent.JTA_STAT_NAMES, stats);
        return new JTAStatsImpl(stats);
    }

    private void createStatsForNames(int startingPointInArray, String[] jtaStatNames, DMSStatistic[] stats) {
        for (int i = 0; i < jtaStatNames.length; ++i) {
            String localizedMessage = this.getLocalizedMessage("jtaresource_" + ApplicationServerTransactionStats.jsr77ToDMSStatNameConvention(jtaStatNames[i]));
            DMSMetric dmsMetric = new DMSMetric("/oc4j/JTAResource/" + jtaStatNames[i], jtaStatNames[i], localizedMessage, jtaStatNames[i].indexOf("Count") != -1 ? "COUNT" : "MILLISECONDS");
            stats[startingPointInArray + i] = jtaStatNames[i].indexOf("Count") != -1 ? new DMSCountStatistic(dmsMetric) : new DMSTimeStatistic(dmsMetric);
        }
    }
}

