/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.io.StringWriter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.management.mbeans.J2EEResourceBase;
import oracle.oc4j.admin.management.mbeans.JNDIResourceMBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class JNDIResource
extends J2EEResourceBase
implements JNDIResourceMBean {
    private static final String CONTEXT_CLASS_NAME = Context.class.getName();
    private static final String SCHEMA_NAMESPACE_LOCATION = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SCHEMA_NAME = "oc4j-jndi-bindings-10_0.xsd";
    private static final String SCHEMA_LOCATION = "http://xmlns.oracle.com/oracleas/schema/oc4j-jndi-bindings-10_0.xsd";
    private static Logger m_logger = TraceLogger.getLogger(JNDIResource.class);
    private Context applicationContext_ = null;

    public JNDIResource(String applicationName, Context applicationContext) {
        super(applicationName);
        super.setBaseObjectName(":j2eeType=JNDIResource,name=" + this.getQuotedName() + ",J2EEServer=" + this.getJ2eeServerName() + ",applicationName=" + applicationName);
        this.applicationContext_ = applicationContext;
        this.setupMetaData();
    }

    public JNDIResource(Locale locale) {
        super(locale);
        this.setupMetaData();
    }

    public String getBindingsAsString() {
        StringBuffer strToReturn = null;
        try {
            strToReturn = new StringBuffer();
            this.buildJNDITreeAsString(this.applicationContext_, strToReturn);
        }
        catch (NamingException e) {
            m_logger.log(Level.FINE, "Exception in building bindings string", e);
            return null;
        }
        return strToReturn.toString();
    }

    public String getBindingsAsXMLString() {
        try {
            String result = this.buildJNDITreeAsXML(this.applicationContext_);
            return result;
        }
        catch (ParserConfigurationException e) {
            m_logger.log(Level.FINE, "Exception in building XML bindings", e);
            return null;
        }
        catch (TransformerException e) {
            m_logger.log(Level.FINE, "Exception in building XML bindings", e);
            return null;
        }
    }

    private void setupMetaData() {
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getBindingsAsString", this.getLocalizedMessage("jndiresource_getBindingsAsString"), new MBeanParameterInfo[0], "java.lang.String", 0));
        this.addModelMBeanOperationInfo(new ModelMBeanOperationInfo("getBindingsAsXMLString", this.getLocalizedMessage("jndiresource_getBindingsAsXMLString"), new MBeanParameterInfo[]{}, String.class.getName(), 0));
    }

    private void buildJNDITreeAsString(Context context, StringBuffer strToReturn) throws NamingException {
        this.buildJNDITreeRecursive(context, strToReturn, 0);
    }

    private void buildJNDITreeRecursive(Context context, StringBuffer strToReturn, int indentationCount) throws NamingException {
        NamingEnumeration<NameClassPair> enum5 = context.list("");
        String tabIndent = "";
        for (int i = 0; i < indentationCount; ++i) {
            tabIndent = tabIndent + "\t";
        }
        while (enum5.hasMore()) {
            NameClassPair binding = enum5.next();
            if (binding.getClassName().equals(CONTEXT_CLASS_NAME)) {
                strToReturn.append(tabIndent + binding.toString() + "\n");
                if (binding.getName().length() <= 0) continue;
                try {
                    Context subContext = (Context)context.lookup(binding.getName());
                    this.buildJNDITreeRecursive(subContext, strToReturn, indentationCount + 1);
                }
                catch (NamingException e) {
                    m_logger.log(Level.FINE, "Exception thrown from subContext lookup, skipping this context", e);
                }
                continue;
            }
            strToReturn.append(tabIndent + binding.toString() + "\n");
        }
    }

    private String buildJNDITreeAsXML(Context context) throws ParserConfigurationException, TransformerException {
        String strToReturn = null;
        DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = buildFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element rootElement = document.createElement("oc4j-jndi-bindings");
        document.appendChild(rootElement);
        Element applicationElement = document.createElement("application");
        applicationElement.setAttribute("name", this.getName());
        rootElement.appendChild(applicationElement);
        rootElement.setAttribute("xmlns:xsi", SCHEMA_NAMESPACE_LOCATION);
        rootElement.setAttribute("xsi:noNamespaceSchemaLocation", SCHEMA_LOCATION);
        try {
            this.buildJNDITreeAsXMLRecursive(context, document, applicationElement);
            strToReturn = JNDIResource.buildStringfromDOM(document);
        }
        catch (NamingException e) {
            strToReturn = null;
        }
        return strToReturn;
    }

    private static String buildStringfromDOM(Document document) throws TransformerException {
        StringWriter writer = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(document), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    private void buildJNDITreeAsXMLRecursive(Context context, Document document, Element rootElement) throws NamingException {
        NamingEnumeration<Binding> enum5 = context.listBindings("");
        while (enum5.hasMore()) {
            Text classNameText;
            Binding binding = enum5.next();
            if (binding.getName().length() <= 0) continue;
            Element bindingElement = document.createElement("jndi-binding");
            Element name = document.createElement("name");
            Text nameText = document.createTextNode(binding.getName());
            Element className = document.createElement("class-name");
            rootElement.appendChild(bindingElement);
            bindingElement.appendChild(name);
            name.appendChild(nameText);
            bindingElement.appendChild(className);
            Object boundObj = binding.getObject();
            if (boundObj instanceof Context) {
                classNameText = document.createTextNode(CONTEXT_CLASS_NAME);
                className.appendChild(classNameText);
                try {
                    Context subContext = (Context)context.lookup(binding.getName());
                    this.buildJNDITreeAsXMLRecursive(subContext, document, bindingElement);
                }
                catch (NamingException e) {
                    m_logger.log(Level.FINE, "Exception thrown from  subcontext.listBindings(), skipping this subContext", e);
                }
                continue;
            }
            classNameText = document.createTextNode(binding.getClassName());
            className.appendChild(classNameText);
            if (boundObj.toString() == null) continue;
            Element objectInfo = document.createElement("object-info");
            Text objectInfoText = document.createTextNode(boundObj.toString());
            bindingElement.appendChild(objectInfo);
            objectInfo.appendChild(objectInfoText);
        }
    }
}

