/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.MessageLocalizationHelper;
import oracle.oc4j.admin.jmx.shared.deploy.NotificationUserData;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.management.mbeans.J2EEServerDependentObjectBase;
import oracle.oc4j.admin.management.mbeans.J2EEStateManageableObject;
import oracle.oc4j.admin.management.mbeans.StateManageable;

public abstract class J2EEStateManageableObjectBase
extends J2EEServerDependentObjectBase
implements J2EEStateManageableObject {
    private static Logger logger_ = TraceLogger.getLogger(J2EEStateManageableObjectBase.class);
    private StateManageable callBackIf_ = null;

    protected J2EEStateManageableObjectBase(StateManageable callBack, String domain, String j2eeSeverName) {
        super(domain, j2eeSeverName);
        this.callBackIf_ = callBack;
        this.init();
    }

    protected J2EEStateManageableObjectBase(StateManageable callBack) {
        this.callBackIf_ = callBack;
        this.init();
    }

    protected J2EEStateManageableObjectBase(Locale loc) {
        super(loc);
        this.init();
    }

    private StateManageable getStateManageableCallBackInterface() {
        return this.callBackIf_;
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("server", "java.lang.String", this.getLocalizedMessage("j2eestatemanageableobjectbase_server"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("Server", "javax.management.ObjectName", this.getLocalizedMessage("j2eestatemanageableobjectbase_server"), true, false, false));
        this.addStateManageableInfo();
    }

    public final ObjectName getServer() throws MalformedObjectNameException {
        return ObjectNameFactory.create((String)(this.getDomain() + ":j2eeType=J2EEServer,name=" + this.getJ2eeServerName()));
    }

    public final String getserver() throws MalformedObjectNameException {
        return this.getServer().toString();
    }

    public boolean getstateManageable() {
        return true;
    }

    public boolean geteventProvider() {
        return true;
    }

    public void start() {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                try {
                    notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block9;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getStateManageableCallBackInterface().start();
                try {
                    notification = new Notification("j2ee.state.running", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_start") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable t) {
                try {
                    Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_start") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification2.setUserData(userData);
                    this.fireEvent(notification2);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void stop(Map params) {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                try {
                    notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block9;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getStateManageableCallBackInterface().stop(params);
                try {
                    notification = new Notification("j2ee.state.stopped", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable t) {
                try {
                    Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification2.setUserData(userData);
                    this.fireEvent(notification2);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void stop() {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                try {
                    notification = new Notification("j2ee.state.stopping", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_stopping") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block9;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getStateManageableCallBackInterface().stop();
                try {
                    notification = new Notification("j2ee.state.stopped", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable t) {
                try {
                    Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_stop") + this.getobjectName());
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification2.setUserData(userData);
                    this.fireEvent(notification2);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public void startRecursive() {
        block10: {
            Notification notification;
            MessageLocalizationHelper locHelp;
            block9: {
                ResourceBundle bundle = this.getResourceBundle();
                locHelp = new MessageLocalizationHelper(bundle, this.getLocale());
                try {
                    notification = new Notification("j2ee.state.starting", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_starting_rec") + this.getobjectName());
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block9;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                this.getStateManageableCallBackInterface().startRecursive();
                try {
                    notification = new Notification("j2ee.state.running", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_success_startrec", this.getobjectName()));
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), 100);
                    notification.setUserData(userData);
                    this.fireEvent(notification);
                }
                catch (MalformedObjectNameException e) {
                    if (logger_.isLoggable(Level.SEVERE)) {
                        logger_.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            catch (Throwable t) {
                try {
                    Notification notification2 = new Notification("j2ee.state.failed", this.getObjectName(), 0L, new Date().getTime(), locHelp.getLocalizedMessage("statemanageable_error_startrec", this.getobjectName()));
                    NotificationUserData userData = new NotificationUserData(this.getObjectName(), t);
                    notification2.setUserData(userData);
                    this.fireEvent(notification2);
                }
                catch (MalformedObjectNameException e) {
                    if (!logger_.isLoggable(Level.SEVERE)) break block10;
                    logger_.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public long getstartTime() {
        return this.getStateManageableCallBackInterface().getstartTime();
    }

    public int getstate() {
        return this.getStateManageableCallBackInterface().getstate();
    }
}

