/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.management.mbeans;

import java.util.Locale;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXException;
import oracle.oc4j.admin.management.mbeans.J2EEDomainMBean;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;

public class J2EEDomain
extends J2EEManagedObjectBase
implements J2EEDomainMBean {
    private static final String J2EEServerObjectNamePattern_ = "*:j2eeType=J2EEServer,*";

    public J2EEDomain(String domainName) {
        super(domainName);
        this.setBaseObjectName(":j2eeType=J2EEDomain,name=" + this.getDomain());
        this.init();
    }

    public J2EEDomain() {
        super("oc4j");
        this.setBaseObjectName(":j2eeType=J2EEDomain,name=" + this.getDomain());
        this.init();
    }

    public J2EEDomain(Locale loc) {
        super(loc);
        this.init();
    }

    public ObjectName[] getServers() throws JMXException {
        return this.getObjectNameForPattern(J2EEServerObjectNamePattern_);
    }

    public String[] getservers() throws JMXException {
        ObjectName[] objs = this.getServers();
        if (objs == null) {
            return null;
        }
        String[] res = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            res[i] = objs[i].toString();
        }
        return res;
    }

    private void init() {
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("servers", "[Ljava.lang.String;", this.getLocalizedMessage("j2eedomain_servers"), true, false, false));
        this.addModelMBeanAttributeInfo(new ModelMBeanAttributeInfo("Servers", "[Ljavax.management.ObjectName;", this.getLocalizedMessage("j2eedomain_servers"), true, false, false));
    }

    public String getDescription() {
        return this.getLocalizedMessage("j2eedomain_description");
    }
}

