/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans.deploy;

import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.jmx.server.mbeans.deploy.DeployerMBeanImplBase;

public abstract class UnDeployerRunnable
implements Runnable {
    private static Logger logger_ = TraceLogger.getLogger(UnDeployerRunnable.class);
    protected DeployerMBeanImplBase _deployerMBean;
    protected String _deployName;
    protected boolean _isRar;
    protected ObjectName[] _targets;
    private ContextContainer _contextContainer;

    public UnDeployerRunnable(DeployerMBeanImplBase deployerMBean, String deployName, boolean isRar, ObjectName[] targets) {
        this._deployerMBean = deployerMBean;
        this._deployName = deployName;
        this._isRar = isRar;
        this._targets = targets;
        this._contextContainer = ThreadState.getCurrentState().getContextContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        String threadName = thread.getName();
        try {
            thread.setName("UnDeployerRunnable Thread for " + this._deployName);
            if (this._contextContainer != null) {
                ThreadState.getCurrentState().contextContainer = this._contextContainer;
            }
            this.doRun();
        }
        catch (Exception e) {
            if (logger_.isLoggable(Level.WARNING)) {
                logger_.log(Level.WARNING, e.getMessage(), e);
            }
        }
        finally {
            thread.setName(threadName);
            ThreadState.getCurrentState().contextContainer = null;
        }
    }

    protected abstract void doRun() throws DeployerException;
}

