/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.server.mbeans;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.PersistentMBean;
import javax.management.RuntimeOperationsException;
import javax.management.j2ee.statistics.Stats;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanNotificationBroadcaster;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import oracle.oc4j.admin.jmx.model.ModelMBeanProvider;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.server.mbeans.DumpEventListener;
import oracle.oc4j.admin.jmx.server.mbeans.TestListener;
import oracle.oc4j.admin.jmx.server.mbeans.TesterMBean;
import oracle.oc4j.admin.jmx.server.mbeans.model.ModelMBeanFactory;
import oracle.oc4j.admin.jmx.shared.exceptions.JMXRuntimeException;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.admin.jmx.web.HtmlGenerator;
import oracle.oc4j.admin.jmx.web.ServletLocalizationHelper;
import oracle.oc4j.admin.management.mbeans.J2EEApplication;
import oracle.oc4j.admin.management.mbeans.J2EEManagedObjectBase;
import oracle.oc4j.admin.management.mbeans.WebModule;

public class Tester
implements TesterMBean,
ModelMBeanProvider,
PersistentMBean {
    public static ObjectName MBeanTesterName = null;
    public static ObjectName OC4JMBeanTesterName = null;
    private Map listeners_ = new Hashtable();
    ModelMBeanNotificationBroadcaster broadcaster_ = null;
    private int count_ = 0;
    private int threshold_ = 0;
    TestListener listener_ = null;
    String randomAttribute_ = "random value";
    private Properties properties_ = null;
    private Vector vector_ = null;
    private TreeSet treeSet_ = null;
    List list_ = null;
    private String attributeWithMbeanReStart_ = "Init value";
    private int state_ = 1;
    private static int store_;

    public String getrandomAttribute() {
        return this.randomAttribute_;
    }

    public void setrandomAttribute(String val) {
        this.randomAttribute_ = val;
    }

    public void registerListener(String name) {
        try {
            ObjectName obj = new ObjectName(name);
            DumpEventListener listener = new DumpEventListener();
            MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
            this.listeners_.put(obj, listener);
            mbeanServ.addNotificationListener(obj, listener, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void unregisterListener(String name) {
        try {
            ObjectName obj = new ObjectName(name);
            DumpEventListener listener = (DumpEventListener)this.listeners_.get(obj);
            MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
            if (listener != null) {
                mbeanServ.removeNotificationListener(obj, listener);
                this.listeners_.remove(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public String[] listMBeansWithListener() {
        String[] ret = new String[this.listeners_.size()];
        Iterator iter = this.listeners_.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            ret[i++] = iter.next().toString();
        }
        return ret;
    }

    public void fireEvent() {
        Notification event = new Notification("fireEvent.called", (Object)MBeanTesterName, 0L, "Method fireEvent called");
        try {
            this.broadcaster_.sendNotification(event);
        }
        catch (Exception e) {
            throw new JMXRuntimeException((Throwable)e);
        }
    }

    public void beginAttributeChangeNotification(String attName) throws Exception {
        System.out.println("attName: " + attName);
        try {
            Notification refEvent = new Notification("jmx.attribute.change", (Object)OC4JMBeanTesterName, 0L, "AttributeChangeDetected");
            this.listener_ = new TestListener();
            this.broadcaster_.addAttributeChangeNotificationListener(this.listener_, attName, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int endAttributeChangeNotification(String attName) throws Exception {
        this.broadcaster_.removeAttributeChangeNotificationListener(this.listener_, attName);
        Iterator events = this.listener_.getEvents().iterator();
        while (events.hasNext()) {
            System.out.println(events.next());
        }
        return this.listener_.getEventCount();
    }

    public void setCount(Integer count) {
        this.count_ = count;
    }

    public Integer getCount() {
        return new Integer(this.count_);
    }

    public void setThreshold(Integer threshold) {
        this.threshold_ = threshold;
    }

    public Integer getThreshold() {
        return new Integer(this.threshold_);
    }

    public Integer increment(Integer howMuch) {
        int incr = howMuch;
        int newCount = this.count_ + incr;
        if (newCount >= this.threshold_) {
            Notification event = new Notification("threshold.upper.reached", (Object)MBeanTesterName, 0L, "Count threshold upper limit reached");
            try {
                this.broadcaster_.sendNotification(event);
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e);
            }
            this.count_ = this.threshold_;
        } else {
            this.count_ = newCount;
        }
        return new Integer(this.count_);
    }

    public Integer increment() {
        return this.increment(new Integer(1));
    }

    public Integer decrement(Integer howMuch) {
        int dcr = howMuch;
        int newCount = this.count_ - dcr;
        if (newCount <= 0) {
            Notification event = new Notification("threshold.lower.reached", (Object)MBeanTesterName, 0L, "Count threshold lower limit reached");
            try {
                this.broadcaster_.sendNotification(event);
            }
            catch (Exception e) {
                throw new JMXRuntimeException((Throwable)e);
            }
            this.count_ = 0;
        } else {
            this.count_ = newCount;
        }
        return new Integer(this.count_);
    }

    public Integer decrement() {
        return this.decrement(new Integer(1));
    }

    public Vector checkSerialization(Hashtable hashtable, String s, Integer i) {
        Vector<Object> v = new Vector<Object>();
        v.add(hashtable);
        v.add(s);
        v.add(i);
        return v;
    }

    public void throwException() throws ParseException {
        throw new ParseException("TEST EXCEPTION", 10);
    }

    public void throwRuntimeException() {
        throw new RuntimeException("TEST EXCEPTION");
    }

    public void registerApplication(String appName) throws Exception {
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        J2EEApplication app = new J2EEApplication(null, appName);
        mbeanServ.registerMBean(ModelMBeanFactory.getModelMBean(app), app.getObjectName());
    }

    public void unregisterApplication(String appName) throws Exception {
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        ObjectName app = ObjectNameFactory.create((String)("oc4j:j2eeType=J2EEApplication,name=" + appName + ",J2EEServer=" + "standalone"));
        mbeanServ.unregisterMBean(app);
    }

    public void registerWebModule(String moduleName, String appName) throws Exception {
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        WebModule module = new WebModule(null, appName, moduleName);
        mbeanServ.registerMBean(module, module.getObjectName());
    }

    public void unregisterWebModule(String moduleName, String appName) throws Exception {
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        ObjectName mod = ObjectNameFactory.create((String)("oc4j:j2eeType=WebModule,name=" + moduleName + ",J2EEApplication=" + appName + ",J2EEServer=" + "standalone"));
        mbeanServ.unregisterMBean(mod);
    }

    public final Set getModelMBeanAttributeInfos() {
        HashSet<ModelMBeanAttributeInfo> attributes = new HashSet<ModelMBeanAttributeInfo>();
        attributes.add(new ModelMBeanAttributeInfo("Count", "java.lang.Integer", "A counter value that is bound by the Threshold value", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("state", "int", "JSR-77 State Management state attribute", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("store", "int", "Track how many time store method is called", true, false, false));
        ModelMBeanAttributeInfo mmpersistentAttribute = new ModelMBeanAttributeInfo("persistentAttribute", "java.lang.String", "attribute that trigger persistence", false, true, false);
        Descriptor persDesc = mmpersistentAttribute.getDescriptor();
        persDesc.setField("persistPolicy", "OnUpdate");
        mmpersistentAttribute.setDescriptor(persDesc);
        attributes.add(mmpersistentAttribute);
        ModelMBeanAttributeInfo mmpersistentAttribute1 = new ModelMBeanAttributeInfo("persistentAttributeNoMoreOftenThan", "java.lang.String", "attribute that trigger persistence (NoMoreOftenThan)", false, true, false);
        Descriptor persDesc1 = mmpersistentAttribute1.getDescriptor();
        persDesc1.setField("persistPolicy", "NoMoreOftenThan");
        persDesc1.setField("persistPeriod", "1");
        mmpersistentAttribute1.setDescriptor(persDesc1);
        attributes.add(mmpersistentAttribute1);
        ModelMBeanAttributeInfo mmpersistentAttribute2 = new ModelMBeanAttributeInfo("persistentAttributeNoMoreOftenThanLong", "java.lang.String", "attribute that trigger persistence (NoMoreOftenThan)", false, true, false);
        Descriptor persDesc2 = mmpersistentAttribute2.getDescriptor();
        persDesc2.setField("persistPolicy", "NoMoreOftenThan");
        persDesc2.setField("persistPeriod", "3600");
        mmpersistentAttribute2.setDescriptor(persDesc2);
        attributes.add(mmpersistentAttribute2);
        ModelMBeanAttributeInfo mmpersistentAttribute3 = new ModelMBeanAttributeInfo("persistentAttributeOnTimer", "java.lang.String", "attribute that trigger persistence (OnTimer)", false, true, false);
        Descriptor persDesc3 = mmpersistentAttribute3.getDescriptor();
        persDesc3.setField("persistPolicy", "OnTimer");
        persDesc3.setField("persistPeriod", "1");
        mmpersistentAttribute3.setDescriptor(persDesc3);
        attributes.add(mmpersistentAttribute3);
        ModelMBeanAttributeInfo mmpersistentAttribute4 = new ModelMBeanAttributeInfo("persistentAttributeOnUnregister", "java.lang.String", "attribute that trigger persistence (OnUnregister)", false, true, false);
        Descriptor persDesc4 = mmpersistentAttribute4.getDescriptor();
        persDesc4.setField("extendedPersistPolicy", "OnUnregister");
        mmpersistentAttribute4.setDescriptor(persDesc4);
        attributes.add(mmpersistentAttribute4);
        ModelMBeanAttributeInfo mmainf = new ModelMBeanAttributeInfo("attributeWithMbeanReStart", "java.lang.String", "requires MBEAN_RESTART", true, true, false);
        Descriptor desc = mmainf.getDescriptor();
        desc.setField("requireRestart", "mbeanRestart");
        mmainf.setDescriptor(desc);
        attributes.add(mmainf);
        attributes.add(new ModelMBeanAttributeInfo("randomAttribute", "java.lang.String", "A random String attribute", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("Threshold", "java.lang.Integer", "The upper bound for the Count attribute", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("Locale", "java.util.Locale", "The active locale for this request", true, false, false));
        attributes.add(new ModelMBeanAttributeInfo("Working", Boolean.TYPE.getName(), "Working attribute implemented as isWorking method", true, false, true));
        attributes.add(new ModelMBeanAttributeInfo("Properties", "java.util.Properties", "Properties attribute is type of java.util.Properties", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("Vector", "java.util.Vector", "Vector attribute is type of java.util.Vector", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("TreeSet", "java.util.TreeSet", "TreeSet attribute is type of java.util.TreeSet", true, true, false));
        attributes.add(new ModelMBeanAttributeInfo("overloaded", "java.util.List", "An overloaded attribute", true, true, false));
        return attributes;
    }

    public final Set getModelMBeanOperationInfos() {
        HashSet<ModelMBeanOperationInfo> operations = new HashSet<ModelMBeanOperationInfo>();
        operations.add(new ModelMBeanOperationInfo("fireEvent", "Fires an event whose type is fireEvent.called", null, "void", 2));
        ModelMBeanOperationInfo operInfoPers = new ModelMBeanOperationInfo("persistentOperation", "This operation triggers persitence", null, "void", 1);
        Descriptor descPers = operInfoPers.getDescriptor();
        descPers.setField("persistPolicy", "OnUpdate");
        operInfoPers.setDescriptor(descPers);
        operations.add(operInfoPers);
        ModelMBeanOperationInfo operInfoPers1 = new ModelMBeanOperationInfo("persistentOperationNoMoreOftenThan", "This operation triggers persitence (NoMoreOftenThan)", null, "void", 1);
        Descriptor descPers1 = operInfoPers1.getDescriptor();
        descPers1.setField("persistPolicy", "NoMoreOftenThan");
        descPers1.setField("persistPeriod", "1");
        operInfoPers1.setDescriptor(descPers1);
        operations.add(operInfoPers1);
        ModelMBeanOperationInfo operInfoPers2 = new ModelMBeanOperationInfo("persistentOperationNoMoreOftenThanLong", "This operation triggers persitence (NoMoreOftenThan)", null, "void", 1);
        Descriptor descPers2 = operInfoPers2.getDescriptor();
        descPers2.setField("persistPolicy", "NoMoreOftenThan");
        descPers2.setField("persistPeriod", "3600");
        operInfoPers2.setDescriptor(descPers2);
        operations.add(operInfoPers2);
        ModelMBeanOperationInfo operInfoPers3 = new ModelMBeanOperationInfo("persistentOperationOnTimer", "This operation triggers persitence (OnTimer)", null, "void", 1);
        Descriptor descPers3 = operInfoPers3.getDescriptor();
        descPers3.setField("persistPolicy", "OnTimer");
        descPers3.setField("persistPeriod", "1");
        operInfoPers3.setDescriptor(descPers3);
        operations.add(operInfoPers3);
        ModelMBeanOperationInfo operInfoPers4 = new ModelMBeanOperationInfo("persistentOperationOnUnregister", "This operation triggers persitence (OnUnregister)", null, "void", 1);
        Descriptor descPers4 = operInfoPers4.getDescriptor();
        descPers4.setField("extendedPersistPolicy", "OnUnregister");
        operInfoPers4.setDescriptor(descPers4);
        operations.add(operInfoPers4);
        ModelMBeanOperationInfo operInfo = new ModelMBeanOperationInfo("operationWithMbeanReStart", "requires MBEAN_RESTART", null, "java.lang.String", 1);
        Descriptor desc = operInfo.getDescriptor();
        desc.setField("requireRestart", "mbeanRestart");
        operInfo.setDescriptor(desc);
        operations.add(operInfo);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("properties", "java.util.Properties", "The object used to test how to dealing with complex types")};
        operations.add(new ModelMBeanOperationInfo("testProperties", "The function that takes java.util.Properties as a parameter", params, "void", 1));
        operations.add(new ModelMBeanOperationInfo("getTheLocale", "The active locale for this request", null, "java.util.Locale", 2));
        params[0] = new MBeanParameterInfo("howMuch", "java.lang.Integer", "The value by which the Count attribute is to be incremented");
        operations.add(new ModelMBeanOperationInfo("increment", "Increment the Count attribute by the value passed as parameter", params, "java.lang.Integer", 1));
        operations.add(new ModelMBeanOperationInfo("increment", "Increment the Count attribute by one", null, "java.lang.Integer", 1));
        operations.add(new ModelMBeanOperationInfo("listMBeansWithListener", "List the name of the MBeans for which an instance of DumpEventListener has been created", null, "[Ljava.lang.String;", 0));
        params[0] = new MBeanParameterInfo("howMuch", "java.lang.Integer", "The value by which the Count attribute is to be decremented");
        operations.add(new ModelMBeanOperationInfo("decrement", "Decrement the Count attribute by the value passed as parameter", params, "java.lang.Integer", 1));
        operations.add(new ModelMBeanOperationInfo("decrement", "Decrement the Count attribute by one", null, "java.lang.Integer", 1));
        params[0] = new MBeanParameterInfo("attName", "java.lang.String", "The attribute for which we are monitoring changes");
        operations.add(new ModelMBeanOperationInfo("beginAttributeChangeNotification", "Begin monitoring attribute change", params, "void", 1));
        operations.add(new ModelMBeanOperationInfo("endAttributeChangeNotification", "End monitoring attribute change. Return number of events.", params, "int", 1));
        params[0] = new MBeanParameterInfo("objectName", "java.lang.String", "The target MBean name");
        operations.add(new ModelMBeanOperationInfo("registerListener", "Register an instance of DumpEventListener with the MBean identified in the method parameter", params, "void", 1));
        operations.add(new ModelMBeanOperationInfo("unregisterListener", "Unregister an instance of DumpEventListener with the MBean identified in the method parameter", params, "void", 1));
        MBeanParameterInfo[] params1 = new MBeanParameterInfo[]{new MBeanParameterInfo("hashtable", "java.util.Hashtable", "A complex parameter of type java.util.Hashtable"), new MBeanParameterInfo("s", "java.lang.String", "A String parameter"), new MBeanParameterInfo("i", "java.lang.Integer", "An Integer parameter")};
        operations.add(new ModelMBeanOperationInfo("checkSerialization", "Take and return complex parameters", params1, "java.util.Vector", 1));
        operations.add(new ModelMBeanOperationInfo("throwException", "Throws a ParseException", null, "void", 1));
        operations.add(new ModelMBeanOperationInfo("throwRuntimeException", "Throws a RuntimeException", null, "void", 1));
        params[0] = new MBeanParameterInfo("appName", "java.lang.String", "The name of the application for which to register an MBean");
        operations.add(new ModelMBeanOperationInfo("registerApplication", "Register an application MBean for a fake application", params, "void", 1));
        params[0] = new MBeanParameterInfo("directory", "java.lang.String", "The path to the directory in which the documentation will be generated");
        operations.add(new ModelMBeanOperationInfo("generateDocumentation", "Generate documentation for all the MBeans registered with the MBeanServer", params, "void", 1));
        params[0] = new MBeanParameterInfo("appName", "java.lang.String", "The name of the application for which to unregister an MBean");
        operations.add(new ModelMBeanOperationInfo("unregisterApplication", "Unregister an application MBean for a fake application", params, "void", 1));
        MBeanParameterInfo[] params2 = new MBeanParameterInfo[]{new MBeanParameterInfo("moduleName", "java.lang.String", "The web module name for which to register an MBean"), new MBeanParameterInfo("appName", "java.lang.String", "The application to which the web module belongs")};
        operations.add(new ModelMBeanOperationInfo("registerWebModule", "Register an MBean for a fake web-module", params2, "void", 1));
        params[0] = new MBeanParameterInfo("moduleName", "java.lang.String", "The web module name for which to unregister an MBean");
        operations.add(new ModelMBeanOperationInfo("unregisterWebModule", "Unregister an MBean for a fake web-module", params2, "void", 1));
        params2[0] = new MBeanParameterInfo("input", "oracle.oc4j.admin.jmx.shared.util.DataSink", "DataSink for uploaded data");
        params2[1] = new MBeanParameterInfo("size", "java.lang.Integer", "Size of the uploaded data");
        operations.add(new ModelMBeanOperationInfo("install", "Test for JSR-88 install", params2, "void", 1));
        return operations;
    }

    public final Set getModelMBeanNotificationInfos() {
        HashSet<ModelMBeanNotificationInfo> notifications = new HashSet<ModelMBeanNotificationInfo>();
        String[] notifTypeb = new String[]{"fireEvent.called", "threshold.upper.reached", "threshold.lower.reached"};
        notifications.add(new ModelMBeanNotificationInfo(notifTypeb, "javax.management.Notification", "events triggered by the MBeanTester"));
        return notifications;
    }

    public final Set getModelMBeanConstructorInfos() {
        return null;
    }

    public final Descriptor getDescriptor() {
        return null;
    }

    public final String getDescription() {
        return "A Model MBean used for testing purpose";
    }

    public final void registerModelMBeanNotificationBroadcaster(ModelMBeanNotificationBroadcaster broadcaster) {
        this.broadcaster_ = broadcaster;
    }

    public Locale getLocale() {
        return J2EEManagedObjectBase.getLocaleForCall();
    }

    public Locale getTheLocale() {
        return J2EEManagedObjectBase.getLocaleForCall();
    }

    public final void postDeregister() {
    }

    public final void postRegister(Boolean registrationDone) {
    }

    public final void preDeregister() {
    }

    public final ObjectName preRegister(MBeanServer server, ObjectName name) {
        return name;
    }

    public boolean isWorking() {
        return true;
    }

    public List getoverloaded() {
        return this.list_;
    }

    public void setoverloaded(List l) {
        this.list_ = l;
    }

    public void setoverloaded(ArrayList u) {
        throw new JMXRuntimeException("We called the wrong setter method!!!");
    }

    public void addNotificationListenerCallBack(NotificationListener listener, NotificationFilter filter, Object handback, long listenerCount) {
    }

    public void removeNotificationListenerCallBack(NotificationListener listener, NotificationFilter filter, Object handback, long listenerCount) {
    }

    public void generateDocumentation(String directory) throws IOException {
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new FileNotFoundException("Directory: " + dir + " does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir.toString() + " is not a directory");
        }
        if (!dir.canWrite()) {
            throw new IOException("Cannot write to: " + dir);
        }
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        try {
            Set<ObjectName> mbeans = mbeanServ.queryNames(null, null);
            Iterator<ObjectName> iter = mbeans.iterator();
            HashSet<String> j2eeTypes = new HashSet<String>();
            while (iter.hasNext()) {
                ObjectName mbean = iter.next();
                String j2eeType = mbean.getKeyProperty("j2eeType");
                if (j2eeType == null || j2eeTypes.contains(j2eeType)) continue;
                try {
                    j2eeTypes.add(j2eeType);
                    MBeanInfo mbeanInfo = this.getMBeanInfo(mbean);
                    Stats stats = this.getStats(mbean);
                    ServletLocalizationHelper locHelper = new ServletLocalizationHelper("oracle.oc4j.admin.Messages", J2EEManagedObjectBase.getLocaleForCall());
                    HtmlGenerator gen = new HtmlGenerator(mbean.getDomain(), locHelper);
                    gen.addCompleteMBeanDescriptionPage(mbeanInfo, mbean.toString(), stats);
                    File f = new File(dir, j2eeType + ".html");
                    FileWriter fout = new FileWriter(f);
                    fout.write(gen.getContent());
                    fout.close();
                }
                catch (IOException ioe) {
                    throw (IOException)ioe.fillInStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ServletLocalizationHelper locHelper = new ServletLocalizationHelper("oracle.oc4j.admin.Messages", J2EEManagedObjectBase.getLocaleForCall());
            HtmlGenerator gen = new HtmlGenerator("oc4j", locHelper);
            gen.generateCompleteMBeanDescriptionPageIndex(j2eeTypes);
            File f = new File(dir, "index.html");
            FileWriter fout = new FileWriter(f);
            fout.write(gen.getContent());
            fout.close();
        }
        catch (IOException oe) {
            throw (IOException)oe.fillInStackTrace();
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private MBeanInfo getMBeanInfo(ObjectName objName) throws Exception {
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        if (!"ias".equalsIgnoreCase(objName.getDomain())) {
            String[] paramTypes = new String[]{"java.util.Locale"};
            Object[] params = new Object[]{J2EEManagedObjectBase.getLocaleForCall()};
            MBeanInfo info = null;
            try {
                info = (MBeanInfo)mbeanServ.invoke(objName, "getMBeanInfo", params, paramTypes);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return info == null ? mbeanServ.getMBeanInfo(objName) : info;
        }
        return mbeanServ.getMBeanInfo(objName);
    }

    private Stats getStats(ObjectName mbean) throws Exception {
        Boolean hasStats = null;
        MBeanServer mbeanServ = Oc4jMBeanServerFactory.getMBeanServer();
        MBeanInfo info = this.getMBeanInfo(mbean);
        MBeanAttributeInfo[] attrsInf = info.getAttributes();
        for (int i = 0; i < attrsInf.length; ++i) {
            if (!"statisticsProvider".equals(attrsInf[i].getName())) continue;
            hasStats = (Boolean)mbeanServ.getAttribute(mbean, "statisticsProvider");
        }
        if (hasStats == null) {
            return null;
        }
        if (hasStats.booleanValue()) {
            return (Stats)mbeanServ.getAttribute(mbean, "stats");
        }
        return null;
    }

    public void setProperties(Properties properties) {
        this.properties_ = properties;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public void setVector(Vector vector) {
        this.vector_ = vector;
    }

    public Vector getVector() {
        return this.vector_;
    }

    public void setTreeSet(TreeSet treeSet) {
        this.treeSet_ = treeSet;
    }

    public TreeSet getTreeSet() {
        return this.treeSet_;
    }

    public void testProperties(Properties properties) {
    }

    public String getattributeWithMbeanReStart() {
        return this.attributeWithMbeanReStart_;
    }

    public void setattributeWithMbeanReStart(String val) {
        this.attributeWithMbeanReStart_ = val;
    }

    public String operationWithMbeanReStart() {
        return "OK";
    }

    public int getstate() {
        return this.state_;
    }

    public void setstate(int state) {
        this.state_ = state;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        System.out.println("Storing Tester MBean state count: " + ++store_ + " instance: " + this);
    }

    public int getstore() {
        return store_;
    }

    public void persistentOperation() {
    }

    public void setpersistentAttribute(String param) {
    }

    public void persistentOperationNoMoreOftenThan() {
    }

    public void setpersistentAttributeNoMoreOftenThan(String param) {
    }

    public void persistentOperationNoMoreOftenThanLong() {
    }

    public void setpersistentAttributeNoMoreOftenThanLong(String param) {
    }

    public void persistentOperationOnTimer() {
    }

    public void setpersistentAttributeOnTimer(String param) {
    }

    public void persistentOperationOnUnregister() {
    }

    public void setpersistentAttributeOnUnregister(String param) {
    }

    public void install(DataSink input, Integer size) throws IOException {
        System.out.println("JSR-88 INSTALL:");
        int sz = size;
        byte[] content = input.getContent();
        System.out.println("CONTENT: " + content.length);
        System.out.println("EXPECTED: " + sz);
        if (sz != content.length) {
            throw new IOException("Content is: " + content.length + " but we expected: " + sz);
        }
    }

    static {
        try {
            MBeanTesterName = new ObjectName(":Test=TesterMBean,J2EEServer=standalone");
            OC4JMBeanTesterName = new ObjectName("oc4j:Test=TesterMBean,J2EEServer=standalone");
        }
        catch (Exception exception) {
            // empty catch block
        }
        store_ = 0;
    }
}

