/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.jmx.jms;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import oracle.oc4j.admin.jmx.jms.MBeanServerConnectionCallerServer;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.jmx.shared.JMSOc4jDomain;
import oracle.oc4j.admin.jmx.shared.JMSRemoteObject;
import oracle.oc4j.admin.jmx.shared.JMSiASDomain;
import oracle.oc4j.admin.jmx.shared.MBeanServerConnectionCaller;

public class JMSMBeanServer
extends Thread {
    private Domain domain_ = null;
    private Logger jmsLogger = Logger.getLogger("oracle.j2ee.jmx.remote.jms");

    public JMSMBeanServer(Domain domain) {
        this.domain_ = domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block35: {
            if (this.jmsLogger.isLoggable(Level.FINE)) {
                this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> JMS MBean Server, run method. BEGIN");
            }
            TopicSubscriber iasTopicSubscriber = null;
            TopicConnection iasTopicConnection = null;
            TopicSession iasTopicSession = null;
            QueueConnection iasQueueConnection = null;
            QueueSession iasQueueSession = null;
            QueueConnection oc4jQueueConnection = null;
            QueueSession oc4jQueueSession = null;
            QueueReceiver oc4jQueueReceiver = null;
            if (this.domain_ instanceof JMSiASDomain) {
                InitialContext ctx = new InitialContext();
                XATopicConnectionFactory topicCF = (XATopicConnectionFactory)ctx.lookup(((JMSiASDomain)this.domain_).getTopicConnectionFactory());
                Topic iasTopic = (Topic)ctx.lookup(((JMSiASDomain)this.domain_).getIASDomainTopic());
                iasTopicConnection = topicCF.createTopicConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                iasTopicSession = iasTopicConnection.createTopicSession(false, 1);
                iasTopicSubscriber = iasTopicSession.createDurableSubscriber(iasTopic, "iasTopic");
                if (iasTopicSubscriber != null && this.jmsLogger.isLoggable(Level.FINE)) {
                    this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Subscribed to topic=" + iasTopicSubscriber.getTopic().getTopicName());
                }
                XAQueueConnectionFactory queueCF = (XAQueueConnectionFactory)ctx.lookup(((JMSiASDomain)this.domain_).getQueueConnectionFactory());
                iasQueueConnection = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                iasQueueSession = iasQueueConnection.createQueueSession(false, 1);
                ctx.close();
                iasTopicConnection.start();
                iasQueueConnection.start();
                while (true) {
                    Message request;
                    if ((request = iasTopicSubscriber.receive(((JMSiASDomain)this.domain_).getMaxMsgWaitTime())) == null || !(request instanceof ObjectMessage)) {
                        continue;
                    }
                    if (this.jmsLogger.isLoggable(Level.FINE)) {
                        this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Received msg id=" + request.getJMSMessageID());
                    }
                    MBeanServerConnectionCaller mbeanServerCaller = (MBeanServerConnectionCaller)((ObjectMessage)request).getObject();
                    MBeanServerConnectionCallerServer mbeanServerMethod = new MBeanServerConnectionCallerServer(mbeanServerCaller.getDomain(), mbeanServerCaller.getMethodName(), mbeanServerCaller.getSignature(), mbeanServerCaller.getArguments(), mbeanServerCaller.getUseLocalVersion(), this.jmsLogger);
                    JMSRemoteObject mbeanServerMethodResult = mbeanServerMethod.localExecute();
                    Queue replyToQueue = (Queue)request.getJMSReplyTo();
                    if (replyToQueue == null) continue;
                    if (this.jmsLogger.isLoggable(Level.FINE)) {
                        this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Sending response to queue=" + replyToQueue.getQueueName());
                    }
                    QueueSender iasQueueSender = iasQueueSession.createSender(replyToQueue);
                    ObjectMessage response = iasQueueSession.createObjectMessage((Serializable)mbeanServerMethodResult);
                    iasQueueSender.send((Message)response);
                    if (!this.jmsLogger.isLoggable(Level.FINE)) continue;
                    this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Sent msg id=" + response.getJMSMessageID());
                }
            }
            if (this.domain_ instanceof JMSOc4jDomain) {
                String selector;
                InitialContext ctx = new InitialContext();
                XAQueueConnectionFactory queueCF = (XAQueueConnectionFactory)ctx.lookup(((JMSOc4jDomain)this.domain_).getQueueConnectionFactory());
                oc4jQueueConnection = queueCF.createQueueConnection(this.domain_.getPrincipal(), this.domain_.getCredential());
                Queue oc4jQueue = (Queue)ctx.lookup(((JMSOc4jDomain)this.domain_).getOc4jDomainQueue());
                oc4jQueueSession = oc4jQueueConnection.createQueueSession(false, 1);
                oc4jQueueReceiver = oc4jQueueSession.createReceiver(oc4jQueue, selector = "OC4JID='" + Integer.toString(((JMSOc4jDomain)this.domain_).getOc4jId(), 10) + "'");
                if (oc4jQueueReceiver != null && this.jmsLogger.isLoggable(Level.FINE)) {
                    this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Listening to queue =" + oc4jQueueReceiver.getQueue().getQueueName() + ", using selector " + selector);
                }
                ctx.close();
                oc4jQueueConnection.start();
                while (true) {
                    Message request;
                    if ((request = oc4jQueueReceiver.receive(((JMSOc4jDomain)this.domain_).getMaxMsgWaitTime())) == null || !(request instanceof ObjectMessage)) {
                        continue;
                    }
                    if (this.jmsLogger.isLoggable(Level.FINE)) {
                        this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Received msg id=" + request.getJMSMessageID());
                    }
                    MBeanServerConnectionCaller mbeanServerCaller = (MBeanServerConnectionCaller)((ObjectMessage)request).getObject();
                    MBeanServerConnectionCallerServer mbeanServerMethod = new MBeanServerConnectionCallerServer(mbeanServerCaller.getDomain(), mbeanServerCaller.getMethodName(), mbeanServerCaller.getSignature(), mbeanServerCaller.getArguments(), mbeanServerCaller.getUseLocalVersion(), this.jmsLogger);
                    JMSRemoteObject mbeanServerMethodResult = mbeanServerMethod.localExecute();
                    Queue replyToQueue = (Queue)request.getJMSReplyTo();
                    if (replyToQueue == null) continue;
                    if (this.jmsLogger.isLoggable(Level.FINE)) {
                        this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Sending response to queue=" + replyToQueue.getQueueName());
                    }
                    QueueSender oc4jQueueSender = oc4jQueueSession.createSender(replyToQueue);
                    ObjectMessage response = oc4jQueueSession.createObjectMessage((Serializable)mbeanServerMethodResult);
                    oc4jQueueSender.send((Message)response);
                    if (!this.jmsLogger.isLoggable(Level.FINE)) continue;
                    this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> Sent msg id=" + response.getJMSMessageID());
                }
            }
            Object var21_32 = null;
            try {
                if (this.domain_ instanceof JMSiASDomain) {
                    iasTopicSubscriber.close();
                    iasTopicSession.close();
                    iasTopicConnection.close();
                    iasQueueSession.close();
                    iasQueueConnection.close();
                } else if (this.domain_ instanceof JMSOc4jDomain) {
                    oc4jQueueReceiver.close();
                    oc4jQueueSession.close();
                    oc4jQueueConnection.close();
                }
            }
            catch (Exception e2) {
                this.jmsLogger.log(Level.WARNING, "JMS Connector: <JMSMBeanServer> Caught Exception " + e2, e2);
            }
            if (this.jmsLogger.isLoggable(Level.FINE)) {
                this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> JMS MBean Server, run method. END");
            }
            break block35;
            {
                catch (Exception e) {
                    this.jmsLogger.log(Level.WARNING, "JMS Connector: <JMSMBeanServer> Caught Exception " + e, e);
                    Object var21_33 = null;
                    try {
                        if (this.domain_ instanceof JMSiASDomain) {
                            iasTopicSubscriber.close();
                            iasTopicSession.close();
                            iasTopicConnection.close();
                            iasQueueSession.close();
                            iasQueueConnection.close();
                        } else if (this.domain_ instanceof JMSOc4jDomain) {
                            oc4jQueueReceiver.close();
                            oc4jQueueSession.close();
                            oc4jQueueConnection.close();
                        }
                    }
                    catch (Exception e2) {
                        this.jmsLogger.log(Level.WARNING, "JMS Connector: <JMSMBeanServer> Caught Exception " + e2, e2);
                    }
                    if (this.jmsLogger.isLoggable(Level.FINE)) {
                        this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> JMS MBean Server, run method. END");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_34 = null;
                try {
                    if (this.domain_ instanceof JMSiASDomain) {
                        iasTopicSubscriber.close();
                        iasTopicSession.close();
                        iasTopicConnection.close();
                        iasQueueSession.close();
                        iasQueueConnection.close();
                    } else if (this.domain_ instanceof JMSOc4jDomain) {
                        oc4jQueueReceiver.close();
                        oc4jQueueSession.close();
                        oc4jQueueConnection.close();
                    }
                }
                catch (Exception e2) {
                    this.jmsLogger.log(Level.WARNING, "JMS Connector: <JMSMBeanServer> Caught Exception " + e2, e2);
                }
                if (this.jmsLogger.isLoggable(Level.FINE)) {
                    this.jmsLogger.log(Level.FINE, "JMS Connector: <JMSMBeanServer> JMS MBean Server, run method. END");
                }
                throw throwable;
            }
        }
    }
}

