/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.util.OC4JRuntimeProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.ias.opmn.optic.OpmnAdmin;
import oracle.ias.opmn.optic.OpticBadConnectException;
import oracle.ias.opmn.optic.OpticBadRequestException;
import oracle.ias.opmn.optic.OpticBadXMLConfigException;
import oracle.j2ee.admin.jmx.JMXStateFactory;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanException;
import oracle.j2ee.admin.jmx.exception.config.ConfigMBeanExceptionHelper;
import oracle.oc4j.admin.internal.OpmnCompCallBack;
import oracle.oc4j.admin.internal.OpmnCompOc4jGroupCallBack;
import oracle.oc4j.admin.internal.OpmnCompOhsCallBack;
import oracle.oc4j.admin.internal.OpmnContentDescriptionHelper;
import oracle.oc4j.admin.internal.OpmnRuntimeHelper;
import oracle.oc4j.admin.internal.OpmnXmlHelper;
import oracle.oc4j.admin.jmx.server.state.JMXStateFactoryImpl;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnCompCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.OpmnConfigCallBackIf;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OpmnConfigCallBack
implements OpmnConfigCallBackIf {
    String name_;
    String opmnFileName_;
    DOMParser parser_ = null;
    XMLDocument xmldoc_ = null;
    Element iasnode_ = null;
    OpmnAdmin opmnAdmin_ = null;
    String oracleHome_ = null;
    String configHome_ = null;
    private static String[] NotiSrvAttrNames = new String[]{"interface"};
    private static final String[][] NotiSrvAttrValues = new String[][]{{"any", "ipv4", "ipv6"}};
    private static String[] NotiSrvNodeNames = new String[]{"ipaddr", "port", "log-file", "ssl", "tune"};
    private static String[][] NotiSrvNodeAttrNames = new String[][]{{"remote", "request"}, {"local", "remote", "request"}, {"path", "level", "rotation-size", "rotation-hour"}, {"enabled", "wallet-file", "wallet-password", "openssl-certfile", "openssl-keyfile", "openssl-password", "openssl-lib"}, {"io-timeout", "io-idle", "timeout"}};
    private static String[] TopologyNodeNames = new String[]{"nodes", "discover", "gateway"};
    static String[] OrderedSubTags = new String[]{"environment", "module-data", "dependencies", "rmd-definitions", "ias-component"};

    public OpmnConfigCallBack(String name, String oracleHome) throws ConfigMBeanException {
        this(name, oracleHome, oracleHome);
    }

    public OpmnConfigCallBack(String name, String oracleHome, String configHome) throws ConfigMBeanException {
        this.name_ = name;
        this.oracleHome_ = oracleHome;
        this.configHome_ = configHome;
        boolean localTest = "true".equals(System.getProperty("opmnmbean.localtest"));
        this.opmnFileName_ = localTest ? "config/opmn.xml" : configHome + File.separator + "opmn" + File.separator + "conf" + File.separator + "opmn.xml";
        this.init();
        JMXStateFactoryImpl.init();
    }

    public OpmnConfigCallBack(String name, String oracleHome, String configHome, String fileName) throws Exception {
        this.name_ = name;
        this.oracleHome_ = oracleHome;
        this.configHome_ = configHome;
        this.opmnFileName_ = fileName;
        this.init();
    }

    String getXmlFileName() {
        return this.opmnFileName_;
    }

    String getOracleHome() {
        return this.oracleHome_;
    }

    String getConfigHome() {
        return this.configHome_;
    }

    public String getname() {
        return this.name_;
    }

    private void initParser() {
        if (this.parser_ != null) {
            return;
        }
        this.parser_ = new DOMParser();
        this.parser_.setPreserveWhitespace(false);
        this.parser_.setValidationMode(0);
        this.parser_.retainCDATASection(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws ConfigMBeanException {
        this.xmldoc_ = null;
        this.initParser();
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(this.opmnFileName_);
                this.parser_.parse((InputStream)fin);
                this.xmldoc_ = this.parser_.getDocument();
                String xmlns = this.xmldoc_.getDocumentElement().getNamespaceURI();
                OpmnXmlHelper.setXmlns(xmlns);
                Element procmgr = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "process-manager", false, this.opmnFileName_);
                this.iasnode_ = OpmnXmlHelper.getFirstChildElement(procmgr, "ias-instance", false, this.opmnFileName_);
            }
            catch (FileNotFoundException fne) {
                throw ConfigMBeanExceptionHelper.getException(101, this.opmnFileName_, JMXStateFactory.getJMXState().getLocale());
            }
            catch (ConfigMBeanException cmbe) {
                throw cmbe;
            }
            catch (Exception e) {
                this.xmldoc_ = null;
                this.iasnode_ = null;
                throw ConfigMBeanExceptionHelper.getException(21, this.opmnFileName_, JMXStateFactory.getJMXState().getLocale());
            }
            Object var5_7 = null;
            if (fin == null) return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (fin == null) throw throwable;
            try {
                fin.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fin.close();
        return;
    }

    public void reloadMBean() throws ConfigMBeanException {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws ConfigMBeanException {
        FileOutputStream fout = null;
        fout = new FileOutputStream(this.opmnFileName_);
        this.xmldoc_.print((OutputStream)fout);
        Object var4_2 = null;
        if (fout == null) return;
        try {
            fout.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                ConfigMBeanExceptionHelper.getException(102, this.opmnFileName_, e.getMessage(), e);
                Object var4_3 = null;
                if (fout == null) return;
                try {
                    fout.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fout == null) throw throwable;
            try {
                fout.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void reloadOPMN() throws ConfigMBeanException {
        if (this.opmnAdmin_ == null) {
            try {
                this.opmnAdmin_ = OC4JRuntimeProperties.getOracleHome() == null ? new OpmnAdmin(this.getOracleHome()) : new OpmnAdmin(OC4JRuntimeProperties.getOracleHome());
            }
            catch (OpticBadXMLConfigException e) {
                throw ConfigMBeanExceptionHelper.getException(21, this.opmnFileName_, (Throwable)e, JMXStateFactory.getJMXState().getLocale());
            }
        }
        try {
            this.opmnAdmin_.reloadOpmnServer();
        }
        catch (OpticBadConnectException e1) {
            throw ConfigMBeanExceptionHelper.getException(90, e1.getMessage(), (Throwable)e1, JMXStateFactory.getJMXState().getLocale());
        }
        catch (OpticBadRequestException e2) {
            throw ConfigMBeanExceptionHelper.getException(90, e2.getMessage(), (Throwable)e2, JMXStateFactory.getJMXState().getLocale());
        }
    }

    public OpmnCompCallBackIf[] getComponents() {
        if (this.iasnode_ == null) {
            return null;
        }
        Element[] nodes = OpmnXmlHelper.getChildElements(this.iasnode_, "ias-component");
        ArrayList<OpmnCompCallBack> compList = new ArrayList<OpmnCompCallBack>();
        for (int i = 0; i < nodes.length; ++i) {
            String type = OpmnCompCallBack.parseComponentType(nodes[i]);
            if ("OpmnCompOc4jGroup".equals(type)) {
                compList.add(new OpmnCompOc4jGroupCallBack(this, nodes[i]));
                continue;
            }
            if (!"OpmnCompOhs".equals(type)) continue;
            compList.add(new OpmnCompOhsCallBack(this, nodes[i]));
        }
        return compList.toArray(new OpmnCompCallBack[compList.size()]);
    }

    public boolean isOc4jGroupAlive(String grpName) {
        return OpmnRuntimeHelper.isOc4jGroupAlive(this.getConfigHome(), grpName);
    }

    public OpmnCompCallBackIf createOc4jGroup(String groupName) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(groupName)) {
            throw ConfigMBeanExceptionHelper.getException(52, groupName);
        }
        Element elem = OpmnXmlHelper.getChildElement(this.iasnode_, "ias-component", "id", groupName);
        if (elem != null) {
            throw ConfigMBeanExceptionHelper.getException(50, groupName);
        }
        elem = OpmnXmlHelper.insertChildElement(this.iasnode_, "ias-component", "id", groupName, null);
        elem.setAttribute("status", "enabled");
        OpmnCompOc4jGroupCallBack callback = new OpmnCompOc4jGroupCallBack(this, elem);
        return callback;
    }

    public void removeOc4jGroup(String groupName) throws ConfigMBeanException {
        if (!OpmnXmlHelper.validateName(groupName)) {
            throw ConfigMBeanExceptionHelper.getException(52, groupName);
        }
        Element elem = OpmnXmlHelper.getChildElement(this.iasnode_, "ias-component", "id", groupName);
        if (elem == null) {
            throw ConfigMBeanExceptionHelper.getException(51, groupName);
        }
        this.iasnode_.removeChild(elem);
    }

    public CompositeData getNotificationServerAttrs() throws ConfigMBeanException {
        return OpmnXmlHelper.getElementAttrs(OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_));
    }

    public String getNotificationServerAttr(String attrName) throws ConfigMBeanException {
        return OpmnXmlHelper.getElementAttr(OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_), attrName, NotiSrvAttrNames);
    }

    public void setNotificationServerAttr(String attrName, String attrValue) throws ConfigMBeanException {
        OpmnXmlHelper.setElementAttr(OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_), attrName, attrValue, NotiSrvAttrNames, NotiSrvAttrValues);
    }

    public void removeNotificationServerAttr(String attrName) throws ConfigMBeanException {
        OpmnXmlHelper.removeElementAttr(OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_), attrName, NotiSrvAttrNames);
    }

    public CompositeData getNotificationServerSettings() throws ConfigMBeanException {
        return OpmnXmlHelper.getChildElementAttrs(OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_), NotiSrvNodeNames);
    }

    public CompositeData getNotificationServerSetting(String name) throws ConfigMBeanException {
        Element notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_);
        int subNodeIdx = OpmnXmlHelper.validateNodeName(name, NotiSrvNodeNames);
        Element subElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem, name, true, this.opmnFileName_);
        if (subElem == null) {
            return null;
        }
        return OpmnXmlHelper.getElementAttrs(subElem);
    }

    public void setNotificationServerSetting(String name, CompositeData data) throws ConfigMBeanException {
        Element notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_);
        int subNodeIdx = OpmnXmlHelper.validateNodeName(name, NotiSrvNodeNames);
        Element subElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem, name, true, this.opmnFileName_);
        if (subElem == null) {
            String[] nodesAfter = OpmnXmlHelper.getNodesAfter(NotiSrvNodeNames, subNodeIdx, "topology");
            subElem = OpmnXmlHelper.insertChildElement(notiSrvElem, name, null, null, nodesAfter);
        }
        OpmnXmlHelper.setElementAttrs(subElem, data, NotiSrvNodeAttrNames[subNodeIdx], null);
    }

    public void removeNotificationServerSetting(String name) throws ConfigMBeanException {
        Element notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_);
        int subNodeIdx = OpmnXmlHelper.validateNodeName(name, NotiSrvNodeNames);
        Element subElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem, name, true, this.opmnFileName_);
        if (subElem != null) {
            notiSrvElem.removeChild(subElem);
        }
    }

    public CompositeData getTopologies() throws ConfigMBeanException {
        Element notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_);
        Element topoElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem, "topology", true, this.opmnFileName_);
        if (topoElem == null) {
            return null;
        }
        NodeList nodeList = topoElem.getChildNodes();
        if (nodeList.getLength() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element node = (Element)nodeList.item(i);
            String name = node.getNodeName();
            String value = node.getAttribute("list");
            String oldValue = (String)map.get(name);
            if (oldValue == null) {
                map.put(name, value);
                continue;
            }
            map.put(name, oldValue + ',' + value);
        }
        if (map.size() <= 0) {
            return null;
        }
        Object[] keys = map.keySet().toArray();
        String[] itemNames = new String[keys.length];
        String[] itemDescs = new String[keys.length];
        OpenType[] itemTypes = new OpenType[keys.length];
        Object[] itemValues = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            itemNames[i] = (String)keys[i];
            itemDescs[i] = OpmnContentDescriptionHelper.getLocalizedDescription("topology.node", itemNames[i]);
            itemTypes[i] = SimpleType.STRING;
            itemValues[i] = map.get(itemNames[i]);
        }
        CompositeDataSupport result = null;
        try {
            CompositeType compositeType = new CompositeType("TopologyNodesType", "Topology settings", itemNames, itemDescs, itemTypes);
            result = new CompositeDataSupport(compositeType, itemNames, itemValues);
        }
        catch (OpenDataException ode) {
            // empty catch block
        }
        return result;
    }

    public String getTopology(String name) throws ConfigMBeanException {
        int subNodeIdx = OpmnXmlHelper.validateNodeName(name, TopologyNodeNames);
        CompositeData topologies = this.getTopologies();
        if (topologies == null) {
            return null;
        }
        String result = null;
        try {
            result = (String)topologies.get(name);
        }
        catch (InvalidKeyException ike) {
            result = null;
        }
        return result;
    }

    public void setTopology(String name, String value, boolean append) throws ConfigMBeanException {
        Element notiSrvElem;
        Element topoElem;
        if (value == null || value.trim().length() == 0 || !OpmnXmlHelper.validateXMLValue(value)) {
            Locale locale = JMXStateFactory.getJMXState().getLocale();
            throw ConfigMBeanExceptionHelper.getException(15, value != null && value.trim().length() == 0 ? ConfigMBeanExceptionHelper.getLocalizedMessage("EmptyString", locale) : value, locale);
        }
        String oldValue = this.getTopology(name);
        if (append) {
            value = (oldValue == null ? "" : oldValue.trim() + ",") + value.trim();
        }
        if ((topoElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_), "topology", true, this.opmnFileName_)) == null) {
            topoElem = OpmnXmlHelper.insertChildElement(notiSrvElem, "topology", null, null, null);
        } else if (oldValue != null) {
            OpmnXmlHelper.removeSubElement(topoElem, name, TopologyNodeNames);
        }
        int subNodeIdx = OpmnXmlHelper.searchStringArray(name, TopologyNodeNames);
        String[] nodesAfter = OpmnXmlHelper.getNodesAfter(TopologyNodeNames, subNodeIdx, null);
        OpmnXmlHelper.insertChildElement(topoElem, name, "list", value, nodesAfter);
    }

    public void removeTopology(String name) throws ConfigMBeanException {
        Element notiSrvElem = OpmnXmlHelper.getFirstChildElement(this.xmldoc_.getDocumentElement(), "notification-server", false, this.opmnFileName_);
        Element topoElem = OpmnXmlHelper.getFirstChildElement(notiSrvElem, "topology", true, this.opmnFileName_);
        if (topoElem == null) {
            return;
        }
        OpmnXmlHelper.removeSubElement(topoElem, name, TopologyNodeNames);
    }

    public CompositeData getParameters() {
        return OpmnXmlHelper.getParameters(this.iasnode_, "IasInstance");
    }

    public String getParameter(String category, String paramName) throws ConfigMBeanException {
        return OpmnXmlHelper.getParameter(this.iasnode_, category, paramName, null, null, "IasInstance");
    }

    public void setParameter(String category, String paramName, String paramValue) throws ConfigMBeanException {
        OpmnXmlHelper.setParameter(this.iasnode_, category, paramName, paramValue, null, null, "IasInstance", OrderedSubTags);
    }

    public void removeParameter(String category, String paramName) throws ConfigMBeanException {
        OpmnXmlHelper.removeParameter(this.iasnode_, category, paramName, null, null, "IasInstance");
    }

    public CompositeData[] getEnvironments() {
        return OpmnXmlHelper.getEnvironments(this.iasnode_);
    }

    public CompositeData getEnvironment(String envName) throws ConfigMBeanException {
        return OpmnXmlHelper.getEnvironment(this.iasnode_, envName);
    }

    public void addEnvironment(String envName, String[] envValues, boolean append, boolean conversion) throws ConfigMBeanException {
        OpmnXmlHelper.addEnvironemnt(this.iasnode_, envName, envValues, append, conversion, OrderedSubTags);
    }

    public void appendEnvironment(String envName, String envValue, boolean append, boolean conversion) throws ConfigMBeanException {
        OpmnXmlHelper.appendEnvironement(this.iasnode_, envName, envValue, append, conversion, OrderedSubTags);
    }

    public void removeEnvironment(String envName) throws ConfigMBeanException {
        OpmnXmlHelper.removeEnvironment(this.iasnode_, envName);
    }

    public String getiasInstanceId() {
        return this.iasnode_.getAttribute("id");
    }

    public String getiasInstanceName() {
        return this.iasnode_.getAttribute("name");
    }
}

