/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import java.io.File;
import java.util.Map;
import oracle.oc4j.admin.internal.ApplicationDeployer;
import oracle.oc4j.admin.internal.ConnectorModuleDeployer;
import oracle.oc4j.admin.internal.DeployerIF;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.EarFileUtils;
import oracle.oc4j.admin.management.shared.SharedModuleType;

public class DeployerFactory {
    public static DeployerIF getInstance(DataSink sink, String deploymentName, SharedModuleType moduleType, Map extraParams) {
        DeployerFactory.checkParams(deploymentName, moduleType);
        if (moduleType.equals((Object)SharedModuleType.EAR)) {
            return new ApplicationDeployer(sink, deploymentName, extraParams);
        }
        if (moduleType.isRar()) {
            return new ConnectorModuleDeployer(sink, deploymentName, extraParams);
        }
        File earFile = null;
        String contextRoot = null;
        if (moduleType.equals((Object)SharedModuleType.WAR)) {
            contextRoot = DeployerFactory.getContextRoot(extraParams);
        }
        earFile = EarFileUtils.toEar((DataSink)sink, (SharedModuleType)moduleType, (String)deploymentName, (String)contextRoot);
        DataSink newSink = new DataSink(earFile.getAbsolutePath());
        newSink.setUploadId(sink.getUploadId());
        newSink.setTempFile(true);
        ApplicationDeployer deployer = new ApplicationDeployer(newSink, deploymentName, extraParams);
        return deployer;
    }

    private static void checkParams(String deploymentName, SharedModuleType moduleType) {
        if (deploymentName == null) {
            throw new IllegalArgumentException("DeployerFactory.getInstance(), deploymentName can not be null!");
        }
        if (moduleType == null) {
            throw new IllegalArgumentException("DeployerFactory.getInstance(), moduleType cannot be null!");
        }
    }

    private static String getContextRoot(Map extraParams) {
        if (extraParams == null) {
            return null;
        }
        return (String)extraParams.get("contextRoot");
    }
}

