/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import java.util.Map;
import javax.management.ObjectName;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.StateIntf;
import oracle.oc4j.admin.internal.DeployerCancelException;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.DeployerIF;
import oracle.oc4j.admin.internal.DeployerStateKeeper;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.shared.util.DataSink;
import oracle.oc4j.admin.jmx.shared.util.IdGenerator;

public abstract class DeployerBase
extends Notifier
implements DeployerIF {
    static final String BACKUP = "_backup";
    protected Integer _id;
    protected DataSink _sink;
    protected String _deploymentName;
    protected Map _extraParams;
    private boolean _isVerbose = ApplicationServer.getInstance().getVerbosityLevel() >= 3;

    public DeployerBase(DataSink sink, String deploymentName, Map extraParams) {
        this._sink = sink;
        this._id = this._sink != null ? this._sink.getId() : IdGenerator.getId();
        DeployerStateKeeper.addState(this._id, DeployerStateKeeper.RUNNING);
        this._deploymentName = deploymentName;
        this._extraParams = extraParams;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map execute(boolean isReDeploy) throws DeployerException {
        Map map;
        String[] params = new String[]{this.getNotificationSource().toString(), this._deploymentName};
        try {
            try {
                this.registerNotifierWithThread();
                NounIntf parent = Application.getApplicationNoun(this._deploymentName);
                String units = "msecs";
                long deployStart = System.currentTimeMillis();
                this.sendNotification("START_OPERATION", params);
                ApplicationServer.getInstance().enterDeploymentArea();
                boolean requiresRestart = this.doDeploy(isReDeploy);
                long deployStop = System.currentTimeMillis();
                long deployTime = deployStop - deployStart;
                if (ApplicationServer.DMS_GATE) {
                    StateIntf deploySensor = ApplicationServer.stateFactory().create(parent, "deploy", units, "Deployment sensor for application " + this._deploymentName, deployTime);
                    deploySensor.deriveMetric(511);
                    deploySensor.update(deployTime);
                }
                String msgId = requiresRestart ? "OPERATION_COMPLETES_AND_RESTART_REQUIRED_TIME" : "OPERATION_COMPLETES_TIME";
                String[] fullparams = new String[]{this.getNotificationSource().toString(), this._deploymentName, String.valueOf(deployTime), units};
                this.reportStateChange(msgId, fullparams, 100, requiresRestart);
                map = this.getReturnValues();
                Object var16_18 = null;
            }
            catch (DeployerCancelException dce) {
                this.reportStateChange("OPERATION_CANCELLED", params, 100);
                this.undo(isReDeploy);
                Map units = this.getReturnValues();
                Object var16_19 = null;
                this.unregisterNotifierWithThread();
                this.addOutput();
                ApplicationServer.getInstance().exitDeploymentArea();
                if (this._sink != null) {
                    this._sink.clean();
                }
                DeployerStateKeeper.removeState(this._id);
                this.clean();
                return units;
            }
            catch (DeployerException e) {
                e.printStackTrace();
                this.reportError("OPERATION_FAILED", params, e);
                this.undo(isReDeploy);
                throw (DeployerException)e.fillInStackTrace();
            }
            catch (NoClassDefFoundError ncdf) {
                String[] parms = new String[]{"NoClassDefFoundError:  " + ncdf.getMessage()};
                this.sendNotification("RUNTIME_EXCEPTION", parms);
                this.reportError("OPERATION_FAILED", params, ncdf);
                this.undo(isReDeploy);
                throw new DeployerException("NoClassDefFoundError", ncdf);
            }
            catch (Throwable t) {
                this.reportError("OPERATION_FAILED", params, t);
                this.undo(isReDeploy);
                throw new DeployerException(t);
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.unregisterNotifierWithThread();
            this.addOutput();
            ApplicationServer.getInstance().exitDeploymentArea();
            if (this._sink != null) {
                this._sink.clean();
            }
            DeployerStateKeeper.removeState(this._id);
            this.clean();
            throw throwable;
        }
        this.unregisterNotifierWithThread();
        this.addOutput();
        ApplicationServer.getInstance().exitDeploymentArea();
        if (this._sink != null) {
            this._sink.clean();
        }
        DeployerStateKeeper.removeState(this._id);
        this.clean();
        return map;
    }

    protected void clean() {
        this._sink = null;
        this._extraParams = null;
    }

    public void cancel() throws DeployerException {
        Integer state = (Integer)DeployerStateKeeper.getState(this._id);
        if (state == DeployerStateKeeper.DONE) {
            throw new DeployerException("Operation is already done!");
        }
        if (state == DeployerStateKeeper.CANCEL) {
            throw new DeployerException("Operation is already cancelled!");
        }
        if (state == DeployerStateKeeper.RUNNING) {
            DeployerStateKeeper.setState(this._id, DeployerStateKeeper.CANCEL);
        }
    }

    protected String getNotificationType() {
        return "deploy." + this._deploymentName;
    }

    protected boolean isVerbose() {
        return this._isVerbose;
    }

    protected abstract Object getNotificationSource();

    protected abstract ObjectName getTargetObjectName();

    protected abstract boolean isRar();

    protected abstract boolean doDeploy(boolean var1) throws DeployerException;

    protected abstract void undo(boolean var1);

    protected String getParam(String key) {
        if (this._extraParams == null) {
            return null;
        }
        Object val = this._extraParams.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        return val.toString();
    }

    protected void setParam(String key, Object val) {
        if (this._extraParams != null) {
            this._extraParams.put(key, val);
        }
    }
}

