/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.internal;

import com.evermind.naming.ContextUtils;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.connector.deployment.ConnectorArchive;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EnterpriseArchive;
import java.io.File;
import java.util.ArrayList;
import javax.management.ObjectName;
import javax.naming.Context;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.SharedCodeSource;
import oracle.oc4j.admin.internal.DeployerException;
import oracle.oc4j.admin.internal.UnDeployerBase;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.util.FileUtils;

public class ConnectorModuleUnDeployer
extends UnDeployerBase {
    public ConnectorModuleUnDeployer(String name) {
        super(name);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doUndeploy() throws DeployerException {
        boolean result = false;
        Application application = ApplicationServer.getInstance().getDefaultApplication();
        if (application == null) {
            throw new DeployerException("Default application is not found!");
        }
        ConnectorArchive ca = null;
        File[] codeSources = null;
        try {
            EnterpriseArchive archive = (EnterpriseArchive)application.getConfig();
            ConnectorModule module = archive.getConnectorModuleByName(this._deploymentName);
            if (module == null) {
                throw new DeployerException("Unable to find resource adapter with deployment name '" + this._deploymentName + "'");
            }
            if (module.isDataSourceModule()) {
                throw new DeployerException("You may not undeploy the data sources connector.");
            }
            ca = module.getConnectorArchive();
            if (ca != null) {
                this.checkUndeployment(ca);
                archive.removeConnectorModule(module);
                codeSources = ca.getCodeSources();
                ca.destroy(application.getLogger());
            }
            archive.storeConnectors();
            this.suspendCodeSources(codeSources);
            File connectorsDirectory = null;
            try {
                String connectorsPath = ApplicationServer.getInstance().getConfig().getConnectorDirectory();
                connectorsDirectory = new File(connectorsPath, this._deploymentName);
                FileUtils.recursiveRemove(connectorsDirectory);
            }
            catch (Exception e) {
                this.sendNotification("UNABLE_TO_REMOVE_CONNECTOR_DIR");
            }
            File oc4jRAInstallDir = null;
            try {
                Context context = ContextUtils.getContext(archive.getDeploymentContext(), this._deploymentName, false);
                oc4jRAInstallDir = ContextUtils.getFile(context, true);
                FileUtils.recursiveRemove(oc4jRAInstallDir);
            }
            catch (Exception e) {
                this.sendNotification("UNABLE_TO_REMOVE_CONNECTOR_DIR_IN_APP_DEPLOY");
            }
            if (module.isJMSRAModule()) {
                result = true;
            }
            this.releaseCodeSources(codeSources);
            return result;
        }
        catch (DeployerException e) {
            try {
                e.printStackTrace();
                throw e;
                catch (Exception e2) {
                    throw new DeployerException(e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseCodeSources(codeSources);
                throw throwable;
            }
        }
    }

    protected Object getNotificationSource() {
        return "Connector Module UnDeployer";
    }

    protected ObjectName getTargetObjectName() {
        return ObjectNameFactory.create((String)("oc4j:j2eeType=ResourceAdapterModule,name=" + this._deploymentName + ",J2EEApplication=default,J2EEServer=" + "standalone"));
    }

    protected boolean isRar() {
        return true;
    }

    private void suspendCodeSources(File[] sharedCodeSources) {
        if (sharedCodeSources != null) {
            for (int n = 0; n < sharedCodeSources.length; ++n) {
                SharedCodeSource sharedCodeSource = ClassLoaderQuery.findCodeSource((File)sharedCodeSources[n]);
                if (sharedCodeSource == null) continue;
                sharedCodeSource.suspend();
            }
        }
    }

    private void releaseCodeSources(File[] sharedCodeSources) {
        if (sharedCodeSources != null) {
            for (int n = 0; n < sharedCodeSources.length; ++n) {
                SharedCodeSource sharedCodeSource = ClassLoaderQuery.findCodeSource((File)sharedCodeSources[n]);
                if (sharedCodeSource == null) continue;
                sharedCodeSource.release();
            }
        }
    }

    private void checkUndeployment(ConnectorArchive ca) throws DeployerException {
        ArrayList apps = new ArrayList();
        if (ca.checkForActiveEndpoints(apps)) {
            throw new DeployerException("Unable to undeploy resource adapter with deployment name '" + ca.getName() + "' due to active endpoints in application: " + apps + " Please stop the application first before undeploying the resource adapter");
        }
    }
}

