/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogFormatter;

public class TraceLogger {
    private static HashMap _loggerCache = new HashMap();
    private static String[] _fineLoggers;
    private static String[] _finerLoggers;
    private static String[] _finestLoggers;
    private static Handler TRACE_HANDLER;
    private static Formatter FORMATTER;
    private static Level DEFAULT_LEVEL;

    public static Logger getLogger(Class aClass) {
        if (_loggerCache.get(aClass.getName()) != null) {
            return (Logger)_loggerCache.get(aClass.getName());
        }
        Logger logger = Logger.getLogger(aClass.getName());
        logger.addHandler(TRACE_HANDLER);
        logger.setUseParentHandlers(false);
        _loggerCache.put(aClass.getName(), logger);
        if (DEFAULT_LEVEL != null) {
            logger.setLevel(DEFAULT_LEVEL);
        } else {
            Level level = TraceLogger.getDynamicLevel(logger.getName());
            if (level != null) {
                logger.setLevel(level);
            }
        }
        return logger;
    }

    public static boolean isTraceLogger(String loggerName) {
        return loggerName != null && _loggerCache.get(loggerName) != null;
    }

    public static void setDefaultLevel(Level defaultLevel) {
        DEFAULT_LEVEL = defaultLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Level getDynamicLevel(String loggerName) {
        HashMap hashMap = _loggerCache;
        synchronized (hashMap) {
            if (_fineLoggers == null) {
                _fineLoggers = TraceLogger.getEnabledLoggers("oracle.oc4j.trace.fine");
                _finerLoggers = TraceLogger.getEnabledLoggers("oracle.oc4j.trace.finer");
                _finestLoggers = TraceLogger.getEnabledLoggers("oracle.oc4j.trace.finest");
            }
        }
        if (TraceLogger.isDynamicallyEnabled(_fineLoggers, loggerName)) {
            return Level.FINE;
        }
        if (TraceLogger.isDynamicallyEnabled(_finerLoggers, loggerName)) {
            return Level.FINER;
        }
        if (TraceLogger.isDynamicallyEnabled(_finestLoggers, loggerName)) {
            return Level.FINEST;
        }
        return null;
    }

    private static boolean isDynamicallyEnabled(String[] loggerNames, String loggerName) {
        for (int i = 0; i < loggerNames.length; ++i) {
            String name = loggerNames[i];
            if (name.equals(loggerName)) {
                return true;
            }
            if (!loggerName.startsWith(name + '.')) continue;
            return true;
        }
        return false;
    }

    private static String[] getEnabledLoggers(String propertyName) {
        ArrayList<String> enable = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, ""), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            enable.add(token);
        }
        String[] list = enable.toArray(new String[enable.size()]);
        return list;
    }

    static {
        TRACE_HANDLER = new TraceLoggerHandler();
        FORMATTER = new TraceLogFormatter();
        DEFAULT_LEVEL = null;
    }

    static class TraceLoggerHandler
    extends Handler {
        TraceLoggerHandler() {
        }

        public void publish(LogRecord record) {
            System.out.println(FORMATTER.format(record));
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

