/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.deployment;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.deployment.DeploymentMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;

public class DeploymentMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.deployment", DeploymentMessageBundle.class.getName());

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningApplicationConfigHasNoMatchingEntry(String tagName, String value) {
        m_logger.log(Level.WARNING, "J2EE DEP-00001", new Object[]{tagName, value});
    }

    public static void warningDuplicateServletMapping(String value1, String value2) {
        m_logger.log(Level.WARNING, "J2EE DEP-00002", new Object[]{value1, value2});
    }

    public static String warningDuplicateConnectorName(String connectorName, String appName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DEP-00003", new Object[]{connectorName, appName});
    }

    public static void warningInvalidOjspInitAttrName(Object[] params) {
        if (DeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE DEP-00004", params);
        }
    }

    public static void fineOverrideReference(String name) {
        if (DeploymentMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE DEP-00005", new Object[]{name});
        }
    }
}

