/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.datasource;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.datasource.DataSourceMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingMessages;
import oracle.j2ee.util.LoggingUtils;

public class DataSourceMessages
extends LoggingMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.datasource", DataSourceMessageBundle.class.getName());
    public static boolean LOG_LEVEL_FINEST_OR_HIGHER = false;
    public static boolean LOG_LEVEL_FINER_OR_HIGHER = false;
    public static boolean LOG_LEVEL_FINE_OR_HIGHER = false;
    public static boolean LOG_LEVEL_CONFIG_OR_HIGHER = false;
    public static boolean LOG_LEVEL_INFO_OR_HIGHER = true;
    public static boolean LOG_LEVEL_WARNING_OR_HIGHER = false;
    public static boolean LOG_LEVEL_SEVERE_OR_HIGHER = false;

    public DataSourceMessages() {
        this.init();
    }

    protected Logger getLogger() {
        return m_logger;
    }

    public void setLogLevels(boolean finestOrHigher, boolean finerOrHigher, boolean fineOrHigher, boolean configOrHigher, boolean infoOrHigher, boolean warningOrHigher, boolean severOrHiger) {
        LOG_LEVEL_FINEST_OR_HIGHER = finestOrHigher;
        LOG_LEVEL_FINER_OR_HIGHER = finerOrHigher;
        LOG_LEVEL_FINE_OR_HIGHER = fineOrHigher;
        LOG_LEVEL_CONFIG_OR_HIGHER = configOrHigher;
        LOG_LEVEL_INFO_OR_HIGHER = infoOrHigher;
        LOG_LEVEL_WARNING_OR_HIGHER = warningOrHigher;
        LOG_LEVEL_SEVERE_OR_HIGHER = severOrHiger;
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static String warningTestConnectionException(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00001", new Object[]{exception});
    }

    public static void warningTestConnectionCloseXAConnection(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00002", new Object[]{exception});
    }

    public static String severeDataSourceConnectionPoolConstructorResourceAdapterNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00003");
    }

    public static String severeDataSourceConnectionPoolConstructorConfigurationNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00004");
    }

    public static void warningDataSourceConnectionPoolConstructorAppNameNull() {
        m_logger.log(Level.WARNING, "J2EE DS-00005");
    }

    public static String warningDataSourceConnectionPoolSetMinConnections(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00006", new Object[]{exception});
    }

    public static String warningDataSourceConnectionPoolSetMaxConnections(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00007", new Object[]{exception});
    }

    public static String warningDataSourceConnectionPoolSetInitialCapacity(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00008", new Object[]{exception});
    }

    public static String warningDataSourceConnectionPoolSetUsedConnectionWaitTimeout(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00009", new Object[]{exception});
    }

    public static String warningDataSourceConnectionPoolSetInactivityTimeout(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00010", new Object[]{exception});
    }

    public static String warningDataSourceConnectionPoolSetCacheManagerProperty(String property, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00011", new Object[]{property, exception});
    }

    public static String warningDataSourceConnectionPoolRefreshConnectionPool(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00012", new Object[]{exception});
    }

    public static void warningDataSourceConnectionPoolStopOracleDataSource(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00013", new Object[]{exception});
    }

    public static void warningDataSourceConnectionPoolStopOracleDataSourceNoSuchMethodError() {
        m_logger.log(Level.WARNING, "J2EE DS-00014");
    }

    public static void warningDataSourceConnectionPoolUnkownEventEncountered(int event) {
        m_logger.log(Level.WARNING, "J2EE DS-00015", new Object[]{new Integer(event)});
    }

    public static String severeSetDataSourceProperty(String propertyName, Throwable exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00020", new Object[]{propertyName, exception});
    }

    public static void warningSetProperty(String propertyName, String value, String objName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00021", new Object[]{propertyName, value, objName, exception});
    }

    public static String severeSetUser(String objName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00022", new Object[]{objName, exception});
    }

    public static String severeSetPassword(String objName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00023", new Object[]{objName, exception});
    }

    public static String severeSetUrl(String objName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00024", new Object[]{objName, exception});
    }

    public static String severeCreateNativeDataSource(String dataSourceName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00025", new Object[]{dataSourceName, exception});
    }

    public static String severeConnectorConnectionPoolSetMinConnections(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00026", new Object[]{connectionPoolName, exception});
    }

    public static String severeConnectorConnectionPoolSetMaxConnections(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00027", new Object[]{connectionPoolName, exception});
    }

    public static String severeConnectorConnectionPoolSetWaitTimeout(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00028", new Object[]{connectionPoolName, exception});
    }

    public static String severeConnectorConnectionPoolSetInactivityTimeout(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00029", new Object[]{connectionPoolName, exception});
    }

    public static String severeConnectorConnectionPoolSetScheme(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00030", new Object[]{connectionPoolName, exception});
    }

    public static String severeConnectorConnectionPoolSetInitialCapacity(String connectionPoolName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00031", new Object[]{connectionPoolName, exception});
    }

    public static void warningDriverProperties(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00040", new Object[]{exception});
    }

    public static void warningSetDriverPropertyNull() {
        m_logger.log(Level.WARNING, "J2EE DS-00041");
    }

    public static void infoSetDriverProperty(String key, String value) {
        if (DataSourceMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE DS-00042", new Object[]{key, value});
        }
    }

    public static void infoDynamicProxyClassCreated(String proxyClassName, String superClassName, String targetClassName) {
        if (DataSourceMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE DS-00240", new Object[]{proxyClassName, superClassName, targetClassName});
        }
    }

    public static String severeDynamicProxyClassCreation(String className, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00241", new Object[]{className, exception});
    }

    public static String severePreInvokeInBuildMethod(String className) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00250", new Object[]{className});
    }

    public static String severeIntercept(Exception e) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00260", new Object[]{e});
    }

    public static String severeAssociateManagedConnection(Exception e) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00261", new Object[]{e});
    }

    public static String warningGlobalTxActive(String methodName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00262", new Object[]{methodName});
    }

    public static String warningClosedHandle(Object handle) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00263", new Object[]{handle});
    }

    public static String severeInvalidHandle(Object handle) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00264", new Object[]{handle});
    }

    public static String warningUnclosedConnection(Object connection, Throwable throwable) {
        String stackTrace = "";
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            stackTrace = sw.toString();
        }
        String msg = LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00265", new Object[]{connection, stackTrace});
        return msg;
    }

    public static void infoFatalErrorDetected(int errorCode, Exception e) {
        m_logger.log(Level.INFO, "J2EE DS-00266", new Object[]{new Integer(errorCode), e});
    }

    public static void warningHandleFatalErrorException(Exception e) {
        m_logger.log(Level.WARNING, "J2EE DS-00267", new Object[]{e});
    }

    public static String severeCreateDriverDataSourceException(String factoryClassName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00050", new Object[]{factoryClassName, exception});
    }

    public static String finerUncommittedLocalTxDetected() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.FINER, "J2EE DS-00270", new Object[0]);
    }

    public static String severeSetDataSourceLoginTimeout(String objectName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00051", new Object[]{objectName, exception});
    }

    public static String severeSetConnectionPoolDataSourceLoginTimeout(String objectName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00052", new Object[]{objectName, exception});
    }

    public static String severeSetXADataSourceLoginTimeout(String objectName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00053", new Object[]{objectName, exception});
    }

    public static void warningExceptionSettingProxyInterfaces(String sqlObject, String interfaceName) {
        m_logger.log(Level.WARNING, "J2EE DS-00054", new Object[]{sqlObject, interfaceName});
    }

    public static void warningClassNotFoundExceptionCreatingProxyInterface(String interfaceName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00055", new Object[]{interfaceName, exception});
    }

    public static String warningLegacyDataSourcesConfigRootNodeNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00060");
    }

    public static void warningExceptionParsingLegacyDataSourcesConfig(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00061", new Object[]{exception});
    }

    public static void warningExceptionParsingLegacyDataSourcesConfigMap(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00062", new Object[]{exception});
    }

    public static void warningUnregisterDependentsException(String objectName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00070", new Object[]{objectName, exception});
    }

    public static void warningUpdatePoolSizeUpperBoundGetMaxConnections(String poolName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00080", new Object[]{poolName, exception});
    }

    public static void warningUpdatePoolSizeLowerBoundGetMinConnections(String poolName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00081", new Object[]{poolName, exception});
    }

    public static void warningUpdatePoolSizesGetPoolSizes(String poolName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00082", new Object[]{poolName, exception});
    }

    public static void warningGettingICCStatistics(String cacheName, Throwable exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00083", new Object[]{cacheName, exception});
    }

    public static String warningDMSJDBCConnectionStatsStatNameNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00090");
    }

    public static String warningDMSJDBCConnectionStatsDMSTypNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00091");
    }

    public static String warningJDBCConnectionStatsImplMBeanNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00100");
    }

    public static String warningJDBCConnectionStatsImplDMSConnectionStatsNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00101");
    }

    public static void warningJDBCConnectionStatsImplGetJdbcDataSource(String objectName) {
        m_logger.log(Level.WARNING, "J2EE DS-00102", new Object[]{objectName});
    }

    public static String severeManagedJDBCDataSourcePoolNameNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00110");
    }

    public static String severeManagedJDBCDataSourceCallbackNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00111");
    }

    public static String severeManagedJDBCDataSourceApplicationCallbackNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00112");
    }

    public static String severeManagedJDBCDataSourceManagedDataSourceNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00113");
    }

    public static String severeManagedJDBCDataSourceManagedDataSourceConfigNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00114");
    }

    public static String warningManagedJDBCDataSourceTestConnection(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00115", new Object[]{exception});
    }

    public static void warningManagedJDBCDataSourceTestConnectionCloseConnection(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00116", new Object[]{exception});
    }

    public static String severeManagedJDBCDataSourceCallBackImplManagedDataSourceNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00120");
    }

    public static String severeManagedJDBCDataSourceCallBackImplManagedDataSourceConfigNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00121");
    }

    public static String warningNativeJDBCDataSourceTestConnection(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00130", new Object[]{exception});
    }

    public static void warningNativeJDBCDataSourceTestConnectionCloseConnection(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00131", new Object[]{exception});
    }

    public static String severeManagedConnectionFactorySetResourceAdapterInvalidImplementationClass(String implClass) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00140", new Object[]{implClass});
    }

    public static String warningManagedConnectionFactorySetManagedDataSourceConfigXML(String poolName) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00141", new Object[]{poolName});
    }

    public static String severeManagedConnectionFactorySetDataSourceConnectionPool() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00142");
    }

    public static void warningResourceAdapterStopRemoveConnectionPool(String poolName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00150", new Object[]{poolName, exception.getMessage()});
    }

    public static String severeTxStateHandleInvalidAction(String action, String state) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00160", new Object[]{action, state});
    }

    public static void infoXAResourceWrapperIsSameRmCalled() {
        if (DataSourceMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE DS-00170");
        }
    }

    public static String warningEmulatedXAResourceCommitXidNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00180");
    }

    public static String warningEmulatedXAResourceCommitFailed() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00181");
    }

    public static String warningEmulatedXAResourceSetAutoCommitFailed(Exception e) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00190", new Object[]{e});
    }

    public static String warningEmulatedXAResourceEndXidNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00182");
    }

    public static String warningEmulatedXAResourceForget() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00183");
    }

    public static String warningEmulatedXAResourcePrepareXidNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00184");
    }

    public static String warningEmulatedXAResourcePrepareCommitFailed(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00185", new Object[]{exception});
    }

    public static String warningEmulatedXAResourceRecover() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00186");
    }

    public static String warningEmulatedXAResourceRollbackXidNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00187");
    }

    public static String warningEmulatedXAResourceRollbackFailed(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00188", new Object[]{exception});
    }

    public static String warningEmulatedXAResourceStartXidNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00188");
    }

    public static String warningEmulatedXAResourcePhysicalConnectionNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.WARNING, "J2EE DS-00189");
    }

    public static String severeICCOracleXADataSourceNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00210");
    }

    public static String severeICCGetXAResource(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00211", new Object[]{exception});
    }

    public static String severeICCExecuteXAResource(Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00212", new Object[]{exception});
    }

    public static String severeOracleXADataSourceNull() {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00220");
    }

    public static void warningMCI_InitStatementCacheClosePreparedStatement(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00230", new Object[]{exception.getMessage()});
    }

    public static void warningMCI_DestroyStatementCacheClosePreparedStatement(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00231", new Object[]{exception.getMessage()});
    }

    public static void warningMCI_activateOracleSQLTraceException(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00232", new Object[]{exception.getMessage()});
    }

    public static void warningMCI_activateOracleSQLTraceCloseException(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00233", new Object[]{exception.getMessage()});
    }

    public static void warningMCI_deactivateOracleSQLTraceException(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00234", new Object[]{exception.getMessage()});
    }

    public static void warningMCI_deactivateOracleSQLTraceCloseException(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE DS-00235", new Object[]{exception.getMessage()});
    }

    public static String severeConfigCreateXMLException(String configObjectName, Exception exception) {
        return LoggingUtils.logAndReturnMessage(m_logger, Level.SEVERE, "J2EE DS-00280", new Object[]{configObjectName, exception});
    }

    public static void debugBeforeGetConnection(Object connectionFactory) {
        m_logger.log(Level.FINER, "J2EE DS-00310", new Object[]{connectionFactory});
    }

    public static void debugAfterGetConnection(Object connectionFactory) {
        m_logger.log(Level.FINER, "J2EE DS-00311", new Object[]{connectionFactory});
    }

    public static void warningSQLExceptionDuringGetTransactionIsolation(SQLException connectionFactory) {
        m_logger.log(Level.FINER, "J2EE DS-00312", new Object[]{connectionFactory});
    }

    public static void warningSQLExceptionDuringResetTransactionIsolation(SQLException connectionFactory) {
        m_logger.log(Level.FINER, "J2EE DS-00313", new Object[]{connectionFactory});
    }
}

