/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.connector.transaction;

import com.evermind.server.ThreadState;
import com.evermind.server.WrappedXAResource;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.tpc.RMFactoryJndiLocation;
import oracle.as.j2ee.transaction.tpc.RMId;

public class XAResourceWrapper
implements XAResource,
WrappedXAResource,
RMId,
Serializable {
    private transient XAResource m_xares;
    private String m_rmFactoryJndiLocation;
    private String m_rmFactoryArg;
    private boolean m_useFastSuspend = false;

    public XAResourceWrapper(XAResource xares, String rmFactoryJndiLocation, String rmFactoryArg) {
        this.m_xares = xares;
        this.m_rmFactoryJndiLocation = rmFactoryJndiLocation;
        if (ThreadState.getCurrentState().getContextContainer() != null) {
            String appName = null;
            try {
                appName = ThreadState.getCurrentState().getContextContainer().getApplication().getName();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            this.m_rmFactoryArg = XAResourceWrapper.getRMFactoryArgString(appName, rmFactoryArg);
        } else {
            this.m_rmFactoryArg = rmFactoryArg;
        }
    }

    public static String getRMFactoryArgString(String appName, String rmFactoryArg) {
        return appName.length() + "_" + appName + rmFactoryArg;
    }

    public XAResourceWrapper(XAResource xares, String rmFactoryJndiLocation, String rmFactoryArg, boolean useFastSuspend) {
        this(xares, rmFactoryJndiLocation, rmFactoryArg);
        this.m_useFastSuspend = useFastSuspend;
    }

    public void commit(Xid xid, boolean b) throws XAException {
        this.nonNullXAResourceCheck();
        this.m_xares.commit(xid, b);
    }

    public void start(Xid xid, int flag) throws XAException {
        this.nonNullXAResourceCheck();
        if (!this.m_useFastSuspend || flag != 0x8000000) {
            this.m_xares.start(xid, flag);
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        this.nonNullXAResourceCheck();
        if (!this.m_useFastSuspend || flag != 0x2000000) {
            this.m_xares.end(xid, flag);
        }
    }

    public void forget(Xid xid) throws XAException {
        this.nonNullXAResourceCheck();
        this.m_xares.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        this.nonNullXAResourceCheck();
        return this.m_xares.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        throw new XAException("isSameRM() should not be called on an XAResource wrapper.");
    }

    public int prepare(Xid xid) throws XAException {
        this.nonNullXAResourceCheck();
        return this.m_xares.prepare(xid);
    }

    public Xid[] recover(int i) throws XAException {
        this.nonNullXAResourceCheck();
        return this.m_xares.recover(i);
    }

    public void rollback(Xid xid) throws XAException {
        this.nonNullXAResourceCheck();
        this.m_xares.rollback(xid);
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        this.nonNullXAResourceCheck();
        return this.m_xares.setTransactionTimeout(i);
    }

    public RMFactoryJndiLocation getRMFactoryJndiLocation() {
        return new RMFactoryJndiLocation(){

            public String getJndiLocation() {
                return XAResourceWrapper.this.m_rmFactoryJndiLocation;
            }
        };
    }

    public String getRMFactoryArg() {
        return this.m_rmFactoryArg;
    }

    private void nonNullXAResourceCheck() throws XAException {
        if (this.m_xares == null) {
            throw new XAException("Internal error: Wrapped XAResource cannot be null");
        }
    }

    public XAResource getWrappedResource() {
        return this.m_xares;
    }

    public String toString() {
        if (this.m_xares == null) {
            return super.toString();
        }
        return this.m_xares.toString();
    }
}

